
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "allowHostDirVolumePlugin",
    "allowHostIPC",
    "allowHostNetwork",
    "allowHostPID",
    "allowHostPorts",
    "allowPrivilegedContainer",
    "allowedCapabilities",
    "defaultAddCapabilities",
    "fsGroup",
    "groups",
    "priority",
    "readOnlyRootFilesystem",
    "requiredDropCapabilities",
    "runAsUser",
    "seLinuxContext",
    "seccompProfiles",
    "supplementalGroups",
    "users",
    "volumes"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class SecurityContextConstraints implements HasMetadata
{

    /**
     * allow the use of the host dir volume plugin
     * 
     */
    @JsonProperty("allowHostDirVolumePlugin")
    private Boolean allowHostDirVolumePlugin;
    /**
     * allow the use of the host ipc in the containers
     * 
     */
    @JsonProperty("allowHostIPC")
    private Boolean allowHostIPC;
    /**
     * allow the use of the hostNetwork in the pod spec
     * 
     */
    @JsonProperty("allowHostNetwork")
    private Boolean allowHostNetwork;
    /**
     * allow the use of the host pid in the containers
     * 
     */
    @JsonProperty("allowHostPID")
    private Boolean allowHostPID;
    /**
     * allow the use of the host ports in the containers
     * 
     */
    @JsonProperty("allowHostPorts")
    private Boolean allowHostPorts;
    /**
     * allow containers to run as privileged
     * 
     */
    @JsonProperty("allowPrivilegedContainer")
    private Boolean allowPrivilegedContainer;
    /**
     * capabilities that are allowed to be added
     * 
     */
    @JsonProperty("allowedCapabilities")
    @Valid
    private List<String> allowedCapabilities = new ArrayList<String>();
    /**
     * 
     * (Required)
     * 
     */
    @NotNull
    @JsonProperty("apiVersion")
    private String apiVersion = "v1";
    /**
     * capabilities that are added by default but may be dropped
     * 
     */
    @JsonProperty("defaultAddCapabilities")
    @Valid
    private List<String> defaultAddCapabilities = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("fsGroup")
    @Valid
    private FSGroupStrategyOptions fsGroup;
    /**
     * groups allowed to use this SecurityContextConstraints
     * 
     */
    @JsonProperty("groups")
    @Valid
    private List<String> groups = new ArrayList<String>();
    /**
     * 
     * (Required)
     * 
     */
    @NotNull
    @JsonProperty("kind")
    private String kind = "SecurityContextConstraints";
    /**
     * 
     * 
     */
    @JsonProperty("metadata")
    @Valid
    @CheckObjectMeta(regexp = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$", max = 253)
    private ObjectMeta metadata;
    /**
     * determines which SCC is used when multiple SCCs allow a particular pod; higher priority SCCs are preferred
     * 
     */
    @JsonProperty("priority")
    private Integer priority;
    /**
     * require containers to run with a read only root filesystem
     * 
     */
    @JsonProperty("readOnlyRootFilesystem")
    private Boolean readOnlyRootFilesystem;
    /**
     * capabilities that will be dropped by default and may not be added
     * 
     */
    @JsonProperty("requiredDropCapabilities")
    @Valid
    private List<String> requiredDropCapabilities = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("runAsUser")
    @Valid
    private RunAsUserStrategyOptions runAsUser;
    /**
     * 
     * 
     */
    @JsonProperty("seLinuxContext")
    @Valid
    private SELinuxContextStrategyOptions seLinuxContext;
    /**
     * seccomp profiles allowed to be used by pods and containers
     * 
     */
    @JsonProperty("seccompProfiles")
    @Valid
    private List<String> seccompProfiles = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("supplementalGroups")
    @Valid
    private SupplementalGroupsStrategyOptions supplementalGroups;
    /**
     * users allowed to use this SecurityContextConstraints
     * 
     */
    @JsonProperty("users")
    @Valid
    private List<String> users = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("volumes")
    @Valid
    private List<String> volumes = new ArrayList<String>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public SecurityContextConstraints() {
    }

    /**
     * 
     * @param defaultAddCapabilities
     * @param metadata
     * @param seLinuxContext
     * @param fsGroup
     * @param kind
     * @param seccompProfiles
     * @param allowHostNetwork
     * @param volumes
     * @param allowHostPID
     * @param groups
     * @param requiredDropCapabilities
     * @param allowHostDirVolumePlugin
     * @param allowHostPorts
     * @param priority
     * @param users
     * @param allowedCapabilities
     * @param readOnlyRootFilesystem
     * @param runAsUser
     * @param apiVersion
     * @param allowPrivilegedContainer
     * @param allowHostIPC
     * @param supplementalGroups
     */
    public SecurityContextConstraints(Boolean allowHostDirVolumePlugin, Boolean allowHostIPC, Boolean allowHostNetwork, Boolean allowHostPID, Boolean allowHostPorts, Boolean allowPrivilegedContainer, List<String> allowedCapabilities, String apiVersion, List<String> defaultAddCapabilities, FSGroupStrategyOptions fsGroup, List<String> groups, String kind, ObjectMeta metadata, Integer priority, Boolean readOnlyRootFilesystem, List<String> requiredDropCapabilities, RunAsUserStrategyOptions runAsUser, SELinuxContextStrategyOptions seLinuxContext, List<String> seccompProfiles, SupplementalGroupsStrategyOptions supplementalGroups, List<String> users, List<String> volumes) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        this.allowHostIPC = allowHostIPC;
        this.allowHostNetwork = allowHostNetwork;
        this.allowHostPID = allowHostPID;
        this.allowHostPorts = allowHostPorts;
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        this.allowedCapabilities = allowedCapabilities;
        this.apiVersion = apiVersion;
        this.defaultAddCapabilities = defaultAddCapabilities;
        this.fsGroup = fsGroup;
        this.groups = groups;
        this.kind = kind;
        this.metadata = metadata;
        this.priority = priority;
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        this.requiredDropCapabilities = requiredDropCapabilities;
        this.runAsUser = runAsUser;
        this.seLinuxContext = seLinuxContext;
        this.seccompProfiles = seccompProfiles;
        this.supplementalGroups = supplementalGroups;
        this.users = users;
        this.volumes = volumes;
    }

    /**
     * allow the use of the host dir volume plugin
     * 
     * @return
     *     The allowHostDirVolumePlugin
     */
    @JsonProperty("allowHostDirVolumePlugin")
    public Boolean getAllowHostDirVolumePlugin() {
        return allowHostDirVolumePlugin;
    }

    /**
     * allow the use of the host dir volume plugin
     * 
     * @param allowHostDirVolumePlugin
     *     The allowHostDirVolumePlugin
     */
    @JsonProperty("allowHostDirVolumePlugin")
    public void setAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
    }

    /**
     * allow the use of the host ipc in the containers
     * 
     * @return
     *     The allowHostIPC
     */
    @JsonProperty("allowHostIPC")
    public Boolean getAllowHostIPC() {
        return allowHostIPC;
    }

    /**
     * allow the use of the host ipc in the containers
     * 
     * @param allowHostIPC
     *     The allowHostIPC
     */
    @JsonProperty("allowHostIPC")
    public void setAllowHostIPC(Boolean allowHostIPC) {
        this.allowHostIPC = allowHostIPC;
    }

    /**
     * allow the use of the hostNetwork in the pod spec
     * 
     * @return
     *     The allowHostNetwork
     */
    @JsonProperty("allowHostNetwork")
    public Boolean getAllowHostNetwork() {
        return allowHostNetwork;
    }

    /**
     * allow the use of the hostNetwork in the pod spec
     * 
     * @param allowHostNetwork
     *     The allowHostNetwork
     */
    @JsonProperty("allowHostNetwork")
    public void setAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
    }

    /**
     * allow the use of the host pid in the containers
     * 
     * @return
     *     The allowHostPID
     */
    @JsonProperty("allowHostPID")
    public Boolean getAllowHostPID() {
        return allowHostPID;
    }

    /**
     * allow the use of the host pid in the containers
     * 
     * @param allowHostPID
     *     The allowHostPID
     */
    @JsonProperty("allowHostPID")
    public void setAllowHostPID(Boolean allowHostPID) {
        this.allowHostPID = allowHostPID;
    }

    /**
     * allow the use of the host ports in the containers
     * 
     * @return
     *     The allowHostPorts
     */
    @JsonProperty("allowHostPorts")
    public Boolean getAllowHostPorts() {
        return allowHostPorts;
    }

    /**
     * allow the use of the host ports in the containers
     * 
     * @param allowHostPorts
     *     The allowHostPorts
     */
    @JsonProperty("allowHostPorts")
    public void setAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
    }

    /**
     * allow containers to run as privileged
     * 
     * @return
     *     The allowPrivilegedContainer
     */
    @JsonProperty("allowPrivilegedContainer")
    public Boolean getAllowPrivilegedContainer() {
        return allowPrivilegedContainer;
    }

    /**
     * allow containers to run as privileged
     * 
     * @param allowPrivilegedContainer
     *     The allowPrivilegedContainer
     */
    @JsonProperty("allowPrivilegedContainer")
    public void setAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
    }

    /**
     * capabilities that are allowed to be added
     * 
     * @return
     *     The allowedCapabilities
     */
    @JsonProperty("allowedCapabilities")
    public List<String> getAllowedCapabilities() {
        return allowedCapabilities;
    }

    /**
     * capabilities that are allowed to be added
     * 
     * @param allowedCapabilities
     *     The allowedCapabilities
     */
    @JsonProperty("allowedCapabilities")
    public void setAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities = allowedCapabilities;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public String getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * capabilities that are added by default but may be dropped
     * 
     * @return
     *     The defaultAddCapabilities
     */
    @JsonProperty("defaultAddCapabilities")
    public List<String> getDefaultAddCapabilities() {
        return defaultAddCapabilities;
    }

    /**
     * capabilities that are added by default but may be dropped
     * 
     * @param defaultAddCapabilities
     *     The defaultAddCapabilities
     */
    @JsonProperty("defaultAddCapabilities")
    public void setDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        this.defaultAddCapabilities = defaultAddCapabilities;
    }

    /**
     * 
     * 
     * @return
     *     The fsGroup
     */
    @JsonProperty("fsGroup")
    public FSGroupStrategyOptions getFsGroup() {
        return fsGroup;
    }

    /**
     * 
     * 
     * @param fsGroup
     *     The fsGroup
     */
    @JsonProperty("fsGroup")
    public void setFsGroup(FSGroupStrategyOptions fsGroup) {
        this.fsGroup = fsGroup;
    }

    /**
     * groups allowed to use this SecurityContextConstraints
     * 
     * @return
     *     The groups
     */
    @JsonProperty("groups")
    public List<String> getGroups() {
        return groups;
    }

    /**
     * groups allowed to use this SecurityContextConstraints
     * 
     * @param groups
     *     The groups
     */
    @JsonProperty("groups")
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    /**
     * 
     * (Required)
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    /**
     * 
     * 
     * @return
     *     The metadata
     */
    @JsonProperty("metadata")
    public ObjectMeta getMetadata() {
        return metadata;
    }

    /**
     * 
     * 
     * @param metadata
     *     The metadata
     */
    @JsonProperty("metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    /**
     * determines which SCC is used when multiple SCCs allow a particular pod; higher priority SCCs are preferred
     * 
     * @return
     *     The priority
     */
    @JsonProperty("priority")
    public Integer getPriority() {
        return priority;
    }

    /**
     * determines which SCC is used when multiple SCCs allow a particular pod; higher priority SCCs are preferred
     * 
     * @param priority
     *     The priority
     */
    @JsonProperty("priority")
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    /**
     * require containers to run with a read only root filesystem
     * 
     * @return
     *     The readOnlyRootFilesystem
     */
    @JsonProperty("readOnlyRootFilesystem")
    public Boolean getReadOnlyRootFilesystem() {
        return readOnlyRootFilesystem;
    }

    /**
     * require containers to run with a read only root filesystem
     * 
     * @param readOnlyRootFilesystem
     *     The readOnlyRootFilesystem
     */
    @JsonProperty("readOnlyRootFilesystem")
    public void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
    }

    /**
     * capabilities that will be dropped by default and may not be added
     * 
     * @return
     *     The requiredDropCapabilities
     */
    @JsonProperty("requiredDropCapabilities")
    public List<String> getRequiredDropCapabilities() {
        return requiredDropCapabilities;
    }

    /**
     * capabilities that will be dropped by default and may not be added
     * 
     * @param requiredDropCapabilities
     *     The requiredDropCapabilities
     */
    @JsonProperty("requiredDropCapabilities")
    public void setRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        this.requiredDropCapabilities = requiredDropCapabilities;
    }

    /**
     * 
     * 
     * @return
     *     The runAsUser
     */
    @JsonProperty("runAsUser")
    public RunAsUserStrategyOptions getRunAsUser() {
        return runAsUser;
    }

    /**
     * 
     * 
     * @param runAsUser
     *     The runAsUser
     */
    @JsonProperty("runAsUser")
    public void setRunAsUser(RunAsUserStrategyOptions runAsUser) {
        this.runAsUser = runAsUser;
    }

    /**
     * 
     * 
     * @return
     *     The seLinuxContext
     */
    @JsonProperty("seLinuxContext")
    public SELinuxContextStrategyOptions getSeLinuxContext() {
        return seLinuxContext;
    }

    /**
     * 
     * 
     * @param seLinuxContext
     *     The seLinuxContext
     */
    @JsonProperty("seLinuxContext")
    public void setSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        this.seLinuxContext = seLinuxContext;
    }

    /**
     * seccomp profiles allowed to be used by pods and containers
     * 
     * @return
     *     The seccompProfiles
     */
    @JsonProperty("seccompProfiles")
    public List<String> getSeccompProfiles() {
        return seccompProfiles;
    }

    /**
     * seccomp profiles allowed to be used by pods and containers
     * 
     * @param seccompProfiles
     *     The seccompProfiles
     */
    @JsonProperty("seccompProfiles")
    public void setSeccompProfiles(List<String> seccompProfiles) {
        this.seccompProfiles = seccompProfiles;
    }

    /**
     * 
     * 
     * @return
     *     The supplementalGroups
     */
    @JsonProperty("supplementalGroups")
    public SupplementalGroupsStrategyOptions getSupplementalGroups() {
        return supplementalGroups;
    }

    /**
     * 
     * 
     * @param supplementalGroups
     *     The supplementalGroups
     */
    @JsonProperty("supplementalGroups")
    public void setSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
    }

    /**
     * users allowed to use this SecurityContextConstraints
     * 
     * @return
     *     The users
     */
    @JsonProperty("users")
    public List<String> getUsers() {
        return users;
    }

    /**
     * users allowed to use this SecurityContextConstraints
     * 
     * @param users
     *     The users
     */
    @JsonProperty("users")
    public void setUsers(List<String> users) {
        this.users = users;
    }

    /**
     * 
     * 
     * @return
     *     The volumes
     */
    @JsonProperty("volumes")
    public List<String> getVolumes() {
        return volumes;
    }

    /**
     * 
     * 
     * @param volumes
     *     The volumes
     */
    @JsonProperty("volumes")
    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
