
package io.fabric8.kubernetes.api.model.extensions;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "cpuUtilization",
    "maxReplicas",
    "minReplicas",
    "scaleRef"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class HorizontalPodAutoscalerSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("cpuUtilization")
    @Valid
    private CPUTargetUtilization cpuUtilization;
    /**
     * 
     * 
     */
    @JsonProperty("maxReplicas")
    private Integer maxReplicas;
    /**
     * 
     * 
     */
    @JsonProperty("minReplicas")
    private Integer minReplicas;
    /**
     * 
     * 
     */
    @JsonProperty("scaleRef")
    @Valid
    private SubresourceReference scaleRef;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public HorizontalPodAutoscalerSpec() {
    }

    /**
     * 
     * @param cpuUtilization
     * @param maxReplicas
     * @param minReplicas
     * @param scaleRef
     */
    public HorizontalPodAutoscalerSpec(CPUTargetUtilization cpuUtilization, Integer maxReplicas, Integer minReplicas, SubresourceReference scaleRef) {
        this.cpuUtilization = cpuUtilization;
        this.maxReplicas = maxReplicas;
        this.minReplicas = minReplicas;
        this.scaleRef = scaleRef;
    }

    /**
     * 
     * 
     * @return
     *     The cpuUtilization
     */
    @JsonProperty("cpuUtilization")
    public CPUTargetUtilization getCpuUtilization() {
        return cpuUtilization;
    }

    /**
     * 
     * 
     * @param cpuUtilization
     *     The cpuUtilization
     */
    @JsonProperty("cpuUtilization")
    public void setCpuUtilization(CPUTargetUtilization cpuUtilization) {
        this.cpuUtilization = cpuUtilization;
    }

    /**
     * 
     * 
     * @return
     *     The maxReplicas
     */
    @JsonProperty("maxReplicas")
    public Integer getMaxReplicas() {
        return maxReplicas;
    }

    /**
     * 
     * 
     * @param maxReplicas
     *     The maxReplicas
     */
    @JsonProperty("maxReplicas")
    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    /**
     * 
     * 
     * @return
     *     The minReplicas
     */
    @JsonProperty("minReplicas")
    public Integer getMinReplicas() {
        return minReplicas;
    }

    /**
     * 
     * 
     * @param minReplicas
     *     The minReplicas
     */
    @JsonProperty("minReplicas")
    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    /**
     * 
     * 
     * @return
     *     The scaleRef
     */
    @JsonProperty("scaleRef")
    public SubresourceReference getScaleRef() {
        return scaleRef;
    }

    /**
     * 
     * 
     * @param scaleRef
     *     The scaleRef
     */
    @JsonProperty("scaleRef")
    public void setScaleRef(SubresourceReference scaleRef) {
        this.scaleRef = scaleRef;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
