package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.List;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface IngressSpecFluent<A extends IngressSpecFluent<A>> extends Fluent<A>{


    public IngressBackend getBackend();
    public A withBackend(IngressBackend backend);
    public IngressSpecFluent.BackendNested<A> withNewBackend();
    public IngressSpecFluent.BackendNested<A> withNewBackendLike(IngressBackend item);
    public IngressSpecFluent.BackendNested<A> editBackend();
    public A addToRules(IngressRule... items);
    public A removeFromRules(IngressRule... items);
    public List<IngressRule> getRules();
    public A withRules(List<IngressRule> rules);
    public A withRules(IngressRule... rules);
    public IngressSpecFluent.RulesNested<A> addNewRule();
    public IngressSpecFluent.RulesNested<A> addNewRuleLike(IngressRule item);
    public A addToTls(IngressTLS... items);
    public A removeFromTls(IngressTLS... items);
    public List<IngressTLS> getTls();
    public A withTls(List<IngressTLS> tls);
    public A withTls(IngressTLS... tls);
    public IngressSpecFluent.TlsNested<A> addNewTl();
    public IngressSpecFluent.TlsNested<A> addNewTlLike(IngressTLS item);

    public interface BackendNested<N> extends Nested<N>,IngressBackendFluent<IngressSpecFluent.BackendNested<N>>{

        
    public N and();    public N endBackend();
}
    public interface RulesNested<N> extends Nested<N>,IngressRuleFluent<IngressSpecFluent.RulesNested<N>>{

        
    public N and();    public N endRule();
}
    public interface TlsNested<N> extends Nested<N>,IngressTLSFluent<IngressSpecFluent.TlsNested<N>>{

        
    public N and();    public N endTl();
}


}
