
package io.fabric8.kubernetes.api.model.extensions;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "activeDeadlineSeconds",
    "autoSelector",
    "completions",
    "parallelism",
    "selector",
    "template"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class JobSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("activeDeadlineSeconds")
    private Long activeDeadlineSeconds;
    /**
     * 
     * 
     */
    @JsonProperty("autoSelector")
    private Boolean autoSelector;
    /**
     * 
     * 
     */
    @JsonProperty("completions")
    private Integer completions;
    /**
     * 
     * 
     */
    @JsonProperty("parallelism")
    private Integer parallelism;
    /**
     * 
     * 
     */
    @JsonProperty("selector")
    @Valid
    private LabelSelector selector;
    /**
     * 
     * 
     */
    @JsonProperty("template")
    @Valid
    private PodTemplateSpec template;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public JobSpec() {
    }

    /**
     * 
     * @param template
     * @param autoSelector
     * @param parallelism
     * @param completions
     * @param selector
     * @param activeDeadlineSeconds
     */
    public JobSpec(Long activeDeadlineSeconds, Boolean autoSelector, Integer completions, Integer parallelism, LabelSelector selector, PodTemplateSpec template) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        this.autoSelector = autoSelector;
        this.completions = completions;
        this.parallelism = parallelism;
        this.selector = selector;
        this.template = template;
    }

    /**
     * 
     * 
     * @return
     *     The activeDeadlineSeconds
     */
    @JsonProperty("activeDeadlineSeconds")
    public Long getActiveDeadlineSeconds() {
        return activeDeadlineSeconds;
    }

    /**
     * 
     * 
     * @param activeDeadlineSeconds
     *     The activeDeadlineSeconds
     */
    @JsonProperty("activeDeadlineSeconds")
    public void setActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    /**
     * 
     * 
     * @return
     *     The autoSelector
     */
    @JsonProperty("autoSelector")
    public Boolean getAutoSelector() {
        return autoSelector;
    }

    /**
     * 
     * 
     * @param autoSelector
     *     The autoSelector
     */
    @JsonProperty("autoSelector")
    public void setAutoSelector(Boolean autoSelector) {
        this.autoSelector = autoSelector;
    }

    /**
     * 
     * 
     * @return
     *     The completions
     */
    @JsonProperty("completions")
    public Integer getCompletions() {
        return completions;
    }

    /**
     * 
     * 
     * @param completions
     *     The completions
     */
    @JsonProperty("completions")
    public void setCompletions(Integer completions) {
        this.completions = completions;
    }

    /**
     * 
     * 
     * @return
     *     The parallelism
     */
    @JsonProperty("parallelism")
    public Integer getParallelism() {
        return parallelism;
    }

    /**
     * 
     * 
     * @param parallelism
     *     The parallelism
     */
    @JsonProperty("parallelism")
    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    /**
     * 
     * 
     * @return
     *     The selector
     */
    @JsonProperty("selector")
    public LabelSelector getSelector() {
        return selector;
    }

    /**
     * 
     * 
     * @param selector
     *     The selector
     */
    @JsonProperty("selector")
    public void setSelector(LabelSelector selector) {
        this.selector = selector;
    }

    /**
     * 
     * 
     * @return
     *     The template
     */
    @JsonProperty("template")
    public PodTemplateSpec getTemplate() {
        return template;
    }

    /**
     * 
     * 
     * @param template
     *     The template
     */
    @JsonProperty("template")
    public void setTemplate(PodTemplateSpec template) {
        this.template = template;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
