package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;

public class ProjectSpecFluentImpl<A extends ProjectSpecFluent<A>> extends BaseFluent<A> implements ProjectSpecFluent<A>{

    private List<String> finalizers = new ArrayList<String>();

    public ProjectSpecFluentImpl(){
    }
    public ProjectSpecFluentImpl(ProjectSpec instance){
            this.withFinalizers(instance.getFinalizers()); 
    }

    public A addToFinalizers(String... items){
            for (String item : items) {this.finalizers.add(item);} return (A)this;
    }

    public A removeFromFinalizers(String... items){
            for (String item : items) {this.finalizers.remove(item);} return (A)this;
    }

    public List<String> getFinalizers(){
            return this.finalizers;
    }

    public A withFinalizers(List<String> finalizers){
            this.finalizers.clear();
            if (finalizers != null) {for (String item : finalizers){this.addToFinalizers(item);}} return (A) this;
    }

    public A withFinalizers(String... finalizers){
            this.finalizers.clear(); if (finalizers != null) {for (String item :finalizers){ this.addToFinalizers(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ProjectSpecFluentImpl that = (ProjectSpecFluentImpl) o;
            if (finalizers != null ? !finalizers.equals(that.finalizers) :that.finalizers != null) return false;
            return true;
    }




}
