package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamedContextFluentImpl<A extends NamedContextFluent<A>> extends BaseFluent<A> implements NamedContextFluent<A>{

    private VisitableBuilder<? extends Context,?> context;
    private String name;

    public NamedContextFluentImpl(){
    }
    public NamedContextFluentImpl(NamedContext instance){
            this.withContext(instance.getContext()); 
            this.withName(instance.getName()); 
    }

    public Context getContext(){
            return this.context!=null?this.context.build():null;
    }

    public A withContext(Context context){
            if (context!=null){ this.context= new ContextBuilder(context); _visitables.add(this.context);} return (A) this;
    }

    public NamedContextFluent.ContextNested<A> withNewContext(){
            return new ContextNestedImpl();
    }

    public NamedContextFluent.ContextNested<A> withNewContextLike(Context item){
            return new ContextNestedImpl(item);
    }

    public NamedContextFluent.ContextNested<A> editContext(){
            return withNewContextLike(getContext());
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedContextFluentImpl that = (NamedContextFluentImpl) o;
            if (context != null ? !context.equals(that.context) :that.context != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }


    public class ContextNestedImpl<N> extends ContextFluentImpl<NamedContextFluent.ContextNested<N>> implements NamedContextFluent.ContextNested<N>,Nested<N>{

            private final ContextBuilder builder;
    
            ContextNestedImpl(){
                    this.builder = new ContextBuilder(this);
            }
            ContextNestedImpl(Context item){
                    this.builder = new ContextBuilder(this, item);
            }
    
    public N endContext(){
            return and();
    }
    public N and(){
            return (N) NamedContextFluentImpl.this.withContext(builder.build());
    }

}


}
