package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PodTemplateListFluent<A extends PodTemplateListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(PodTemplate... items);
    public A removeFromItems(PodTemplate... items);
    public List<PodTemplate> getItems();
    public A withItems(List<PodTemplate> items);
    public A withItems(PodTemplate... items);
    public PodTemplateListFluent.ItemsNested<A> addNewItem();
    public PodTemplateListFluent.ItemsNested<A> addNewItemLike(PodTemplate item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public PodTemplateListFluent.MetadataNested<A> withNewMetadata();
    public PodTemplateListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PodTemplateListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,PodTemplateFluent<PodTemplateListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<PodTemplateListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
