package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class ResourceQuotaStatusBuilder extends ResourceQuotaStatusFluentImpl<ResourceQuotaStatusBuilder> implements VisitableBuilder<ResourceQuotaStatus,ResourceQuotaStatusBuilder>{

    ResourceQuotaStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceQuotaStatusBuilder(){
            this(true);
    }
    public ResourceQuotaStatusBuilder(Boolean validationEnabled){
            this(new ResourceQuotaStatus(), validationEnabled);
    }
    public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ResourceQuotaStatus(), validationEnabled);
    }
    public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent,ResourceQuotaStatus instance){
            this(fluent, instance, true);
    }
    public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent,ResourceQuotaStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHard(instance.getHard()); 
            fluent.withUsed(instance.getUsed()); 
            this.validationEnabled = validationEnabled; 
    }
    public ResourceQuotaStatusBuilder(ResourceQuotaStatus instance){
            this(instance,true);
    }
    public ResourceQuotaStatusBuilder(ResourceQuotaStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHard(instance.getHard()); 
            this.withUsed(instance.getUsed()); 
            this.validationEnabled = validationEnabled; 
    }

    public ResourceQuotaStatus build(){
            ResourceQuotaStatus buildable = new ResourceQuotaStatus(fluent.getHard(),fluent.getUsed());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceQuotaStatusBuilder that = (ResourceQuotaStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
