package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.LinkedHashMap;
import java.lang.Object;

public class ResourceQuotaStatusFluentImpl<A extends ResourceQuotaStatusFluent<A>> extends BaseFluent<A> implements ResourceQuotaStatusFluent<A>{

    private Map<String,Quantity> hard = new LinkedHashMap<String,Quantity>();
    private Map<String,Quantity> used = new LinkedHashMap<String,Quantity>();

    public ResourceQuotaStatusFluentImpl(){
    }
    public ResourceQuotaStatusFluentImpl(ResourceQuotaStatus instance){
            this.withHard(instance.getHard()); 
            this.withUsed(instance.getUsed()); 
    }

    public A addToHard(String key,Quantity value){
            if(key != null && value != null) {this.hard.put(key, value);} return (A)this;
    }

    public A addToHard(Map<String,Quantity> map){
            if(map != null) { this.hard.putAll(map);} return (A)this;
    }

    public A removeFromHard(String key){
            if(key != null) {this.hard.remove(key);} return (A)this;
    }

    public A removeFromHard(Map<String,Quantity> map){
            if(map != null) { for(Object key : map.keySet()) {this.hard.remove(key);}} return (A)this;
    }

    public Map<String,Quantity> getHard(){
            return this.hard;
    }

    public A withHard(Map<String,Quantity> hard){
            this.hard.clear();
            if (hard != null) {this.hard.putAll(hard);} return (A) this;
    }

    public A addToUsed(String key,Quantity value){
            if(key != null && value != null) {this.used.put(key, value);} return (A)this;
    }

    public A addToUsed(Map<String,Quantity> map){
            if(map != null) { this.used.putAll(map);} return (A)this;
    }

    public A removeFromUsed(String key){
            if(key != null) {this.used.remove(key);} return (A)this;
    }

    public A removeFromUsed(Map<String,Quantity> map){
            if(map != null) { for(Object key : map.keySet()) {this.used.remove(key);}} return (A)this;
    }

    public Map<String,Quantity> getUsed(){
            return this.used;
    }

    public A withUsed(Map<String,Quantity> used){
            this.used.clear();
            if (used != null) {this.used.putAll(used);} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceQuotaStatusFluentImpl that = (ResourceQuotaStatusFluentImpl) o;
            if (hard != null ? !hard.equals(that.hard) :that.hard != null) return false;
            if (used != null ? !used.equals(that.used) :that.used != null) return false;
            return true;
    }




}
