package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ServiceAccountFluent<A extends ServiceAccountFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToImagePullSecrets(LocalObjectReference... items);
    public A removeFromImagePullSecrets(LocalObjectReference... items);
    public List<LocalObjectReference> getImagePullSecrets();
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets);
    public ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
    public ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
    public A addNewImagePullSecret(String name);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ServiceAccountFluent.MetadataNested<A> withNewMetadata();
    public ServiceAccountFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServiceAccountFluent.MetadataNested<A> editMetadata();
    public A addToSecrets(ObjectReference... items);
    public A removeFromSecrets(ObjectReference... items);
    public List<ObjectReference> getSecrets();
    public A withSecrets(List<ObjectReference> secrets);
    public A withSecrets(ObjectReference... secrets);
    public ServiceAccountFluent.SecretsNested<A> addNewSecret();
    public ServiceAccountFluent.SecretsNested<A> addNewSecretLike(ObjectReference item);

    public interface ImagePullSecretsNested<N> extends Nested<N>,LocalObjectReferenceFluent<ServiceAccountFluent.ImagePullSecretsNested<N>>{

        
    public N and();    public N endImagePullSecret();
}
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ServiceAccountFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SecretsNested<N> extends Nested<N>,ObjectReferenceFluent<ServiceAccountFluent.SecretsNested<N>>{

        
    public N and();    public N endSecret();
}


}
