package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface HTTPIngressRuleValueFluent<A extends HTTPIngressRuleValueFluent<A>> extends Fluent<A>{


    public A addToPaths(HTTPIngressPath... items);
    public A removeFromPaths(HTTPIngressPath... items);
    public List<HTTPIngressPath> getPaths();
    public A withPaths(List<HTTPIngressPath> paths);
    public A withPaths(HTTPIngressPath... paths);
    public HTTPIngressRuleValueFluent.PathsNested<A> addNewPath();
    public HTTPIngressRuleValueFluent.PathsNested<A> addNewPathLike(HTTPIngressPath item);

    public interface PathsNested<N> extends Nested<N>,HTTPIngressPathFluent<HTTPIngressRuleValueFluent.PathsNested<N>>{

        
    public N and();    public N endPath();
}


}
