package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface ClusterPolicyFluent<A extends ClusterPolicyFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public String getLastModified();
    public A withLastModified(String lastModified);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ClusterPolicyFluent.MetadataNested<A> withNewMetadata();
    public ClusterPolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ClusterPolicyFluent.MetadataNested<A> editMetadata();
    public A addToRoles(NamedClusterRole... items);
    public A removeFromRoles(NamedClusterRole... items);
    public List<NamedClusterRole> getRoles();
    public A withRoles(List<NamedClusterRole> roles);
    public A withRoles(NamedClusterRole... roles);
    public ClusterPolicyFluent.RolesNested<A> addNewRole();
    public ClusterPolicyFluent.RolesNested<A> addNewRoleLike(NamedClusterRole item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ClusterPolicyFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RolesNested<N> extends Nested<N>,NamedClusterRoleFluent<ClusterPolicyFluent.RolesNested<N>>{

        
    public N endRole();    public N and();
}


}
