package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;

public class CustomBuildStrategyFluentImpl<A extends CustomBuildStrategyFluent<A>> extends BaseFluent<A> implements CustomBuildStrategyFluent<A>{

    private String buildAPIVersion;
    private List<VisitableBuilder<? extends EnvVar,?>> env =  new ArrayList<VisitableBuilder<? extends EnvVar,?>>();
    private Boolean exposeDockerSocket;
    private Boolean forcePull;
    private VisitableBuilder<? extends ObjectReference,?> from;
    private VisitableBuilder<? extends LocalObjectReference,?> pullSecret;
    private List<VisitableBuilder<? extends SecretSpec,?>> secrets =  new ArrayList<VisitableBuilder<? extends SecretSpec,?>>();

    public CustomBuildStrategyFluentImpl(){
    }
    public CustomBuildStrategyFluentImpl(CustomBuildStrategy instance){
            this.withBuildAPIVersion(instance.getBuildAPIVersion()); 
            this.withEnv(instance.getEnv()); 
            this.withExposeDockerSocket(instance.getExposeDockerSocket()); 
            this.withForcePull(instance.getForcePull()); 
            this.withFrom(instance.getFrom()); 
            this.withPullSecret(instance.getPullSecret()); 
            this.withSecrets(instance.getSecrets()); 
    }

    public String getBuildAPIVersion(){
            return this.buildAPIVersion;
    }

    public A withBuildAPIVersion(String buildAPIVersion){
            this.buildAPIVersion=buildAPIVersion; return (A) this;
    }

    public A addToEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (A)this;
    }

    public List<EnvVar> getEnv(){
            return build(env);
    }

    public A withEnv(List<EnvVar> env){
            this.env.clear();
            if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (A) this;
    }

    public A withEnv(EnvVar... env){
            this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public CustomBuildStrategyFluent.EnvNested<A> addNewEnv(){
            return new EnvNestedImpl();
    }

    public CustomBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item){
            return new EnvNestedImpl(item);
    }

    public Boolean isExposeDockerSocket(){
            return this.exposeDockerSocket;
    }

    public A withExposeDockerSocket(Boolean exposeDockerSocket){
            this.exposeDockerSocket=exposeDockerSocket; return (A) this;
    }

    public Boolean isForcePull(){
            return this.forcePull;
    }

    public A withForcePull(Boolean forcePull){
            this.forcePull=forcePull; return (A) this;
    }

    public ObjectReference getFrom(){
            return this.from!=null?this.from.build():null;
    }

    public A withFrom(ObjectReference from){
            if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }

    public CustomBuildStrategyFluent.FromNested<A> withNewFrom(){
            return new FromNestedImpl();
    }

    public CustomBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item){
            return new FromNestedImpl(item);
    }

    public CustomBuildStrategyFluent.FromNested<A> editFrom(){
            return withNewFromLike(getFrom());
    }

    public LocalObjectReference getPullSecret(){
            return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public A withPullSecret(LocalObjectReference pullSecret){
            if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.add(this.pullSecret);} return (A) this;
    }

    public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecret(){
            return new PullSecretNestedImpl();
    }

    public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item){
            return new PullSecretNestedImpl(item);
    }

    public CustomBuildStrategyFluent.PullSecretNested<A> editPullSecret(){
            return withNewPullSecretLike(getPullSecret());
    }

    public A withNewPullSecret(String name){
            return (A)withPullSecret(new LocalObjectReference(name));
    }

    public A addToSecrets(SecretSpec... items){
            for (SecretSpec item : items) {SecretSpecBuilder builder = new SecretSpecBuilder(item);_visitables.add(builder);this.secrets.add(builder);} return (A)this;
    }

    public A removeFromSecrets(SecretSpec... items){
            for (SecretSpec item : items) {SecretSpecBuilder builder = new SecretSpecBuilder(item);_visitables.remove(builder);this.secrets.remove(builder);} return (A)this;
    }

    public List<SecretSpec> getSecrets(){
            return build(secrets);
    }

    public A withSecrets(List<SecretSpec> secrets){
            this.secrets.clear();
            if (secrets != null) {for (SecretSpec item : secrets){this.addToSecrets(item);}} return (A) this;
    }

    public A withSecrets(SecretSpec... secrets){
            this.secrets.clear(); if (secrets != null) {for (SecretSpec item :secrets){ this.addToSecrets(item);}} return (A) this;
    }

    public CustomBuildStrategyFluent.SecretsNested<A> addNewSecret(){
            return new SecretsNestedImpl();
    }

    public CustomBuildStrategyFluent.SecretsNested<A> addNewSecretLike(SecretSpec item){
            return new SecretsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CustomBuildStrategyFluentImpl that = (CustomBuildStrategyFluentImpl) o;
            if (buildAPIVersion != null ? !buildAPIVersion.equals(that.buildAPIVersion) :that.buildAPIVersion != null) return false;
            if (env != null ? !env.equals(that.env) :that.env != null) return false;
            if (exposeDockerSocket != null ? !exposeDockerSocket.equals(that.exposeDockerSocket) :that.exposeDockerSocket != null) return false;
            if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
            if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
            return true;
    }


    public class EnvNestedImpl<N> extends EnvVarFluentImpl<CustomBuildStrategyFluent.EnvNested<N>> implements CustomBuildStrategyFluent.EnvNested<N>,Nested<N>{

            private final EnvVarBuilder builder;
    
            EnvNestedImpl(EnvVar item){
                    this.builder = new EnvVarBuilder(this, item);
            }
            EnvNestedImpl(){
                    this.builder = new EnvVarBuilder(this);
            }
    
    public N endEnv(){
            return and();
    }
    public N and(){
            return (N) CustomBuildStrategyFluentImpl.this.addToEnv(builder.build());
    }

}
    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<CustomBuildStrategyFluent.FromNested<N>> implements CustomBuildStrategyFluent.FromNested<N>,Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
            FromNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
    
    public N endFrom(){
            return and();
    }
    public N and(){
            return (N) CustomBuildStrategyFluentImpl.this.withFrom(builder.build());
    }

}
    public class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<CustomBuildStrategyFluent.PullSecretNested<N>> implements CustomBuildStrategyFluent.PullSecretNested<N>,Nested<N>{

            private final LocalObjectReferenceBuilder builder;
    
            PullSecretNestedImpl(){
                    this.builder = new LocalObjectReferenceBuilder(this);
            }
            PullSecretNestedImpl(LocalObjectReference item){
                    this.builder = new LocalObjectReferenceBuilder(this, item);
            }
    
    public N and(){
            return (N) CustomBuildStrategyFluentImpl.this.withPullSecret(builder.build());
    }
    public N endPullSecret(){
            return and();
    }

}
    public class SecretsNestedImpl<N> extends SecretSpecFluentImpl<CustomBuildStrategyFluent.SecretsNested<N>> implements CustomBuildStrategyFluent.SecretsNested<N>,Nested<N>{

            private final SecretSpecBuilder builder;
    
            SecretsNestedImpl(){
                    this.builder = new SecretSpecBuilder(this);
            }
            SecretsNestedImpl(SecretSpec item){
                    this.builder = new SecretSpecBuilder(this, item);
            }
    
    public N and(){
            return (N) CustomBuildStrategyFluentImpl.this.addToSecrets(builder.build());
    }
    public N endSecret(){
            return and();
    }

}


}
