package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class DeploymentTriggerImageChangeParamsBuilder extends DeploymentTriggerImageChangeParamsFluentImpl<DeploymentTriggerImageChangeParamsBuilder> implements VisitableBuilder<DeploymentTriggerImageChangeParams,DeploymentTriggerImageChangeParamsBuilder>{

    DeploymentTriggerImageChangeParamsFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentTriggerImageChangeParamsBuilder(){
            this(true);
    }
    public DeploymentTriggerImageChangeParamsBuilder(Boolean validationEnabled){
            this(new DeploymentTriggerImageChangeParams(), validationEnabled);
    }
    public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParamsFluent<?> fluent){
            this(fluent, true);
    }
    public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParamsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DeploymentTriggerImageChangeParams(), validationEnabled);
    }
    public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParamsFluent<?> fluent,DeploymentTriggerImageChangeParams instance){
            this(fluent, instance, true);
    }
    public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParamsFluent<?> fluent,DeploymentTriggerImageChangeParams instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAutomatic(instance.getAutomatic()); 
            fluent.withContainerNames(instance.getContainerNames()); 
            fluent.withFrom(instance.getFrom()); 
            fluent.withLastTriggeredImage(instance.getLastTriggeredImage()); 
            this.validationEnabled = validationEnabled; 
    }
    public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParams instance){
            this(instance,true);
    }
    public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParams instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAutomatic(instance.getAutomatic()); 
            this.withContainerNames(instance.getContainerNames()); 
            this.withFrom(instance.getFrom()); 
            this.withLastTriggeredImage(instance.getLastTriggeredImage()); 
            this.validationEnabled = validationEnabled; 
    }

    public DeploymentTriggerImageChangeParams build(){
            DeploymentTriggerImageChangeParams buildable = new DeploymentTriggerImageChangeParams(fluent.isAutomatic(),fluent.getContainerNames(),fluent.getFrom(),fluent.getLastTriggeredImage());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentTriggerImageChangeParamsBuilder that = (DeploymentTriggerImageChangeParamsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
