package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class ImageChangeTriggerFluentImpl<A extends ImageChangeTriggerFluent<A>> extends BaseFluent<A> implements ImageChangeTriggerFluent<A>{

    private VisitableBuilder<? extends ObjectReference,?> from;
    private String lastTriggeredImageID;

    public ImageChangeTriggerFluentImpl(){
    }
    public ImageChangeTriggerFluentImpl(ImageChangeTrigger instance){
            this.withFrom(instance.getFrom()); 
            this.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
    }

    public ObjectReference getFrom(){
            return this.from!=null?this.from.build():null;
    }

    public A withFrom(ObjectReference from){
            if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }

    public ImageChangeTriggerFluent.FromNested<A> withNewFrom(){
            return new FromNestedImpl();
    }

    public ImageChangeTriggerFluent.FromNested<A> withNewFromLike(ObjectReference item){
            return new FromNestedImpl(item);
    }

    public ImageChangeTriggerFluent.FromNested<A> editFrom(){
            return withNewFromLike(getFrom());
    }

    public String getLastTriggeredImageID(){
            return this.lastTriggeredImageID;
    }

    public A withLastTriggeredImageID(String lastTriggeredImageID){
            this.lastTriggeredImageID=lastTriggeredImageID; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageChangeTriggerFluentImpl that = (ImageChangeTriggerFluentImpl) o;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (lastTriggeredImageID != null ? !lastTriggeredImageID.equals(that.lastTriggeredImageID) :that.lastTriggeredImageID != null) return false;
            return true;
    }


    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<ImageChangeTriggerFluent.FromNested<N>> implements ImageChangeTriggerFluent.FromNested<N>,Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
            FromNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
    
    public N endFrom(){
            return and();
    }
    public N and(){
            return (N) ImageChangeTriggerFluentImpl.this.withFrom(builder.build());
    }

}


}
