package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface UserFluent<A extends UserFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getFullName();
    public A withFullName(String fullName);
    public A addToGroups(String... items);
    public A removeFromGroups(String... items);
    public List<String> getGroups();
    public A withGroups(List<String> groups);
    public A withGroups(String... groups);
    public A addToIdentities(String... items);
    public A removeFromIdentities(String... items);
    public List<String> getIdentities();
    public A withIdentities(List<String> identities);
    public A withIdentities(String... identities);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public UserFluent.MetadataNested<A> withNewMetadata();
    public UserFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public UserFluent.MetadataNested<A> editMetadata();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<UserFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
