package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PodTemplateFluent<A extends PodTemplateFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PodTemplateFluent.MetadataNested<A> withNewMetadata();
    public PodTemplateFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PodTemplateFluent.MetadataNested<A> editMetadata();
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public PodTemplateFluent.TemplateNested<A> withNewTemplate();
    public PodTemplateFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public PodTemplateFluent.TemplateNested<A> editTemplate();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PodTemplateFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<PodTemplateFluent.TemplateNested<N>>{

        
    public N endTemplate();    public N and();
}


}
