package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import java.lang.Object;

public class VolumeMountFluentImpl<A extends VolumeMountFluent<A>> extends BaseFluent<A> implements VolumeMountFluent<A>{

    private String mountPath;
    private String name;
    private Boolean readOnly;
    private String subPath;

    public VolumeMountFluentImpl(){
    }
    public VolumeMountFluentImpl(VolumeMount instance){
            this.withMountPath(instance.getMountPath()); 
            this.withName(instance.getName()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withSubPath(instance.getSubPath()); 
    }

    public String getMountPath(){
            return this.mountPath;
    }

    public A withMountPath(String mountPath){
            this.mountPath=mountPath; return (A) this;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public String getSubPath(){
            return this.subPath;
    }

    public A withSubPath(String subPath){
            this.subPath=subPath; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumeMountFluentImpl that = (VolumeMountFluentImpl) o;
            if (mountPath != null ? !mountPath.equals(that.mountPath) :that.mountPath != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (subPath != null ? !subPath.equals(that.subPath) :that.subPath != null) return false;
            return true;
    }




}
