package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface OAuthAccessTokenFluent<A extends OAuthAccessTokenFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getAuthorizeToken();
    public A withAuthorizeToken(String authorizeToken);
    public String getClientName();
    public A withClientName(String clientName);
    public Long getExpiresIn();
    public A withExpiresIn(Long expiresIn);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public OAuthAccessTokenFluent.MetadataNested<A> withNewMetadata();
    public OAuthAccessTokenFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OAuthAccessTokenFluent.MetadataNested<A> editMetadata();
    public String getRedirectURI();
    public A withRedirectURI(String redirectURI);
    public String getRefreshToken();
    public A withRefreshToken(String refreshToken);
    public A addToScopes(String... items);
    public A removeFromScopes(String... items);
    public List<String> getScopes();
    public A withScopes(List<String> scopes);
    public A withScopes(String... scopes);
    public String getUserName();
    public A withUserName(String userName);
    public String getUserUID();
    public A withUserUID(String userUID);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<OAuthAccessTokenFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
