package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface EndpointAddressFluent<A extends EndpointAddressFluent<A>> extends Fluent<A>{


    public String getHostname();
    public A withHostname(String hostname);
    public String getIp();
    public A withIp(String ip);
    public ObjectReference getTargetRef();
    public A withTargetRef(ObjectReference targetRef);
    public EndpointAddressFluent.TargetRefNested<A> withNewTargetRef();
    public EndpointAddressFluent.TargetRefNested<A> withNewTargetRefLike(ObjectReference item);
    public EndpointAddressFluent.TargetRefNested<A> editTargetRef();

    public interface TargetRefNested<N> extends Nested<N>,ObjectReferenceFluent<EndpointAddressFluent.TargetRefNested<N>>{

        
    public N endTargetRef();    public N and();
}


}
