package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface LimitRangeFluent<A extends LimitRangeFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public LimitRangeFluent.MetadataNested<A> withNewMetadata();
    public LimitRangeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public LimitRangeFluent.MetadataNested<A> editMetadata();
    public LimitRangeSpec getSpec();
    public A withSpec(LimitRangeSpec spec);
    public LimitRangeFluent.SpecNested<A> withNewSpec();
    public LimitRangeFluent.SpecNested<A> withNewSpecLike(LimitRangeSpec item);
    public LimitRangeFluent.SpecNested<A> editSpec();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<LimitRangeFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,LimitRangeSpecFluent<LimitRangeFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}


}
