package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamedAuthInfoFluentImpl<A extends NamedAuthInfoFluent<A>> extends BaseFluent<A> implements NamedAuthInfoFluent<A>{

    private String name;
    private VisitableBuilder<? extends AuthInfo,?> user;

    public NamedAuthInfoFluentImpl(){
    }
    public NamedAuthInfoFluentImpl(NamedAuthInfo instance){
            this.withName(instance.getName()); 
            this.withUser(instance.getUser()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public AuthInfo getUser(){
            return this.user!=null?this.user.build():null;
    }

    public A withUser(AuthInfo user){
            if (user!=null){ this.user= new AuthInfoBuilder(user); _visitables.add(this.user);} return (A) this;
    }

    public NamedAuthInfoFluent.UserNested<A> withNewUser(){
            return new UserNestedImpl();
    }

    public NamedAuthInfoFluent.UserNested<A> withNewUserLike(AuthInfo item){
            return new UserNestedImpl(item);
    }

    public NamedAuthInfoFluent.UserNested<A> editUser(){
            return withNewUserLike(getUser());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedAuthInfoFluentImpl that = (NamedAuthInfoFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }


    public class UserNestedImpl<N> extends AuthInfoFluentImpl<NamedAuthInfoFluent.UserNested<N>> implements NamedAuthInfoFluent.UserNested<N>,Nested<N>{

            private final AuthInfoBuilder builder;
    
            UserNestedImpl(){
                    this.builder = new AuthInfoBuilder(this);
            }
            UserNestedImpl(AuthInfo item){
                    this.builder = new AuthInfoBuilder(this, item);
            }
    
    public N and(){
            return (N) NamedAuthInfoFluentImpl.this.withUser(builder.build());
    }
    public N endUser(){
            return and();
    }

}


}
