package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface ImageChangeTriggerFluent<A extends ImageChangeTriggerFluent<A>> extends Fluent<A>{


    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public ImageChangeTriggerFluent.FromNested<A> withNewFrom();
    public ImageChangeTriggerFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public ImageChangeTriggerFluent.FromNested<A> editFrom();
    public String getLastTriggeredImageID();
    public A withLastTriggeredImageID(String lastTriggeredImageID);

    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<ImageChangeTriggerFluent.FromNested<N>>{

        
    public N endFrom();    public N and();
}


}
