package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class LabelSelectorFluentImpl<A extends LabelSelectorFluent<A>> extends BaseFluent<A> implements LabelSelectorFluent<A>{

    private List<VisitableBuilder<? extends LabelSelectorRequirement,?>> matchExpressions =  new ArrayList<VisitableBuilder<? extends LabelSelectorRequirement,?>>();
    private Map<String,String> matchLabels = new LinkedHashMap<String,String>();

    public LabelSelectorFluentImpl(){
    }
    public LabelSelectorFluentImpl(LabelSelector instance){
            this.withMatchExpressions(instance.getMatchExpressions()); 
            this.withMatchLabels(instance.getMatchLabels()); 
    }

    public A addToMatchExpressions(LabelSelectorRequirement... items){
            for (LabelSelectorRequirement item : items) {LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);_visitables.add(builder);this.matchExpressions.add(builder);} return (A)this;
    }

    public A removeFromMatchExpressions(LabelSelectorRequirement... items){
            for (LabelSelectorRequirement item : items) {LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);_visitables.remove(builder);this.matchExpressions.remove(builder);} return (A)this;
    }

    public List<LabelSelectorRequirement> getMatchExpressions(){
            return build(matchExpressions);
    }

    public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions){
            this.matchExpressions.clear();
            if (matchExpressions != null) {for (LabelSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} return (A) this;
    }

    public A withMatchExpressions(LabelSelectorRequirement... matchExpressions){
            this.matchExpressions.clear(); if (matchExpressions != null) {for (LabelSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
    }

    public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpression(){
            return new MatchExpressionsNestedImpl();
    }

    public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(LabelSelectorRequirement item){
            return new MatchExpressionsNestedImpl(item);
    }

    public A addToMatchLabels(String key,String value){
            if(key != null && value != null) {this.matchLabels.put(key, value);} return (A)this;
    }

    public A addToMatchLabels(Map<String,String> map){
            if(map != null) { this.matchLabels.putAll(map);} return (A)this;
    }

    public A removeFromMatchLabels(String key){
            if(key != null) {this.matchLabels.remove(key);} return (A)this;
    }

    public A removeFromMatchLabels(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.matchLabels.remove(key);}} return (A)this;
    }

    public Map<String,String> getMatchLabels(){
            return this.matchLabels;
    }

    public A withMatchLabels(Map<String,String> matchLabels){
            this.matchLabels.clear();
            if (matchLabels != null) {this.matchLabels.putAll(matchLabels);} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LabelSelectorFluentImpl that = (LabelSelectorFluentImpl) o;
            if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
            if (matchLabels != null ? !matchLabels.equals(that.matchLabels) :that.matchLabels != null) return false;
            return true;
    }


    public class MatchExpressionsNestedImpl<N> extends LabelSelectorRequirementFluentImpl<LabelSelectorFluent.MatchExpressionsNested<N>> implements LabelSelectorFluent.MatchExpressionsNested<N>,Nested<N>{

            private final LabelSelectorRequirementBuilder builder;
    
            MatchExpressionsNestedImpl(){
                    this.builder = new LabelSelectorRequirementBuilder(this);
            }
            MatchExpressionsNestedImpl(LabelSelectorRequirement item){
                    this.builder = new LabelSelectorRequirementBuilder(this, item);
            }
    
    public N endMatchExpression(){
            return and();
    }
    public N and(){
            return (N) LabelSelectorFluentImpl.this.addToMatchExpressions(builder.build());
    }

}


}
