package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import java.lang.Long;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface HorizontalPodAutoscalerFluent<A extends HorizontalPodAutoscalerFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public HorizontalPodAutoscalerFluent.MetadataNested<A> withNewMetadata();
    public HorizontalPodAutoscalerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public HorizontalPodAutoscalerFluent.MetadataNested<A> editMetadata();
    public HorizontalPodAutoscalerSpec getSpec();
    public A withSpec(HorizontalPodAutoscalerSpec spec);
    public HorizontalPodAutoscalerFluent.SpecNested<A> withNewSpec();
    public HorizontalPodAutoscalerFluent.SpecNested<A> withNewSpecLike(HorizontalPodAutoscalerSpec item);
    public HorizontalPodAutoscalerFluent.SpecNested<A> editSpec();
    public HorizontalPodAutoscalerStatus getStatus();
    public A withStatus(HorizontalPodAutoscalerStatus status);
    public HorizontalPodAutoscalerFluent.StatusNested<A> withNewStatus();
    public HorizontalPodAutoscalerFluent.StatusNested<A> withNewStatusLike(HorizontalPodAutoscalerStatus item);
    public HorizontalPodAutoscalerFluent.StatusNested<A> editStatus();
    public A withNewStatus(Integer currentCPUUtilizationPercentage,Integer currentReplicas,Integer desiredReplicas,String lastScaleTime,Long observedGeneration);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<HorizontalPodAutoscalerFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,HorizontalPodAutoscalerSpecFluent<HorizontalPodAutoscalerFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,HorizontalPodAutoscalerStatusFluent<HorizontalPodAutoscalerFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
