package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public interface JobSpecFluent<A extends JobSpecFluent<A>> extends Fluent<A>{


    public Long getActiveDeadlineSeconds();
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
    public Boolean isAutoSelector();
    public A withAutoSelector(Boolean autoSelector);
    public Integer getCompletions();
    public A withCompletions(Integer completions);
    public Integer getParallelism();
    public A withParallelism(Integer parallelism);
    public LabelSelector getSelector();
    public A withSelector(LabelSelector selector);
    public JobSpecFluent.SelectorNested<A> withNewSelector();
    public JobSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public JobSpecFluent.SelectorNested<A> editSelector();
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public JobSpecFluent.TemplateNested<A> withNewTemplate();
    public JobSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public JobSpecFluent.TemplateNested<A> editTemplate();

    public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<JobSpecFluent.SelectorNested<N>>{

        
    public N endSelector();    public N and();
}
    public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<JobSpecFluent.TemplateNested<N>>{

        
    public N endTemplate();    public N and();
}


}
