package io.fabric8.kubernetes.api.builder;

import java.util.List;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.lang.Boolean;
import java.lang.reflect.Method;

public class BaseFluent<F extends Fluent<F>> implements Fluent<F>,Visitable<F>{

    public final List<Visitable> _visitables = new ArrayList<Visitable>();


    public static <T>ArrayList<T> build(List<? extends Builder<? extends T>> list){
            ArrayList<T> result = new ArrayList<T>();
            for (Builder<? extends T> builder : list) {
    result.add(builder.build());
}
            return result;
    }

    public static <T>LinkedHashSet<T> build(Set<? extends Builder<? extends T>> list){
            LinkedHashSet<T> result = new LinkedHashSet<T>();
            for (Builder<? extends T> builder : list) {
    result.add(builder.build());
}
            return result;
    }

    public static <T>ArrayList<T> aggregate(List<? extends T>... lists){
            ArrayList<T> result = new ArrayList<T>();
            for (List<? extends T> list : lists) {
    result.addAll(list);
}
            return result;
    }

    public static <T>LinkedHashSet<T> aggregate(Set<? extends T>... sets){
            LinkedHashSet<T> result = new LinkedHashSet<T>();
            for (Set<? extends T> set : sets) {
    result.addAll(set);
}
            return result;
    }

    private static <V,F>Boolean canVisit(V visitor,F fluent){
            if (visitor instanceof TypedVisitor) {
    return ((TypedVisitor) visitor).getType().isAssignableFrom(fluent.getClass());
}
            for (Method method : visitor.getClass().getDeclaredMethods()) {
    if (method.getParameterTypes().length != 1) {
        continue;
    }
    Class visitorType = method.getParameterTypes()[0];
    if (visitorType.isAssignableFrom(fluent.getClass())) {
        return true;
    } else {
        return false;
    }
}
            return false;
    }

    public F accept(Visitor visitor){
            for (Visitable visitable : _visitables) {
    visitable.accept(visitor);
}
            if (canVisit(visitor, this)) {
    visitor.visit(this);
}
            return (F) this;
    }




}
