package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.util.List;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class AuthInfoFluentImpl<A extends AuthInfoFluent<A>> extends BaseFluent<A> implements AuthInfoFluent<A>{

    private String as;
    private VisitableBuilder<? extends AuthProviderConfig,?> authProvider;
    private String clientCertificate;
    private String clientCertificateData;
    private String clientKey;
    private String clientKeyData;
    private List<VisitableBuilder<? extends NamedExtension,?>> extensions =  new ArrayList<VisitableBuilder<? extends NamedExtension,?>>();
    private String password;
    private String token;
    private String username;

    public AuthInfoFluentImpl(){
    }
    public AuthInfoFluentImpl(AuthInfo instance){
            this.withAs(instance.getAs()); 
            this.withAuthProvider(instance.getAuthProvider()); 
            this.withClientCertificate(instance.getClientCertificate()); 
            this.withClientCertificateData(instance.getClientCertificateData()); 
            this.withClientKey(instance.getClientKey()); 
            this.withClientKeyData(instance.getClientKeyData()); 
            this.withExtensions(instance.getExtensions()); 
            this.withPassword(instance.getPassword()); 
            this.withToken(instance.getToken()); 
            this.withUsername(instance.getUsername()); 
    }

    public String getAs(){
            return this.as;
    }

    public A withAs(String as){
            this.as=as; return (A) this;
    }

    public AuthProviderConfig getAuthProvider(){
            return this.authProvider!=null?this.authProvider.build():null;
    }

    public A withAuthProvider(AuthProviderConfig authProvider){
            if (authProvider!=null){ this.authProvider= new AuthProviderConfigBuilder(authProvider); _visitables.add(this.authProvider);} return (A) this;
    }

    public AuthInfoFluent.AuthProviderNested<A> withNewAuthProvider(){
            return new AuthProviderNestedImpl();
    }

    public AuthInfoFluent.AuthProviderNested<A> withNewAuthProviderLike(AuthProviderConfig item){
            return new AuthProviderNestedImpl(item);
    }

    public AuthInfoFluent.AuthProviderNested<A> editAuthProvider(){
            return withNewAuthProviderLike(getAuthProvider());
    }

    public String getClientCertificate(){
            return this.clientCertificate;
    }

    public A withClientCertificate(String clientCertificate){
            this.clientCertificate=clientCertificate; return (A) this;
    }

    public String getClientCertificateData(){
            return this.clientCertificateData;
    }

    public A withClientCertificateData(String clientCertificateData){
            this.clientCertificateData=clientCertificateData; return (A) this;
    }

    public String getClientKey(){
            return this.clientKey;
    }

    public A withClientKey(String clientKey){
            this.clientKey=clientKey; return (A) this;
    }

    public String getClientKeyData(){
            return this.clientKeyData;
    }

    public A withClientKeyData(String clientKeyData){
            this.clientKeyData=clientKeyData; return (A) this;
    }

    public A addToExtensions(NamedExtension... items){
            for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (A)this;
    }

    public A removeFromExtensions(NamedExtension... items){
            for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (A)this;
    }

    public List<NamedExtension> getExtensions(){
            return build(extensions);
    }

    public A withExtensions(List<NamedExtension> extensions){
            this.extensions.clear();
            if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (A) this;
    }

    public A withExtensions(NamedExtension... extensions){
            this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
    }

    public AuthInfoFluent.ExtensionsNested<A> addNewExtension(){
            return new ExtensionsNestedImpl();
    }

    public AuthInfoFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item){
            return new ExtensionsNestedImpl(item);
    }

    public String getPassword(){
            return this.password;
    }

    public A withPassword(String password){
            this.password=password; return (A) this;
    }

    public String getToken(){
            return this.token;
    }

    public A withToken(String token){
            this.token=token; return (A) this;
    }

    public String getUsername(){
            return this.username;
    }

    public A withUsername(String username){
            this.username=username; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthInfoFluentImpl that = (AuthInfoFluentImpl) o;
            if (as != null ? !as.equals(that.as) :that.as != null) return false;
            if (authProvider != null ? !authProvider.equals(that.authProvider) :that.authProvider != null) return false;
            if (clientCertificate != null ? !clientCertificate.equals(that.clientCertificate) :that.clientCertificate != null) return false;
            if (clientCertificateData != null ? !clientCertificateData.equals(that.clientCertificateData) :that.clientCertificateData != null) return false;
            if (clientKey != null ? !clientKey.equals(that.clientKey) :that.clientKey != null) return false;
            if (clientKeyData != null ? !clientKeyData.equals(that.clientKeyData) :that.clientKeyData != null) return false;
            if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
            if (password != null ? !password.equals(that.password) :that.password != null) return false;
            if (token != null ? !token.equals(that.token) :that.token != null) return false;
            if (username != null ? !username.equals(that.username) :that.username != null) return false;
            return true;
    }


    public class AuthProviderNestedImpl<N> extends AuthProviderConfigFluentImpl<AuthInfoFluent.AuthProviderNested<N>> implements AuthInfoFluent.AuthProviderNested<N>,Nested<N>{

            private final AuthProviderConfigBuilder builder;
    
            AuthProviderNestedImpl(AuthProviderConfig item){
                    this.builder = new AuthProviderConfigBuilder(this, item);
            }
            AuthProviderNestedImpl(){
                    this.builder = new AuthProviderConfigBuilder(this);
            }
    
    public N and(){
            return (N) AuthInfoFluentImpl.this.withAuthProvider(builder.build());
    }
    public N endAuthProvider(){
            return and();
    }

}
    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<AuthInfoFluent.ExtensionsNested<N>> implements AuthInfoFluent.ExtensionsNested<N>,Nested<N>{

            private final NamedExtensionBuilder builder;
    
            ExtensionsNestedImpl(){
                    this.builder = new NamedExtensionBuilder(this);
            }
            ExtensionsNestedImpl(NamedExtension item){
                    this.builder = new NamedExtensionBuilder(this, item);
            }
    
    public N and(){
            return (N) AuthInfoFluentImpl.this.addToExtensions(builder.build());
    }
    public N endExtension(){
            return and();
    }

}


}
