package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface BindingFluent<A extends BindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public BindingFluent.MetadataNested<A> withNewMetadata();
    public BindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public BindingFluent.MetadataNested<A> editMetadata();
    public ObjectReference getTarget();
    public A withTarget(ObjectReference target);
    public BindingFluent.TargetNested<A> withNewTarget();
    public BindingFluent.TargetNested<A> withNewTargetLike(ObjectReference item);
    public BindingFluent.TargetNested<A> editTarget();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<BindingFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface TargetNested<N> extends Nested<N>,ObjectReferenceFluent<BindingFluent.TargetNested<N>>{

        
    public N and();    public N endTarget();
}


}
