package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class ConfigMapVolumeSourceBuilder extends ConfigMapVolumeSourceFluentImpl<ConfigMapVolumeSourceBuilder> implements VisitableBuilder<ConfigMapVolumeSource,ConfigMapVolumeSourceBuilder>{

    ConfigMapVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigMapVolumeSourceBuilder(){
            this(true);
    }
    public ConfigMapVolumeSourceBuilder(Boolean validationEnabled){
            this(new ConfigMapVolumeSource(), validationEnabled);
    }
    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConfigMapVolumeSource(), validationEnabled);
    }
    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent,ConfigMapVolumeSource instance){
            this(fluent, instance, true);
    }
    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent,ConfigMapVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withItems(instance.getItems()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSource instance){
            this(instance,true);
    }
    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withItems(instance.getItems()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConfigMapVolumeSource build(){
            ConfigMapVolumeSource buildable = new ConfigMapVolumeSource(fluent.getItems(),fluent.getName());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigMapVolumeSourceBuilder that = (ConfigMapVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
