package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ContextFluent<A extends ContextFluent<A>> extends Fluent<A>{


    public String getCluster();
    public A withCluster(String cluster);
    public A addToExtensions(NamedExtension... items);
    public A removeFromExtensions(NamedExtension... items);
    public List<NamedExtension> getExtensions();
    public A withExtensions(List<NamedExtension> extensions);
    public A withExtensions(NamedExtension... extensions);
    public ContextFluent.ExtensionsNested<A> addNewExtension();
    public ContextFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item);
    public String getNamespace();
    public A withNamespace(String namespace);
    public String getUser();
    public A withUser(String user);

    public interface ExtensionsNested<N> extends Nested<N>,NamedExtensionFluent<ContextFluent.ExtensionsNested<N>>{

        
    public N and();    public N endExtension();
}


}
