package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.String;
import java.lang.Integer;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class EndpointSubsetFluentImpl<A extends EndpointSubsetFluent<A>> extends BaseFluent<A> implements EndpointSubsetFluent<A>{

    private List<VisitableBuilder<? extends EndpointAddress,?>> addresses =  new ArrayList<VisitableBuilder<? extends EndpointAddress,?>>();
    private List<VisitableBuilder<? extends EndpointAddress,?>> notReadyAddresses =  new ArrayList<VisitableBuilder<? extends EndpointAddress,?>>();
    private List<VisitableBuilder<? extends EndpointPort,?>> ports =  new ArrayList<VisitableBuilder<? extends EndpointPort,?>>();

    public EndpointSubsetFluentImpl(){
    }
    public EndpointSubsetFluentImpl(EndpointSubset instance){
            this.withAddresses(instance.getAddresses()); 
            this.withNotReadyAddresses(instance.getNotReadyAddresses()); 
            this.withPorts(instance.getPorts()); 
    }

    public A addToAddresses(EndpointAddress... items){
            for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A removeFromAddresses(EndpointAddress... items){
            for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.remove(builder);this.addresses.remove(builder);} return (A)this;
    }

    public List<EndpointAddress> getAddresses(){
            return build(addresses);
    }

    public A withAddresses(List<EndpointAddress> addresses){
            this.addresses.clear();
            if (addresses != null) {for (EndpointAddress item : addresses){this.addToAddresses(item);}} return (A) this;
    }

    public A withAddresses(EndpointAddress... addresses){
            this.addresses.clear(); if (addresses != null) {for (EndpointAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public EndpointSubsetFluent.AddressesNested<A> addNewAddress(){
            return new AddressesNestedImpl();
    }

    public EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(EndpointAddress item){
            return new AddressesNestedImpl(item);
    }

    public A addToNotReadyAddresses(EndpointAddress... items){
            for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.add(builder);this.notReadyAddresses.add(builder);} return (A)this;
    }

    public A removeFromNotReadyAddresses(EndpointAddress... items){
            for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.remove(builder);this.notReadyAddresses.remove(builder);} return (A)this;
    }

    public List<EndpointAddress> getNotReadyAddresses(){
            return build(notReadyAddresses);
    }

    public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses){
            this.notReadyAddresses.clear();
            if (notReadyAddresses != null) {for (EndpointAddress item : notReadyAddresses){this.addToNotReadyAddresses(item);}} return (A) this;
    }

    public A withNotReadyAddresses(EndpointAddress... notReadyAddresses){
            this.notReadyAddresses.clear(); if (notReadyAddresses != null) {for (EndpointAddress item :notReadyAddresses){ this.addToNotReadyAddresses(item);}} return (A) this;
    }

    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress(){
            return new NotReadyAddressesNestedImpl();
    }

    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item){
            return new NotReadyAddressesNestedImpl(item);
    }

    public A addToPorts(EndpointPort... items){
            for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(EndpointPort... items){
            for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.remove(builder);this.ports.remove(builder);} return (A)this;
    }

    public List<EndpointPort> getPorts(){
            return build(ports);
    }

    public A withPorts(List<EndpointPort> ports){
            this.ports.clear();
            if (ports != null) {for (EndpointPort item : ports){this.addToPorts(item);}} return (A) this;
    }

    public A withPorts(EndpointPort... ports){
            this.ports.clear(); if (ports != null) {for (EndpointPort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public EndpointSubsetFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public EndpointSubsetFluent.PortsNested<A> addNewPortLike(EndpointPort item){
            return new PortsNestedImpl(item);
    }

    public A addNewPort(String name,Integer port,String protocol){
            return (A)addToPorts(new EndpointPort(name, port, protocol));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointSubsetFluentImpl that = (EndpointSubsetFluentImpl) o;
            if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
            if (notReadyAddresses != null ? !notReadyAddresses.equals(that.notReadyAddresses) :that.notReadyAddresses != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            return true;
    }


    public class AddressesNestedImpl<N> extends EndpointAddressFluentImpl<EndpointSubsetFluent.AddressesNested<N>> implements EndpointSubsetFluent.AddressesNested<N>,Nested<N>{

            private final EndpointAddressBuilder builder;
    
            AddressesNestedImpl(){
                    this.builder = new EndpointAddressBuilder(this);
            }
            AddressesNestedImpl(EndpointAddress item){
                    this.builder = new EndpointAddressBuilder(this, item);
            }
    
    public N endAddress(){
            return and();
    }
    public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToAddresses(builder.build());
    }

}
    public class NotReadyAddressesNestedImpl<N> extends EndpointAddressFluentImpl<EndpointSubsetFluent.NotReadyAddressesNested<N>> implements EndpointSubsetFluent.NotReadyAddressesNested<N>,Nested<N>{

            private final EndpointAddressBuilder builder;
    
            NotReadyAddressesNestedImpl(){
                    this.builder = new EndpointAddressBuilder(this);
            }
            NotReadyAddressesNestedImpl(EndpointAddress item){
                    this.builder = new EndpointAddressBuilder(this, item);
            }
    
    public N endNotReadyAddress(){
            return and();
    }
    public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToNotReadyAddresses(builder.build());
    }

}
    public class PortsNestedImpl<N> extends EndpointPortFluentImpl<EndpointSubsetFluent.PortsNested<N>> implements EndpointSubsetFluent.PortsNested<N>,Nested<N>{

            private final EndpointPortBuilder builder;
    
            PortsNestedImpl(){
                    this.builder = new EndpointPortBuilder(this);
            }
            PortsNestedImpl(EndpointPort item){
                    this.builder = new EndpointPortBuilder(this, item);
            }
    
    public N endPort(){
            return and();
    }
    public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToPorts(builder.build());
    }

}


}
