package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface EndpointsListFluent<A extends EndpointsListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Endpoints... items);
    public A removeFromItems(Endpoints... items);
    public List<Endpoints> getItems();
    public A withItems(List<Endpoints> items);
    public A withItems(Endpoints... items);
    public EndpointsListFluent.ItemsNested<A> addNewItem();
    public EndpointsListFluent.ItemsNested<A> addNewItemLike(Endpoints item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public EndpointsListFluent.MetadataNested<A> withNewMetadata();
    public EndpointsListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public EndpointsListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,EndpointsFluent<EndpointsListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<EndpointsListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
