package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class EventListFluentImpl<A extends EventListFluent<A>> extends BaseFluent<A> implements EventListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends Event,?>> items =  new ArrayList<VisitableBuilder<? extends Event,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public EventListFluentImpl(){
    }
    public EventListFluentImpl(EventList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(Event... items){
            for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Event... items){
            for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<Event> getItems(){
            return build(items);
    }

    public A withItems(List<Event> items){
            this.items.clear();
            if (items != null) {for (Event item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(Event... items){
            this.items.clear(); if (items != null) {for (Event item :items){ this.addToItems(item);}} return (A) this;
    }

    public EventListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public EventListFluent.ItemsNested<A> addNewItemLike(Event item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public EventListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public EventListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public EventListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EventListFluentImpl that = (EventListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends EventFluentImpl<EventListFluent.ItemsNested<N>> implements EventListFluent.ItemsNested<N>,Nested<N>{

            private final EventBuilder builder;
    
            ItemsNestedImpl(Event item){
                    this.builder = new EventBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.builder = new EventBuilder(this);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) EventListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<EventListFluent.MetadataNested<N>> implements EventListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) EventListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
