package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.ClusterPolicyBindingList;
import io.fabric8.openshift.api.model.ClusterPolicyList;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetList;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityList;
import io.fabric8.openshift.api.model.ImageList;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.extensions.JobList;
import java.lang.String;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.PolicyBindingList;
import io.fabric8.openshift.api.model.PolicyList;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.RoleList;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.kubernetes.api.model.extensions.Scale;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.TagEvent;
import java.lang.Long;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.BuildConfigListFluentImpl;
import io.fabric8.openshift.api.model.BuildConfigListBuilder;
import io.fabric8.openshift.api.model.BuildListFluentImpl;
import io.fabric8.openshift.api.model.BuildListBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluentImpl;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyBindingFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyBindingBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyBindingListFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyBindingListBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyListFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyListBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBindingListFluentImpl;
import io.fabric8.openshift.api.model.ClusterRoleBindingListBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetListBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigListFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigListBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentListFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentListBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackBuilder;
import io.fabric8.openshift.api.model.GroupFluentImpl;
import io.fabric8.openshift.api.model.GroupBuilder;
import io.fabric8.openshift.api.model.GroupListFluentImpl;
import io.fabric8.openshift.api.model.GroupListBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerListFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerListBuilder;
import io.fabric8.openshift.api.model.IdentityFluentImpl;
import io.fabric8.openshift.api.model.IdentityBuilder;
import io.fabric8.openshift.api.model.IdentityListFluentImpl;
import io.fabric8.openshift.api.model.IdentityListBuilder;
import io.fabric8.openshift.api.model.ImageListFluentImpl;
import io.fabric8.openshift.api.model.ImageListBuilder;
import io.fabric8.openshift.api.model.ImageStreamListFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamListBuilder;
import io.fabric8.openshift.api.model.ImageStreamTagListFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamTagListBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressListFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressListBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.JobBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobListFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.JobListBuilder;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewFluentImpl;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluentImpl;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenListFluentImpl;
import io.fabric8.openshift.api.model.OAuthAccessTokenListBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluentImpl;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenListFluentImpl;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenListBuilder;
import io.fabric8.openshift.api.model.OAuthClientFluentImpl;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentImpl;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationListFluentImpl;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationListBuilder;
import io.fabric8.openshift.api.model.OAuthClientListFluentImpl;
import io.fabric8.openshift.api.model.OAuthClientListBuilder;
import io.fabric8.openshift.api.model.PolicyFluentImpl;
import io.fabric8.openshift.api.model.PolicyBuilder;
import io.fabric8.openshift.api.model.PolicyBindingFluentImpl;
import io.fabric8.openshift.api.model.PolicyBindingBuilder;
import io.fabric8.openshift.api.model.PolicyBindingListFluentImpl;
import io.fabric8.openshift.api.model.PolicyBindingListBuilder;
import io.fabric8.openshift.api.model.PolicyListFluentImpl;
import io.fabric8.openshift.api.model.PolicyListBuilder;
import io.fabric8.openshift.api.model.ProjectFluentImpl;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.ProjectListFluentImpl;
import io.fabric8.openshift.api.model.ProjectListBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluentImpl;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetListFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetListBuilder;
import io.fabric8.openshift.api.model.RoleFluentImpl;
import io.fabric8.openshift.api.model.RoleBuilder;
import io.fabric8.openshift.api.model.RoleBindingFluentImpl;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.openshift.api.model.RoleBindingListFluentImpl;
import io.fabric8.openshift.api.model.RoleBindingListBuilder;
import io.fabric8.openshift.api.model.RoleListFluentImpl;
import io.fabric8.openshift.api.model.RoleListBuilder;
import io.fabric8.openshift.api.model.RouteListFluentImpl;
import io.fabric8.openshift.api.model.RouteListBuilder;
import io.fabric8.kubernetes.api.model.extensions.ScaleFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ScaleBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewFluentImpl;
import io.fabric8.openshift.api.model.SubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponseFluentImpl;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponseBuilder;
import io.fabric8.openshift.api.model.TagEventFluentImpl;
import io.fabric8.openshift.api.model.TagEventBuilder;
import io.fabric8.openshift.api.model.TemplateFluentImpl;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateListFluentImpl;
import io.fabric8.openshift.api.model.TemplateListBuilder;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceBuilder;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceListFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceListBuilder;
import io.fabric8.openshift.api.model.UserFluentImpl;
import io.fabric8.openshift.api.model.UserBuilder;
import io.fabric8.openshift.api.model.UserListFluentImpl;
import io.fabric8.openshift.api.model.UserListBuilder;

public class KubeSchemaFluentImpl<A extends KubeSchemaFluent<A>> extends BaseFluent<A> implements KubeSchemaFluent<A>{

    private VisitableBuilder<? extends BaseKubernetesList,?> baseKubernetesList;
    private VisitableBuilder<? extends Binding,?> binding;
    private VisitableBuilder<? extends BuildConfigList,?> buildConfigList;
    private VisitableBuilder<? extends BuildList,?> buildList;
    private VisitableBuilder<? extends BuildRequest,?> buildRequest;
    private VisitableBuilder<? extends ClusterPolicy,?> clusterPolicy;
    private VisitableBuilder<? extends ClusterPolicyBinding,?> clusterPolicyBinding;
    private VisitableBuilder<? extends ClusterPolicyBindingList,?> clusterPolicyBindingList;
    private VisitableBuilder<? extends ClusterPolicyList,?> clusterPolicyList;
    private VisitableBuilder<? extends ClusterRoleBinding,?> clusterRoleBinding;
    private VisitableBuilder<? extends ClusterRoleBindingList,?> clusterRoleBindingList;
    private VisitableBuilder<? extends ComponentStatusList,?> componentStatusList;
    private VisitableBuilder<? extends Config,?> config;
    private VisitableBuilder<? extends ConfigMap,?> configMap;
    private VisitableBuilder<? extends ConfigMapList,?> configMapList;
    private VisitableBuilder<? extends ContainerStatus,?> containerStatus;
    private VisitableBuilder<? extends DaemonSet,?> daemonSet;
    private VisitableBuilder<? extends DaemonSetList,?> daemonSetList;
    private VisitableBuilder<? extends DeleteOptions,?> deleteOptions;
    private VisitableBuilder<? extends Deployment,?> deployment;
    private VisitableBuilder<? extends DeploymentConfigList,?> deploymentConfigList;
    private VisitableBuilder<? extends DeploymentList,?> deploymentList;
    private VisitableBuilder<? extends DeploymentRollback,?> deploymentRollback;
    private VisitableBuilder<? extends Endpoints,?> endpoints;
    private VisitableBuilder<? extends EndpointsList,?> endpointsList;
    private VisitableBuilder<? extends EnvVar,?> envVar;
    private VisitableBuilder<? extends EventList,?> eventList;
    private VisitableBuilder<? extends Group,?> group;
    private VisitableBuilder<? extends GroupList,?> groupList;
    private VisitableBuilder<? extends HorizontalPodAutoscaler,?> horizontalPodAutoscaler;
    private VisitableBuilder<? extends HorizontalPodAutoscalerList,?> horizontalPodAutoscalerList;
    private VisitableBuilder<? extends Identity,?> identity;
    private VisitableBuilder<? extends IdentityList,?> identityList;
    private VisitableBuilder<? extends ImageList,?> imageList;
    private VisitableBuilder<? extends ImageStreamList,?> imageStreamList;
    private VisitableBuilder<? extends ImageStreamTagList,?> imageStreamTagList;
    private VisitableBuilder<? extends Ingress,?> ingress;
    private VisitableBuilder<? extends IngressList,?> ingressList;
    private VisitableBuilder<? extends Job,?> job;
    private VisitableBuilder<? extends JobList,?> jobList;
    private VisitableBuilder<? extends LimitRangeList,?> limitRangeList;
    private VisitableBuilder<? extends ListMeta,?> listMeta;
    private VisitableBuilder<? extends LocalSubjectAccessReview,?> localSubjectAccessReview;
    private VisitableBuilder<? extends Namespace,?> namespace;
    private VisitableBuilder<? extends NamespaceList,?> namespaceList;
    private VisitableBuilder<? extends Node,?> node;
    private VisitableBuilder<? extends NodeList,?> nodeList;
    private VisitableBuilder<? extends OAuthAccessToken,?> oAuthAccessToken;
    private VisitableBuilder<? extends OAuthAccessTokenList,?> oAuthAccessTokenList;
    private VisitableBuilder<? extends OAuthAuthorizeToken,?> oAuthAuthorizeToken;
    private VisitableBuilder<? extends OAuthAuthorizeTokenList,?> oAuthAuthorizeTokenList;
    private VisitableBuilder<? extends OAuthClient,?> oAuthClient;
    private VisitableBuilder<? extends OAuthClientAuthorization,?> oAuthClientAuthorization;
    private VisitableBuilder<? extends OAuthClientAuthorizationList,?> oAuthClientAuthorizationList;
    private VisitableBuilder<? extends OAuthClientList,?> oAuthClientList;
    private VisitableBuilder<? extends ObjectMeta,?> objectMeta;
    private VisitableBuilder<? extends Patch,?> patch;
    private VisitableBuilder<? extends PersistentVolume,?> persistentVolume;
    private VisitableBuilder<? extends PersistentVolumeClaim,?> persistentVolumeClaim;
    private VisitableBuilder<? extends PersistentVolumeClaimList,?> persistentVolumeClaimList;
    private VisitableBuilder<? extends PersistentVolumeList,?> persistentVolumeList;
    private VisitableBuilder<? extends PodList,?> podList;
    private VisitableBuilder<? extends PodTemplateList,?> podTemplateList;
    private VisitableBuilder<? extends Policy,?> policy;
    private VisitableBuilder<? extends PolicyBinding,?> policyBinding;
    private VisitableBuilder<? extends PolicyBindingList,?> policyBindingList;
    private VisitableBuilder<? extends PolicyList,?> policyList;
    private VisitableBuilder<? extends Project,?> project;
    private VisitableBuilder<? extends ProjectList,?> projectList;
    private VisitableBuilder<? extends ProjectRequest,?> projectRequest;
    private VisitableBuilder<? extends Quantity,?> quantity;
    private VisitableBuilder<? extends ReplicaSet,?> replicaSet;
    private VisitableBuilder<? extends ReplicaSetList,?> replicaSetList;
    private VisitableBuilder<? extends ReplicationControllerList,?> replicationControllerList;
    private VisitableBuilder<? extends ResourceQuota,?> resourceQuota;
    private VisitableBuilder<? extends ResourceQuotaList,?> resourceQuotaList;
    private VisitableBuilder<? extends Role,?> role;
    private VisitableBuilder<? extends RoleBinding,?> roleBinding;
    private VisitableBuilder<? extends RoleBindingList,?> roleBindingList;
    private VisitableBuilder<? extends RoleList,?> roleList;
    private VisitableBuilder<? extends RootPaths,?> rootPaths;
    private VisitableBuilder<? extends RouteList,?> routeList;
    private VisitableBuilder<? extends Scale,?> scale;
    private VisitableBuilder<? extends Secret,?> secret;
    private VisitableBuilder<? extends SecretList,?> secretList;
    private VisitableBuilder<? extends SecurityContextConstraints,?> securityContextConstraints;
    private VisitableBuilder<? extends SecurityContextConstraintsList,?> securityContextConstraintsList;
    private VisitableBuilder<? extends ServiceAccount,?> serviceAccount;
    private VisitableBuilder<? extends ServiceAccountList,?> serviceAccountList;
    private VisitableBuilder<? extends ServiceList,?> serviceList;
    private VisitableBuilder<? extends Status,?> status;
    private VisitableBuilder<? extends SubjectAccessReview,?> subjectAccessReview;
    private VisitableBuilder<? extends SubjectAccessReviewResponse,?> subjectAccessReviewResponse;
    private VisitableBuilder<? extends TagEvent,?> tagEvent;
    private VisitableBuilder<? extends Template,?> template;
    private VisitableBuilder<? extends TemplateList,?> templateList;
    private VisitableBuilder<? extends ThirdPartyResource,?> thirdPartyResource;
    private VisitableBuilder<? extends ThirdPartyResourceList,?> thirdPartyResourceList;
    private VisitableBuilder<? extends User,?> user;
    private VisitableBuilder<? extends UserList,?> userList;
    private VisitableBuilder<? extends WatchEvent,?> watchEvent;

    public KubeSchemaFluentImpl(){
    }
    public KubeSchemaFluentImpl(KubeSchema instance){
            this.withBaseKubernetesList(instance.getBaseKubernetesList()); 
            this.withBinding(instance.getBinding()); 
            this.withBuildConfigList(instance.getBuildConfigList()); 
            this.withBuildList(instance.getBuildList()); 
            this.withBuildRequest(instance.getBuildRequest()); 
            this.withClusterPolicy(instance.getClusterPolicy()); 
            this.withClusterPolicyBinding(instance.getClusterPolicyBinding()); 
            this.withClusterPolicyBindingList(instance.getClusterPolicyBindingList()); 
            this.withClusterPolicyList(instance.getClusterPolicyList()); 
            this.withClusterRoleBinding(instance.getClusterRoleBinding()); 
            this.withClusterRoleBindingList(instance.getClusterRoleBindingList()); 
            this.withComponentStatusList(instance.getComponentStatusList()); 
            this.withConfig(instance.getConfig()); 
            this.withConfigMap(instance.getConfigMap()); 
            this.withConfigMapList(instance.getConfigMapList()); 
            this.withContainerStatus(instance.getContainerStatus()); 
            this.withDaemonSet(instance.getDaemonSet()); 
            this.withDaemonSetList(instance.getDaemonSetList()); 
            this.withDeleteOptions(instance.getDeleteOptions()); 
            this.withDeployment(instance.getDeployment()); 
            this.withDeploymentConfigList(instance.getDeploymentConfigList()); 
            this.withDeploymentList(instance.getDeploymentList()); 
            this.withDeploymentRollback(instance.getDeploymentRollback()); 
            this.withEndpoints(instance.getEndpoints()); 
            this.withEndpointsList(instance.getEndpointsList()); 
            this.withEnvVar(instance.getEnvVar()); 
            this.withEventList(instance.getEventList()); 
            this.withGroup(instance.getGroup()); 
            this.withGroupList(instance.getGroupList()); 
            this.withHorizontalPodAutoscaler(instance.getHorizontalPodAutoscaler()); 
            this.withHorizontalPodAutoscalerList(instance.getHorizontalPodAutoscalerList()); 
            this.withIdentity(instance.getIdentity()); 
            this.withIdentityList(instance.getIdentityList()); 
            this.withImageList(instance.getImageList()); 
            this.withImageStreamList(instance.getImageStreamList()); 
            this.withImageStreamTagList(instance.getImageStreamTagList()); 
            this.withIngress(instance.getIngress()); 
            this.withIngressList(instance.getIngressList()); 
            this.withJob(instance.getJob()); 
            this.withJobList(instance.getJobList()); 
            this.withLimitRangeList(instance.getLimitRangeList()); 
            this.withListMeta(instance.getListMeta()); 
            this.withLocalSubjectAccessReview(instance.getLocalSubjectAccessReview()); 
            this.withNamespace(instance.getNamespace()); 
            this.withNamespaceList(instance.getNamespaceList()); 
            this.withNode(instance.getNode()); 
            this.withNodeList(instance.getNodeList()); 
            this.withOAuthAccessToken(instance.getOAuthAccessToken()); 
            this.withOAuthAccessTokenList(instance.getOAuthAccessTokenList()); 
            this.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken()); 
            this.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList()); 
            this.withOAuthClient(instance.getOAuthClient()); 
            this.withOAuthClientAuthorization(instance.getOAuthClientAuthorization()); 
            this.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList()); 
            this.withOAuthClientList(instance.getOAuthClientList()); 
            this.withObjectMeta(instance.getObjectMeta()); 
            this.withPatch(instance.getPatch()); 
            this.withPersistentVolume(instance.getPersistentVolume()); 
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
            this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); 
            this.withPersistentVolumeList(instance.getPersistentVolumeList()); 
            this.withPodList(instance.getPodList()); 
            this.withPodTemplateList(instance.getPodTemplateList()); 
            this.withPolicy(instance.getPolicy()); 
            this.withPolicyBinding(instance.getPolicyBinding()); 
            this.withPolicyBindingList(instance.getPolicyBindingList()); 
            this.withPolicyList(instance.getPolicyList()); 
            this.withProject(instance.getProject()); 
            this.withProjectList(instance.getProjectList()); 
            this.withProjectRequest(instance.getProjectRequest()); 
            this.withQuantity(instance.getQuantity()); 
            this.withReplicaSet(instance.getReplicaSet()); 
            this.withReplicaSetList(instance.getReplicaSetList()); 
            this.withReplicationControllerList(instance.getReplicationControllerList()); 
            this.withResourceQuota(instance.getResourceQuota()); 
            this.withResourceQuotaList(instance.getResourceQuotaList()); 
            this.withRole(instance.getRole()); 
            this.withRoleBinding(instance.getRoleBinding()); 
            this.withRoleBindingList(instance.getRoleBindingList()); 
            this.withRoleList(instance.getRoleList()); 
            this.withRootPaths(instance.getRootPaths()); 
            this.withRouteList(instance.getRouteList()); 
            this.withScale(instance.getScale()); 
            this.withSecret(instance.getSecret()); 
            this.withSecretList(instance.getSecretList()); 
            this.withSecurityContextConstraints(instance.getSecurityContextConstraints()); 
            this.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withServiceAccountList(instance.getServiceAccountList()); 
            this.withServiceList(instance.getServiceList()); 
            this.withStatus(instance.getStatus()); 
            this.withSubjectAccessReview(instance.getSubjectAccessReview()); 
            this.withSubjectAccessReviewResponse(instance.getSubjectAccessReviewResponse()); 
            this.withTagEvent(instance.getTagEvent()); 
            this.withTemplate(instance.getTemplate()); 
            this.withTemplateList(instance.getTemplateList()); 
            this.withThirdPartyResource(instance.getThirdPartyResource()); 
            this.withThirdPartyResourceList(instance.getThirdPartyResourceList()); 
            this.withUser(instance.getUser()); 
            this.withUserList(instance.getUserList()); 
            this.withWatchEvent(instance.getWatchEvent()); 
    }

    public BaseKubernetesList getBaseKubernetesList(){
            return this.baseKubernetesList!=null?this.baseKubernetesList.build():null;
    }

    public A withBaseKubernetesList(BaseKubernetesList baseKubernetesList){
            if (baseKubernetesList!=null){ this.baseKubernetesList= new BaseKubernetesListBuilder(baseKubernetesList); _visitables.add(this.baseKubernetesList);} return (A) this;
    }

    public KubeSchemaFluent.BaseKubernetesListNested<A> withNewBaseKubernetesList(){
            return new BaseKubernetesListNestedImpl();
    }

    public KubeSchemaFluent.BaseKubernetesListNested<A> withNewBaseKubernetesListLike(BaseKubernetesList item){
            return new BaseKubernetesListNestedImpl(item);
    }

    public KubeSchemaFluent.BaseKubernetesListNested<A> editBaseKubernetesList(){
            return withNewBaseKubernetesListLike(getBaseKubernetesList());
    }

    public Binding getBinding(){
            return this.binding!=null?this.binding.build():null;
    }

    public A withBinding(Binding binding){
            if (binding!=null){ this.binding= new BindingBuilder(binding); _visitables.add(this.binding);} return (A) this;
    }

    public KubeSchemaFluent.BindingNested<A> withNewBinding(){
            return new BindingNestedImpl();
    }

    public KubeSchemaFluent.BindingNested<A> withNewBindingLike(Binding item){
            return new BindingNestedImpl(item);
    }

    public KubeSchemaFluent.BindingNested<A> editBinding(){
            return withNewBindingLike(getBinding());
    }

    public BuildConfigList getBuildConfigList(){
            return this.buildConfigList!=null?this.buildConfigList.build():null;
    }

    public A withBuildConfigList(BuildConfigList buildConfigList){
            if (buildConfigList!=null){ this.buildConfigList= new BuildConfigListBuilder(buildConfigList); _visitables.add(this.buildConfigList);} return (A) this;
    }

    public KubeSchemaFluent.BuildConfigListNested<A> withNewBuildConfigList(){
            return new BuildConfigListNestedImpl();
    }

    public KubeSchemaFluent.BuildConfigListNested<A> withNewBuildConfigListLike(BuildConfigList item){
            return new BuildConfigListNestedImpl(item);
    }

    public KubeSchemaFluent.BuildConfigListNested<A> editBuildConfigList(){
            return withNewBuildConfigListLike(getBuildConfigList());
    }

    public BuildList getBuildList(){
            return this.buildList!=null?this.buildList.build():null;
    }

    public A withBuildList(BuildList buildList){
            if (buildList!=null){ this.buildList= new BuildListBuilder(buildList); _visitables.add(this.buildList);} return (A) this;
    }

    public KubeSchemaFluent.BuildListNested<A> withNewBuildList(){
            return new BuildListNestedImpl();
    }

    public KubeSchemaFluent.BuildListNested<A> withNewBuildListLike(BuildList item){
            return new BuildListNestedImpl(item);
    }

    public KubeSchemaFluent.BuildListNested<A> editBuildList(){
            return withNewBuildListLike(getBuildList());
    }

    public BuildRequest getBuildRequest(){
            return this.buildRequest!=null?this.buildRequest.build():null;
    }

    public A withBuildRequest(BuildRequest buildRequest){
            if (buildRequest!=null){ this.buildRequest= new BuildRequestBuilder(buildRequest); _visitables.add(this.buildRequest);} return (A) this;
    }

    public KubeSchemaFluent.BuildRequestNested<A> withNewBuildRequest(){
            return new BuildRequestNestedImpl();
    }

    public KubeSchemaFluent.BuildRequestNested<A> withNewBuildRequestLike(BuildRequest item){
            return new BuildRequestNestedImpl(item);
    }

    public KubeSchemaFluent.BuildRequestNested<A> editBuildRequest(){
            return withNewBuildRequestLike(getBuildRequest());
    }

    public ClusterPolicy getClusterPolicy(){
            return this.clusterPolicy!=null?this.clusterPolicy.build():null;
    }

    public A withClusterPolicy(ClusterPolicy clusterPolicy){
            if (clusterPolicy!=null){ this.clusterPolicy= new ClusterPolicyBuilder(clusterPolicy); _visitables.add(this.clusterPolicy);} return (A) this;
    }

    public KubeSchemaFluent.ClusterPolicyNested<A> withNewClusterPolicy(){
            return new ClusterPolicyNestedImpl();
    }

    public KubeSchemaFluent.ClusterPolicyNested<A> withNewClusterPolicyLike(ClusterPolicy item){
            return new ClusterPolicyNestedImpl(item);
    }

    public KubeSchemaFluent.ClusterPolicyNested<A> editClusterPolicy(){
            return withNewClusterPolicyLike(getClusterPolicy());
    }

    public ClusterPolicyBinding getClusterPolicyBinding(){
            return this.clusterPolicyBinding!=null?this.clusterPolicyBinding.build():null;
    }

    public A withClusterPolicyBinding(ClusterPolicyBinding clusterPolicyBinding){
            if (clusterPolicyBinding!=null){ this.clusterPolicyBinding= new ClusterPolicyBindingBuilder(clusterPolicyBinding); _visitables.add(this.clusterPolicyBinding);} return (A) this;
    }

    public KubeSchemaFluent.ClusterPolicyBindingNested<A> withNewClusterPolicyBinding(){
            return new ClusterPolicyBindingNestedImpl();
    }

    public KubeSchemaFluent.ClusterPolicyBindingNested<A> withNewClusterPolicyBindingLike(ClusterPolicyBinding item){
            return new ClusterPolicyBindingNestedImpl(item);
    }

    public KubeSchemaFluent.ClusterPolicyBindingNested<A> editClusterPolicyBinding(){
            return withNewClusterPolicyBindingLike(getClusterPolicyBinding());
    }

    public ClusterPolicyBindingList getClusterPolicyBindingList(){
            return this.clusterPolicyBindingList!=null?this.clusterPolicyBindingList.build():null;
    }

    public A withClusterPolicyBindingList(ClusterPolicyBindingList clusterPolicyBindingList){
            if (clusterPolicyBindingList!=null){ this.clusterPolicyBindingList= new ClusterPolicyBindingListBuilder(clusterPolicyBindingList); _visitables.add(this.clusterPolicyBindingList);} return (A) this;
    }

    public KubeSchemaFluent.ClusterPolicyBindingListNested<A> withNewClusterPolicyBindingList(){
            return new ClusterPolicyBindingListNestedImpl();
    }

    public KubeSchemaFluent.ClusterPolicyBindingListNested<A> withNewClusterPolicyBindingListLike(ClusterPolicyBindingList item){
            return new ClusterPolicyBindingListNestedImpl(item);
    }

    public KubeSchemaFluent.ClusterPolicyBindingListNested<A> editClusterPolicyBindingList(){
            return withNewClusterPolicyBindingListLike(getClusterPolicyBindingList());
    }

    public ClusterPolicyList getClusterPolicyList(){
            return this.clusterPolicyList!=null?this.clusterPolicyList.build():null;
    }

    public A withClusterPolicyList(ClusterPolicyList clusterPolicyList){
            if (clusterPolicyList!=null){ this.clusterPolicyList= new ClusterPolicyListBuilder(clusterPolicyList); _visitables.add(this.clusterPolicyList);} return (A) this;
    }

    public KubeSchemaFluent.ClusterPolicyListNested<A> withNewClusterPolicyList(){
            return new ClusterPolicyListNestedImpl();
    }

    public KubeSchemaFluent.ClusterPolicyListNested<A> withNewClusterPolicyListLike(ClusterPolicyList item){
            return new ClusterPolicyListNestedImpl(item);
    }

    public KubeSchemaFluent.ClusterPolicyListNested<A> editClusterPolicyList(){
            return withNewClusterPolicyListLike(getClusterPolicyList());
    }

    public ClusterRoleBinding getClusterRoleBinding(){
            return this.clusterRoleBinding!=null?this.clusterRoleBinding.build():null;
    }

    public A withClusterRoleBinding(ClusterRoleBinding clusterRoleBinding){
            if (clusterRoleBinding!=null){ this.clusterRoleBinding= new ClusterRoleBindingBuilder(clusterRoleBinding); _visitables.add(this.clusterRoleBinding);} return (A) this;
    }

    public KubeSchemaFluent.ClusterRoleBindingNested<A> withNewClusterRoleBinding(){
            return new ClusterRoleBindingNestedImpl();
    }

    public KubeSchemaFluent.ClusterRoleBindingNested<A> withNewClusterRoleBindingLike(ClusterRoleBinding item){
            return new ClusterRoleBindingNestedImpl(item);
    }

    public KubeSchemaFluent.ClusterRoleBindingNested<A> editClusterRoleBinding(){
            return withNewClusterRoleBindingLike(getClusterRoleBinding());
    }

    public ClusterRoleBindingList getClusterRoleBindingList(){
            return this.clusterRoleBindingList!=null?this.clusterRoleBindingList.build():null;
    }

    public A withClusterRoleBindingList(ClusterRoleBindingList clusterRoleBindingList){
            if (clusterRoleBindingList!=null){ this.clusterRoleBindingList= new ClusterRoleBindingListBuilder(clusterRoleBindingList); _visitables.add(this.clusterRoleBindingList);} return (A) this;
    }

    public KubeSchemaFluent.ClusterRoleBindingListNested<A> withNewClusterRoleBindingList(){
            return new ClusterRoleBindingListNestedImpl();
    }

    public KubeSchemaFluent.ClusterRoleBindingListNested<A> withNewClusterRoleBindingListLike(ClusterRoleBindingList item){
            return new ClusterRoleBindingListNestedImpl(item);
    }

    public KubeSchemaFluent.ClusterRoleBindingListNested<A> editClusterRoleBindingList(){
            return withNewClusterRoleBindingListLike(getClusterRoleBindingList());
    }

    public ComponentStatusList getComponentStatusList(){
            return this.componentStatusList!=null?this.componentStatusList.build():null;
    }

    public A withComponentStatusList(ComponentStatusList componentStatusList){
            if (componentStatusList!=null){ this.componentStatusList= new ComponentStatusListBuilder(componentStatusList); _visitables.add(this.componentStatusList);} return (A) this;
    }

    public KubeSchemaFluent.ComponentStatusListNested<A> withNewComponentStatusList(){
            return new ComponentStatusListNestedImpl();
    }

    public KubeSchemaFluent.ComponentStatusListNested<A> withNewComponentStatusListLike(ComponentStatusList item){
            return new ComponentStatusListNestedImpl(item);
    }

    public KubeSchemaFluent.ComponentStatusListNested<A> editComponentStatusList(){
            return withNewComponentStatusListLike(getComponentStatusList());
    }

    public Config getConfig(){
            return this.config!=null?this.config.build():null;
    }

    public A withConfig(Config config){
            if (config!=null){ this.config= new ConfigBuilder(config); _visitables.add(this.config);} return (A) this;
    }

    public KubeSchemaFluent.ConfigNested<A> withNewConfig(){
            return new ConfigNestedImpl();
    }

    public KubeSchemaFluent.ConfigNested<A> withNewConfigLike(Config item){
            return new ConfigNestedImpl(item);
    }

    public KubeSchemaFluent.ConfigNested<A> editConfig(){
            return withNewConfigLike(getConfig());
    }

    public ConfigMap getConfigMap(){
            return this.configMap!=null?this.configMap.build():null;
    }

    public A withConfigMap(ConfigMap configMap){
            if (configMap!=null){ this.configMap= new ConfigMapBuilder(configMap); _visitables.add(this.configMap);} return (A) this;
    }

    public KubeSchemaFluent.ConfigMapNested<A> withNewConfigMap(){
            return new ConfigMapNestedImpl();
    }

    public KubeSchemaFluent.ConfigMapNested<A> withNewConfigMapLike(ConfigMap item){
            return new ConfigMapNestedImpl(item);
    }

    public KubeSchemaFluent.ConfigMapNested<A> editConfigMap(){
            return withNewConfigMapLike(getConfigMap());
    }

    public ConfigMapList getConfigMapList(){
            return this.configMapList!=null?this.configMapList.build():null;
    }

    public A withConfigMapList(ConfigMapList configMapList){
            if (configMapList!=null){ this.configMapList= new ConfigMapListBuilder(configMapList); _visitables.add(this.configMapList);} return (A) this;
    }

    public KubeSchemaFluent.ConfigMapListNested<A> withNewConfigMapList(){
            return new ConfigMapListNestedImpl();
    }

    public KubeSchemaFluent.ConfigMapListNested<A> withNewConfigMapListLike(ConfigMapList item){
            return new ConfigMapListNestedImpl(item);
    }

    public KubeSchemaFluent.ConfigMapListNested<A> editConfigMapList(){
            return withNewConfigMapListLike(getConfigMapList());
    }

    public ContainerStatus getContainerStatus(){
            return this.containerStatus!=null?this.containerStatus.build():null;
    }

    public A withContainerStatus(ContainerStatus containerStatus){
            if (containerStatus!=null){ this.containerStatus= new ContainerStatusBuilder(containerStatus); _visitables.add(this.containerStatus);} return (A) this;
    }

    public KubeSchemaFluent.ContainerStatusNested<A> withNewContainerStatus(){
            return new ContainerStatusNestedImpl();
    }

    public KubeSchemaFluent.ContainerStatusNested<A> withNewContainerStatusLike(ContainerStatus item){
            return new ContainerStatusNestedImpl(item);
    }

    public KubeSchemaFluent.ContainerStatusNested<A> editContainerStatus(){
            return withNewContainerStatusLike(getContainerStatus());
    }

    public DaemonSet getDaemonSet(){
            return this.daemonSet!=null?this.daemonSet.build():null;
    }

    public A withDaemonSet(DaemonSet daemonSet){
            if (daemonSet!=null){ this.daemonSet= new DaemonSetBuilder(daemonSet); _visitables.add(this.daemonSet);} return (A) this;
    }

    public KubeSchemaFluent.DaemonSetNested<A> withNewDaemonSet(){
            return new DaemonSetNestedImpl();
    }

    public KubeSchemaFluent.DaemonSetNested<A> withNewDaemonSetLike(DaemonSet item){
            return new DaemonSetNestedImpl(item);
    }

    public KubeSchemaFluent.DaemonSetNested<A> editDaemonSet(){
            return withNewDaemonSetLike(getDaemonSet());
    }

    public DaemonSetList getDaemonSetList(){
            return this.daemonSetList!=null?this.daemonSetList.build():null;
    }

    public A withDaemonSetList(DaemonSetList daemonSetList){
            if (daemonSetList!=null){ this.daemonSetList= new DaemonSetListBuilder(daemonSetList); _visitables.add(this.daemonSetList);} return (A) this;
    }

    public KubeSchemaFluent.DaemonSetListNested<A> withNewDaemonSetList(){
            return new DaemonSetListNestedImpl();
    }

    public KubeSchemaFluent.DaemonSetListNested<A> withNewDaemonSetListLike(DaemonSetList item){
            return new DaemonSetListNestedImpl(item);
    }

    public KubeSchemaFluent.DaemonSetListNested<A> editDaemonSetList(){
            return withNewDaemonSetListLike(getDaemonSetList());
    }

    public DeleteOptions getDeleteOptions(){
            return this.deleteOptions!=null?this.deleteOptions.build():null;
    }

    public A withDeleteOptions(DeleteOptions deleteOptions){
            if (deleteOptions!=null){ this.deleteOptions= new DeleteOptionsBuilder(deleteOptions); _visitables.add(this.deleteOptions);} return (A) this;
    }

    public KubeSchemaFluent.DeleteOptionsNested<A> withNewDeleteOptions(){
            return new DeleteOptionsNestedImpl();
    }

    public KubeSchemaFluent.DeleteOptionsNested<A> withNewDeleteOptionsLike(DeleteOptions item){
            return new DeleteOptionsNestedImpl(item);
    }

    public KubeSchemaFluent.DeleteOptionsNested<A> editDeleteOptions(){
            return withNewDeleteOptionsLike(getDeleteOptions());
    }

    public Deployment getDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(Deployment deployment){
            if (deployment!=null){ this.deployment= new DeploymentBuilder(deployment); _visitables.add(this.deployment);} return (A) this;
    }

    public KubeSchemaFluent.DeploymentNested<A> withNewDeployment(){
            return new DeploymentNestedImpl();
    }

    public KubeSchemaFluent.DeploymentNested<A> withNewDeploymentLike(Deployment item){
            return new DeploymentNestedImpl(item);
    }

    public KubeSchemaFluent.DeploymentNested<A> editDeployment(){
            return withNewDeploymentLike(getDeployment());
    }

    public DeploymentConfigList getDeploymentConfigList(){
            return this.deploymentConfigList!=null?this.deploymentConfigList.build():null;
    }

    public A withDeploymentConfigList(DeploymentConfigList deploymentConfigList){
            if (deploymentConfigList!=null){ this.deploymentConfigList= new DeploymentConfigListBuilder(deploymentConfigList); _visitables.add(this.deploymentConfigList);} return (A) this;
    }

    public KubeSchemaFluent.DeploymentConfigListNested<A> withNewDeploymentConfigList(){
            return new DeploymentConfigListNestedImpl();
    }

    public KubeSchemaFluent.DeploymentConfigListNested<A> withNewDeploymentConfigListLike(DeploymentConfigList item){
            return new DeploymentConfigListNestedImpl(item);
    }

    public KubeSchemaFluent.DeploymentConfigListNested<A> editDeploymentConfigList(){
            return withNewDeploymentConfigListLike(getDeploymentConfigList());
    }

    public DeploymentList getDeploymentList(){
            return this.deploymentList!=null?this.deploymentList.build():null;
    }

    public A withDeploymentList(DeploymentList deploymentList){
            if (deploymentList!=null){ this.deploymentList= new DeploymentListBuilder(deploymentList); _visitables.add(this.deploymentList);} return (A) this;
    }

    public KubeSchemaFluent.DeploymentListNested<A> withNewDeploymentList(){
            return new DeploymentListNestedImpl();
    }

    public KubeSchemaFluent.DeploymentListNested<A> withNewDeploymentListLike(DeploymentList item){
            return new DeploymentListNestedImpl(item);
    }

    public KubeSchemaFluent.DeploymentListNested<A> editDeploymentList(){
            return withNewDeploymentListLike(getDeploymentList());
    }

    public DeploymentRollback getDeploymentRollback(){
            return this.deploymentRollback!=null?this.deploymentRollback.build():null;
    }

    public A withDeploymentRollback(DeploymentRollback deploymentRollback){
            if (deploymentRollback!=null){ this.deploymentRollback= new DeploymentRollbackBuilder(deploymentRollback); _visitables.add(this.deploymentRollback);} return (A) this;
    }

    public KubeSchemaFluent.DeploymentRollbackNested<A> withNewDeploymentRollback(){
            return new DeploymentRollbackNestedImpl();
    }

    public KubeSchemaFluent.DeploymentRollbackNested<A> withNewDeploymentRollbackLike(DeploymentRollback item){
            return new DeploymentRollbackNestedImpl(item);
    }

    public KubeSchemaFluent.DeploymentRollbackNested<A> editDeploymentRollback(){
            return withNewDeploymentRollbackLike(getDeploymentRollback());
    }

    public Endpoints getEndpoints(){
            return this.endpoints!=null?this.endpoints.build():null;
    }

    public A withEndpoints(Endpoints endpoints){
            if (endpoints!=null){ this.endpoints= new EndpointsBuilder(endpoints); _visitables.add(this.endpoints);} return (A) this;
    }

    public KubeSchemaFluent.EndpointsNested<A> withNewEndpoints(){
            return new EndpointsNestedImpl();
    }

    public KubeSchemaFluent.EndpointsNested<A> withNewEndpointsLike(Endpoints item){
            return new EndpointsNestedImpl(item);
    }

    public KubeSchemaFluent.EndpointsNested<A> editEndpoints(){
            return withNewEndpointsLike(getEndpoints());
    }

    public EndpointsList getEndpointsList(){
            return this.endpointsList!=null?this.endpointsList.build():null;
    }

    public A withEndpointsList(EndpointsList endpointsList){
            if (endpointsList!=null){ this.endpointsList= new EndpointsListBuilder(endpointsList); _visitables.add(this.endpointsList);} return (A) this;
    }

    public KubeSchemaFluent.EndpointsListNested<A> withNewEndpointsList(){
            return new EndpointsListNestedImpl();
    }

    public KubeSchemaFluent.EndpointsListNested<A> withNewEndpointsListLike(EndpointsList item){
            return new EndpointsListNestedImpl(item);
    }

    public KubeSchemaFluent.EndpointsListNested<A> editEndpointsList(){
            return withNewEndpointsListLike(getEndpointsList());
    }

    public EnvVar getEnvVar(){
            return this.envVar!=null?this.envVar.build():null;
    }

    public A withEnvVar(EnvVar envVar){
            if (envVar!=null){ this.envVar= new EnvVarBuilder(envVar); _visitables.add(this.envVar);} return (A) this;
    }

    public KubeSchemaFluent.EnvVarNested<A> withNewEnvVar(){
            return new EnvVarNestedImpl();
    }

    public KubeSchemaFluent.EnvVarNested<A> withNewEnvVarLike(EnvVar item){
            return new EnvVarNestedImpl(item);
    }

    public KubeSchemaFluent.EnvVarNested<A> editEnvVar(){
            return withNewEnvVarLike(getEnvVar());
    }

    public EventList getEventList(){
            return this.eventList!=null?this.eventList.build():null;
    }

    public A withEventList(EventList eventList){
            if (eventList!=null){ this.eventList= new EventListBuilder(eventList); _visitables.add(this.eventList);} return (A) this;
    }

    public KubeSchemaFluent.EventListNested<A> withNewEventList(){
            return new EventListNestedImpl();
    }

    public KubeSchemaFluent.EventListNested<A> withNewEventListLike(EventList item){
            return new EventListNestedImpl(item);
    }

    public KubeSchemaFluent.EventListNested<A> editEventList(){
            return withNewEventListLike(getEventList());
    }

    public Group getGroup(){
            return this.group!=null?this.group.build():null;
    }

    public A withGroup(Group group){
            if (group!=null){ this.group= new GroupBuilder(group); _visitables.add(this.group);} return (A) this;
    }

    public KubeSchemaFluent.GroupNested<A> withNewGroup(){
            return new GroupNestedImpl();
    }

    public KubeSchemaFluent.GroupNested<A> withNewGroupLike(Group item){
            return new GroupNestedImpl(item);
    }

    public KubeSchemaFluent.GroupNested<A> editGroup(){
            return withNewGroupLike(getGroup());
    }

    public GroupList getGroupList(){
            return this.groupList!=null?this.groupList.build():null;
    }

    public A withGroupList(GroupList groupList){
            if (groupList!=null){ this.groupList= new GroupListBuilder(groupList); _visitables.add(this.groupList);} return (A) this;
    }

    public KubeSchemaFluent.GroupListNested<A> withNewGroupList(){
            return new GroupListNestedImpl();
    }

    public KubeSchemaFluent.GroupListNested<A> withNewGroupListLike(GroupList item){
            return new GroupListNestedImpl(item);
    }

    public KubeSchemaFluent.GroupListNested<A> editGroupList(){
            return withNewGroupListLike(getGroupList());
    }

    public HorizontalPodAutoscaler getHorizontalPodAutoscaler(){
            return this.horizontalPodAutoscaler!=null?this.horizontalPodAutoscaler.build():null;
    }

    public A withHorizontalPodAutoscaler(HorizontalPodAutoscaler horizontalPodAutoscaler){
            if (horizontalPodAutoscaler!=null){ this.horizontalPodAutoscaler= new HorizontalPodAutoscalerBuilder(horizontalPodAutoscaler); _visitables.add(this.horizontalPodAutoscaler);} return (A) this;
    }

    public KubeSchemaFluent.HorizontalPodAutoscalerNested<A> withNewHorizontalPodAutoscaler(){
            return new HorizontalPodAutoscalerNestedImpl();
    }

    public KubeSchemaFluent.HorizontalPodAutoscalerNested<A> withNewHorizontalPodAutoscalerLike(HorizontalPodAutoscaler item){
            return new HorizontalPodAutoscalerNestedImpl(item);
    }

    public KubeSchemaFluent.HorizontalPodAutoscalerNested<A> editHorizontalPodAutoscaler(){
            return withNewHorizontalPodAutoscalerLike(getHorizontalPodAutoscaler());
    }

    public HorizontalPodAutoscalerList getHorizontalPodAutoscalerList(){
            return this.horizontalPodAutoscalerList!=null?this.horizontalPodAutoscalerList.build():null;
    }

    public A withHorizontalPodAutoscalerList(HorizontalPodAutoscalerList horizontalPodAutoscalerList){
            if (horizontalPodAutoscalerList!=null){ this.horizontalPodAutoscalerList= new HorizontalPodAutoscalerListBuilder(horizontalPodAutoscalerList); _visitables.add(this.horizontalPodAutoscalerList);} return (A) this;
    }

    public KubeSchemaFluent.HorizontalPodAutoscalerListNested<A> withNewHorizontalPodAutoscalerList(){
            return new HorizontalPodAutoscalerListNestedImpl();
    }

    public KubeSchemaFluent.HorizontalPodAutoscalerListNested<A> withNewHorizontalPodAutoscalerListLike(HorizontalPodAutoscalerList item){
            return new HorizontalPodAutoscalerListNestedImpl(item);
    }

    public KubeSchemaFluent.HorizontalPodAutoscalerListNested<A> editHorizontalPodAutoscalerList(){
            return withNewHorizontalPodAutoscalerListLike(getHorizontalPodAutoscalerList());
    }

    public Identity getIdentity(){
            return this.identity!=null?this.identity.build():null;
    }

    public A withIdentity(Identity identity){
            if (identity!=null){ this.identity= new IdentityBuilder(identity); _visitables.add(this.identity);} return (A) this;
    }

    public KubeSchemaFluent.IdentityNested<A> withNewIdentity(){
            return new IdentityNestedImpl();
    }

    public KubeSchemaFluent.IdentityNested<A> withNewIdentityLike(Identity item){
            return new IdentityNestedImpl(item);
    }

    public KubeSchemaFluent.IdentityNested<A> editIdentity(){
            return withNewIdentityLike(getIdentity());
    }

    public IdentityList getIdentityList(){
            return this.identityList!=null?this.identityList.build():null;
    }

    public A withIdentityList(IdentityList identityList){
            if (identityList!=null){ this.identityList= new IdentityListBuilder(identityList); _visitables.add(this.identityList);} return (A) this;
    }

    public KubeSchemaFluent.IdentityListNested<A> withNewIdentityList(){
            return new IdentityListNestedImpl();
    }

    public KubeSchemaFluent.IdentityListNested<A> withNewIdentityListLike(IdentityList item){
            return new IdentityListNestedImpl(item);
    }

    public KubeSchemaFluent.IdentityListNested<A> editIdentityList(){
            return withNewIdentityListLike(getIdentityList());
    }

    public ImageList getImageList(){
            return this.imageList!=null?this.imageList.build():null;
    }

    public A withImageList(ImageList imageList){
            if (imageList!=null){ this.imageList= new ImageListBuilder(imageList); _visitables.add(this.imageList);} return (A) this;
    }

    public KubeSchemaFluent.ImageListNested<A> withNewImageList(){
            return new ImageListNestedImpl();
    }

    public KubeSchemaFluent.ImageListNested<A> withNewImageListLike(ImageList item){
            return new ImageListNestedImpl(item);
    }

    public KubeSchemaFluent.ImageListNested<A> editImageList(){
            return withNewImageListLike(getImageList());
    }

    public ImageStreamList getImageStreamList(){
            return this.imageStreamList!=null?this.imageStreamList.build():null;
    }

    public A withImageStreamList(ImageStreamList imageStreamList){
            if (imageStreamList!=null){ this.imageStreamList= new ImageStreamListBuilder(imageStreamList); _visitables.add(this.imageStreamList);} return (A) this;
    }

    public KubeSchemaFluent.ImageStreamListNested<A> withNewImageStreamList(){
            return new ImageStreamListNestedImpl();
    }

    public KubeSchemaFluent.ImageStreamListNested<A> withNewImageStreamListLike(ImageStreamList item){
            return new ImageStreamListNestedImpl(item);
    }

    public KubeSchemaFluent.ImageStreamListNested<A> editImageStreamList(){
            return withNewImageStreamListLike(getImageStreamList());
    }

    public ImageStreamTagList getImageStreamTagList(){
            return this.imageStreamTagList!=null?this.imageStreamTagList.build():null;
    }

    public A withImageStreamTagList(ImageStreamTagList imageStreamTagList){
            if (imageStreamTagList!=null){ this.imageStreamTagList= new ImageStreamTagListBuilder(imageStreamTagList); _visitables.add(this.imageStreamTagList);} return (A) this;
    }

    public KubeSchemaFluent.ImageStreamTagListNested<A> withNewImageStreamTagList(){
            return new ImageStreamTagListNestedImpl();
    }

    public KubeSchemaFluent.ImageStreamTagListNested<A> withNewImageStreamTagListLike(ImageStreamTagList item){
            return new ImageStreamTagListNestedImpl(item);
    }

    public KubeSchemaFluent.ImageStreamTagListNested<A> editImageStreamTagList(){
            return withNewImageStreamTagListLike(getImageStreamTagList());
    }

    public Ingress getIngress(){
            return this.ingress!=null?this.ingress.build():null;
    }

    public A withIngress(Ingress ingress){
            if (ingress!=null){ this.ingress= new IngressBuilder(ingress); _visitables.add(this.ingress);} return (A) this;
    }

    public KubeSchemaFluent.IngressNested<A> withNewIngress(){
            return new IngressNestedImpl();
    }

    public KubeSchemaFluent.IngressNested<A> withNewIngressLike(Ingress item){
            return new IngressNestedImpl(item);
    }

    public KubeSchemaFluent.IngressNested<A> editIngress(){
            return withNewIngressLike(getIngress());
    }

    public IngressList getIngressList(){
            return this.ingressList!=null?this.ingressList.build():null;
    }

    public A withIngressList(IngressList ingressList){
            if (ingressList!=null){ this.ingressList= new IngressListBuilder(ingressList); _visitables.add(this.ingressList);} return (A) this;
    }

    public KubeSchemaFluent.IngressListNested<A> withNewIngressList(){
            return new IngressListNestedImpl();
    }

    public KubeSchemaFluent.IngressListNested<A> withNewIngressListLike(IngressList item){
            return new IngressListNestedImpl(item);
    }

    public KubeSchemaFluent.IngressListNested<A> editIngressList(){
            return withNewIngressListLike(getIngressList());
    }

    public Job getJob(){
            return this.job!=null?this.job.build():null;
    }

    public A withJob(Job job){
            if (job!=null){ this.job= new JobBuilder(job); _visitables.add(this.job);} return (A) this;
    }

    public KubeSchemaFluent.JobNested<A> withNewJob(){
            return new JobNestedImpl();
    }

    public KubeSchemaFluent.JobNested<A> withNewJobLike(Job item){
            return new JobNestedImpl(item);
    }

    public KubeSchemaFluent.JobNested<A> editJob(){
            return withNewJobLike(getJob());
    }

    public JobList getJobList(){
            return this.jobList!=null?this.jobList.build():null;
    }

    public A withJobList(JobList jobList){
            if (jobList!=null){ this.jobList= new JobListBuilder(jobList); _visitables.add(this.jobList);} return (A) this;
    }

    public KubeSchemaFluent.JobListNested<A> withNewJobList(){
            return new JobListNestedImpl();
    }

    public KubeSchemaFluent.JobListNested<A> withNewJobListLike(JobList item){
            return new JobListNestedImpl(item);
    }

    public KubeSchemaFluent.JobListNested<A> editJobList(){
            return withNewJobListLike(getJobList());
    }

    public LimitRangeList getLimitRangeList(){
            return this.limitRangeList!=null?this.limitRangeList.build():null;
    }

    public A withLimitRangeList(LimitRangeList limitRangeList){
            if (limitRangeList!=null){ this.limitRangeList= new LimitRangeListBuilder(limitRangeList); _visitables.add(this.limitRangeList);} return (A) this;
    }

    public KubeSchemaFluent.LimitRangeListNested<A> withNewLimitRangeList(){
            return new LimitRangeListNestedImpl();
    }

    public KubeSchemaFluent.LimitRangeListNested<A> withNewLimitRangeListLike(LimitRangeList item){
            return new LimitRangeListNestedImpl(item);
    }

    public KubeSchemaFluent.LimitRangeListNested<A> editLimitRangeList(){
            return withNewLimitRangeListLike(getLimitRangeList());
    }

    public ListMeta getListMeta(){
            return this.listMeta!=null?this.listMeta.build():null;
    }

    public A withListMeta(ListMeta listMeta){
            if (listMeta!=null){ this.listMeta= new ListMetaBuilder(listMeta); _visitables.add(this.listMeta);} return (A) this;
    }

    public KubeSchemaFluent.ListMetaNested<A> withNewListMeta(){
            return new ListMetaNestedImpl();
    }

    public KubeSchemaFluent.ListMetaNested<A> withNewListMetaLike(ListMeta item){
            return new ListMetaNestedImpl(item);
    }

    public KubeSchemaFluent.ListMetaNested<A> editListMeta(){
            return withNewListMetaLike(getListMeta());
    }

    public A withNewListMeta(String resourceVersion,String selfLink){
            return (A)withListMeta(new ListMeta(resourceVersion, selfLink));
    }

    public LocalSubjectAccessReview getLocalSubjectAccessReview(){
            return this.localSubjectAccessReview!=null?this.localSubjectAccessReview.build():null;
    }

    public A withLocalSubjectAccessReview(LocalSubjectAccessReview localSubjectAccessReview){
            if (localSubjectAccessReview!=null){ this.localSubjectAccessReview= new LocalSubjectAccessReviewBuilder(localSubjectAccessReview); _visitables.add(this.localSubjectAccessReview);} return (A) this;
    }

    public KubeSchemaFluent.LocalSubjectAccessReviewNested<A> withNewLocalSubjectAccessReview(){
            return new LocalSubjectAccessReviewNestedImpl();
    }

    public KubeSchemaFluent.LocalSubjectAccessReviewNested<A> withNewLocalSubjectAccessReviewLike(LocalSubjectAccessReview item){
            return new LocalSubjectAccessReviewNestedImpl(item);
    }

    public KubeSchemaFluent.LocalSubjectAccessReviewNested<A> editLocalSubjectAccessReview(){
            return withNewLocalSubjectAccessReviewLike(getLocalSubjectAccessReview());
    }

    public Namespace getNamespace(){
            return this.namespace!=null?this.namespace.build():null;
    }

    public A withNamespace(Namespace namespace){
            if (namespace!=null){ this.namespace= new NamespaceBuilder(namespace); _visitables.add(this.namespace);} return (A) this;
    }

    public KubeSchemaFluent.NamespaceNested<A> withNewNamespace(){
            return new NamespaceNestedImpl();
    }

    public KubeSchemaFluent.NamespaceNested<A> withNewNamespaceLike(Namespace item){
            return new NamespaceNestedImpl(item);
    }

    public KubeSchemaFluent.NamespaceNested<A> editNamespace(){
            return withNewNamespaceLike(getNamespace());
    }

    public NamespaceList getNamespaceList(){
            return this.namespaceList!=null?this.namespaceList.build():null;
    }

    public A withNamespaceList(NamespaceList namespaceList){
            if (namespaceList!=null){ this.namespaceList= new NamespaceListBuilder(namespaceList); _visitables.add(this.namespaceList);} return (A) this;
    }

    public KubeSchemaFluent.NamespaceListNested<A> withNewNamespaceList(){
            return new NamespaceListNestedImpl();
    }

    public KubeSchemaFluent.NamespaceListNested<A> withNewNamespaceListLike(NamespaceList item){
            return new NamespaceListNestedImpl(item);
    }

    public KubeSchemaFluent.NamespaceListNested<A> editNamespaceList(){
            return withNewNamespaceListLike(getNamespaceList());
    }

    public Node getNode(){
            return this.node!=null?this.node.build():null;
    }

    public A withNode(Node node){
            if (node!=null){ this.node= new NodeBuilder(node); _visitables.add(this.node);} return (A) this;
    }

    public KubeSchemaFluent.NodeNested<A> withNewNode(){
            return new NodeNestedImpl();
    }

    public KubeSchemaFluent.NodeNested<A> withNewNodeLike(Node item){
            return new NodeNestedImpl(item);
    }

    public KubeSchemaFluent.NodeNested<A> editNode(){
            return withNewNodeLike(getNode());
    }

    public NodeList getNodeList(){
            return this.nodeList!=null?this.nodeList.build():null;
    }

    public A withNodeList(NodeList nodeList){
            if (nodeList!=null){ this.nodeList= new NodeListBuilder(nodeList); _visitables.add(this.nodeList);} return (A) this;
    }

    public KubeSchemaFluent.NodeListNested<A> withNewNodeList(){
            return new NodeListNestedImpl();
    }

    public KubeSchemaFluent.NodeListNested<A> withNewNodeListLike(NodeList item){
            return new NodeListNestedImpl(item);
    }

    public KubeSchemaFluent.NodeListNested<A> editNodeList(){
            return withNewNodeListLike(getNodeList());
    }

    public OAuthAccessToken getOAuthAccessToken(){
            return this.oAuthAccessToken!=null?this.oAuthAccessToken.build():null;
    }

    public A withOAuthAccessToken(OAuthAccessToken oAuthAccessToken){
            if (oAuthAccessToken!=null){ this.oAuthAccessToken= new OAuthAccessTokenBuilder(oAuthAccessToken); _visitables.add(this.oAuthAccessToken);} return (A) this;
    }

    public KubeSchemaFluent.OAuthAccessTokenNested<A> withNewOAuthAccessToken(){
            return new OAuthAccessTokenNestedImpl();
    }

    public KubeSchemaFluent.OAuthAccessTokenNested<A> withNewOAuthAccessTokenLike(OAuthAccessToken item){
            return new OAuthAccessTokenNestedImpl(item);
    }

    public KubeSchemaFluent.OAuthAccessTokenNested<A> editOAuthAccessToken(){
            return withNewOAuthAccessTokenLike(getOAuthAccessToken());
    }

    public OAuthAccessTokenList getOAuthAccessTokenList(){
            return this.oAuthAccessTokenList!=null?this.oAuthAccessTokenList.build():null;
    }

    public A withOAuthAccessTokenList(OAuthAccessTokenList oAuthAccessTokenList){
            if (oAuthAccessTokenList!=null){ this.oAuthAccessTokenList= new OAuthAccessTokenListBuilder(oAuthAccessTokenList); _visitables.add(this.oAuthAccessTokenList);} return (A) this;
    }

    public KubeSchemaFluent.OAuthAccessTokenListNested<A> withNewOAuthAccessTokenList(){
            return new OAuthAccessTokenListNestedImpl();
    }

    public KubeSchemaFluent.OAuthAccessTokenListNested<A> withNewOAuthAccessTokenListLike(OAuthAccessTokenList item){
            return new OAuthAccessTokenListNestedImpl(item);
    }

    public KubeSchemaFluent.OAuthAccessTokenListNested<A> editOAuthAccessTokenList(){
            return withNewOAuthAccessTokenListLike(getOAuthAccessTokenList());
    }

    public OAuthAuthorizeToken getOAuthAuthorizeToken(){
            return this.oAuthAuthorizeToken!=null?this.oAuthAuthorizeToken.build():null;
    }

    public A withOAuthAuthorizeToken(OAuthAuthorizeToken oAuthAuthorizeToken){
            if (oAuthAuthorizeToken!=null){ this.oAuthAuthorizeToken= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeToken); _visitables.add(this.oAuthAuthorizeToken);} return (A) this;
    }

    public KubeSchemaFluent.OAuthAuthorizeTokenNested<A> withNewOAuthAuthorizeToken(){
            return new OAuthAuthorizeTokenNestedImpl();
    }

    public KubeSchemaFluent.OAuthAuthorizeTokenNested<A> withNewOAuthAuthorizeTokenLike(OAuthAuthorizeToken item){
            return new OAuthAuthorizeTokenNestedImpl(item);
    }

    public KubeSchemaFluent.OAuthAuthorizeTokenNested<A> editOAuthAuthorizeToken(){
            return withNewOAuthAuthorizeTokenLike(getOAuthAuthorizeToken());
    }

    public OAuthAuthorizeTokenList getOAuthAuthorizeTokenList(){
            return this.oAuthAuthorizeTokenList!=null?this.oAuthAuthorizeTokenList.build():null;
    }

    public A withOAuthAuthorizeTokenList(OAuthAuthorizeTokenList oAuthAuthorizeTokenList){
            if (oAuthAuthorizeTokenList!=null){ this.oAuthAuthorizeTokenList= new OAuthAuthorizeTokenListBuilder(oAuthAuthorizeTokenList); _visitables.add(this.oAuthAuthorizeTokenList);} return (A) this;
    }

    public KubeSchemaFluent.OAuthAuthorizeTokenListNested<A> withNewOAuthAuthorizeTokenList(){
            return new OAuthAuthorizeTokenListNestedImpl();
    }

    public KubeSchemaFluent.OAuthAuthorizeTokenListNested<A> withNewOAuthAuthorizeTokenListLike(OAuthAuthorizeTokenList item){
            return new OAuthAuthorizeTokenListNestedImpl(item);
    }

    public KubeSchemaFluent.OAuthAuthorizeTokenListNested<A> editOAuthAuthorizeTokenList(){
            return withNewOAuthAuthorizeTokenListLike(getOAuthAuthorizeTokenList());
    }

    public OAuthClient getOAuthClient(){
            return this.oAuthClient!=null?this.oAuthClient.build():null;
    }

    public A withOAuthClient(OAuthClient oAuthClient){
            if (oAuthClient!=null){ this.oAuthClient= new OAuthClientBuilder(oAuthClient); _visitables.add(this.oAuthClient);} return (A) this;
    }

    public KubeSchemaFluent.OAuthClientNested<A> withNewOAuthClient(){
            return new OAuthClientNestedImpl();
    }

    public KubeSchemaFluent.OAuthClientNested<A> withNewOAuthClientLike(OAuthClient item){
            return new OAuthClientNestedImpl(item);
    }

    public KubeSchemaFluent.OAuthClientNested<A> editOAuthClient(){
            return withNewOAuthClientLike(getOAuthClient());
    }

    public OAuthClientAuthorization getOAuthClientAuthorization(){
            return this.oAuthClientAuthorization!=null?this.oAuthClientAuthorization.build():null;
    }

    public A withOAuthClientAuthorization(OAuthClientAuthorization oAuthClientAuthorization){
            if (oAuthClientAuthorization!=null){ this.oAuthClientAuthorization= new OAuthClientAuthorizationBuilder(oAuthClientAuthorization); _visitables.add(this.oAuthClientAuthorization);} return (A) this;
    }

    public KubeSchemaFluent.OAuthClientAuthorizationNested<A> withNewOAuthClientAuthorization(){
            return new OAuthClientAuthorizationNestedImpl();
    }

    public KubeSchemaFluent.OAuthClientAuthorizationNested<A> withNewOAuthClientAuthorizationLike(OAuthClientAuthorization item){
            return new OAuthClientAuthorizationNestedImpl(item);
    }

    public KubeSchemaFluent.OAuthClientAuthorizationNested<A> editOAuthClientAuthorization(){
            return withNewOAuthClientAuthorizationLike(getOAuthClientAuthorization());
    }

    public OAuthClientAuthorizationList getOAuthClientAuthorizationList(){
            return this.oAuthClientAuthorizationList!=null?this.oAuthClientAuthorizationList.build():null;
    }

    public A withOAuthClientAuthorizationList(OAuthClientAuthorizationList oAuthClientAuthorizationList){
            if (oAuthClientAuthorizationList!=null){ this.oAuthClientAuthorizationList= new OAuthClientAuthorizationListBuilder(oAuthClientAuthorizationList); _visitables.add(this.oAuthClientAuthorizationList);} return (A) this;
    }

    public KubeSchemaFluent.OAuthClientAuthorizationListNested<A> withNewOAuthClientAuthorizationList(){
            return new OAuthClientAuthorizationListNestedImpl();
    }

    public KubeSchemaFluent.OAuthClientAuthorizationListNested<A> withNewOAuthClientAuthorizationListLike(OAuthClientAuthorizationList item){
            return new OAuthClientAuthorizationListNestedImpl(item);
    }

    public KubeSchemaFluent.OAuthClientAuthorizationListNested<A> editOAuthClientAuthorizationList(){
            return withNewOAuthClientAuthorizationListLike(getOAuthClientAuthorizationList());
    }

    public OAuthClientList getOAuthClientList(){
            return this.oAuthClientList!=null?this.oAuthClientList.build():null;
    }

    public A withOAuthClientList(OAuthClientList oAuthClientList){
            if (oAuthClientList!=null){ this.oAuthClientList= new OAuthClientListBuilder(oAuthClientList); _visitables.add(this.oAuthClientList);} return (A) this;
    }

    public KubeSchemaFluent.OAuthClientListNested<A> withNewOAuthClientList(){
            return new OAuthClientListNestedImpl();
    }

    public KubeSchemaFluent.OAuthClientListNested<A> withNewOAuthClientListLike(OAuthClientList item){
            return new OAuthClientListNestedImpl(item);
    }

    public KubeSchemaFluent.OAuthClientListNested<A> editOAuthClientList(){
            return withNewOAuthClientListLike(getOAuthClientList());
    }

    public ObjectMeta getObjectMeta(){
            return this.objectMeta!=null?this.objectMeta.build():null;
    }

    public A withObjectMeta(ObjectMeta objectMeta){
            if (objectMeta!=null){ this.objectMeta= new ObjectMetaBuilder(objectMeta); _visitables.add(this.objectMeta);} return (A) this;
    }

    public KubeSchemaFluent.ObjectMetaNested<A> withNewObjectMeta(){
            return new ObjectMetaNestedImpl();
    }

    public KubeSchemaFluent.ObjectMetaNested<A> withNewObjectMetaLike(ObjectMeta item){
            return new ObjectMetaNestedImpl(item);
    }

    public KubeSchemaFluent.ObjectMetaNested<A> editObjectMeta(){
            return withNewObjectMetaLike(getObjectMeta());
    }

    public Patch getPatch(){
            return this.patch!=null?this.patch.build():null;
    }

    public A withPatch(Patch patch){
            if (patch!=null){ this.patch= new PatchBuilder(patch); _visitables.add(this.patch);} return (A) this;
    }

    public KubeSchemaFluent.PatchNested<A> withNewPatch(){
            return new PatchNestedImpl();
    }

    public KubeSchemaFluent.PatchNested<A> withNewPatchLike(Patch item){
            return new PatchNestedImpl(item);
    }

    public KubeSchemaFluent.PatchNested<A> editPatch(){
            return withNewPatchLike(getPatch());
    }

    public PersistentVolume getPersistentVolume(){
            return this.persistentVolume!=null?this.persistentVolume.build():null;
    }

    public A withPersistentVolume(PersistentVolume persistentVolume){
            if (persistentVolume!=null){ this.persistentVolume= new PersistentVolumeBuilder(persistentVolume); _visitables.add(this.persistentVolume);} return (A) this;
    }

    public KubeSchemaFluent.PersistentVolumeNested<A> withNewPersistentVolume(){
            return new PersistentVolumeNestedImpl();
    }

    public KubeSchemaFluent.PersistentVolumeNested<A> withNewPersistentVolumeLike(PersistentVolume item){
            return new PersistentVolumeNestedImpl(item);
    }

    public KubeSchemaFluent.PersistentVolumeNested<A> editPersistentVolume(){
            return withNewPersistentVolumeLike(getPersistentVolume());
    }

    public PersistentVolumeClaim getPersistentVolumeClaim(){
            return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public A withPersistentVolumeClaim(PersistentVolumeClaim persistentVolumeClaim){
            if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new PersistentVolumeClaimBuilder(persistentVolumeClaim); _visitables.add(this.persistentVolumeClaim);} return (A) this;
    }

    public KubeSchemaFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim(){
            return new PersistentVolumeClaimNestedImpl();
    }

    public KubeSchemaFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaim item){
            return new PersistentVolumeClaimNestedImpl(item);
    }

    public KubeSchemaFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim(){
            return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
    }

    public PersistentVolumeClaimList getPersistentVolumeClaimList(){
            return this.persistentVolumeClaimList!=null?this.persistentVolumeClaimList.build():null;
    }

    public A withPersistentVolumeClaimList(PersistentVolumeClaimList persistentVolumeClaimList){
            if (persistentVolumeClaimList!=null){ this.persistentVolumeClaimList= new PersistentVolumeClaimListBuilder(persistentVolumeClaimList); _visitables.add(this.persistentVolumeClaimList);} return (A) this;
    }

    public KubeSchemaFluent.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimList(){
            return new PersistentVolumeClaimListNestedImpl();
    }

    public KubeSchemaFluent.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimListLike(PersistentVolumeClaimList item){
            return new PersistentVolumeClaimListNestedImpl(item);
    }

    public KubeSchemaFluent.PersistentVolumeClaimListNested<A> editPersistentVolumeClaimList(){
            return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList());
    }

    public PersistentVolumeList getPersistentVolumeList(){
            return this.persistentVolumeList!=null?this.persistentVolumeList.build():null;
    }

    public A withPersistentVolumeList(PersistentVolumeList persistentVolumeList){
            if (persistentVolumeList!=null){ this.persistentVolumeList= new PersistentVolumeListBuilder(persistentVolumeList); _visitables.add(this.persistentVolumeList);} return (A) this;
    }

    public KubeSchemaFluent.PersistentVolumeListNested<A> withNewPersistentVolumeList(){
            return new PersistentVolumeListNestedImpl();
    }

    public KubeSchemaFluent.PersistentVolumeListNested<A> withNewPersistentVolumeListLike(PersistentVolumeList item){
            return new PersistentVolumeListNestedImpl(item);
    }

    public KubeSchemaFluent.PersistentVolumeListNested<A> editPersistentVolumeList(){
            return withNewPersistentVolumeListLike(getPersistentVolumeList());
    }

    public PodList getPodList(){
            return this.podList!=null?this.podList.build():null;
    }

    public A withPodList(PodList podList){
            if (podList!=null){ this.podList= new PodListBuilder(podList); _visitables.add(this.podList);} return (A) this;
    }

    public KubeSchemaFluent.PodListNested<A> withNewPodList(){
            return new PodListNestedImpl();
    }

    public KubeSchemaFluent.PodListNested<A> withNewPodListLike(PodList item){
            return new PodListNestedImpl(item);
    }

    public KubeSchemaFluent.PodListNested<A> editPodList(){
            return withNewPodListLike(getPodList());
    }

    public PodTemplateList getPodTemplateList(){
            return this.podTemplateList!=null?this.podTemplateList.build():null;
    }

    public A withPodTemplateList(PodTemplateList podTemplateList){
            if (podTemplateList!=null){ this.podTemplateList= new PodTemplateListBuilder(podTemplateList); _visitables.add(this.podTemplateList);} return (A) this;
    }

    public KubeSchemaFluent.PodTemplateListNested<A> withNewPodTemplateList(){
            return new PodTemplateListNestedImpl();
    }

    public KubeSchemaFluent.PodTemplateListNested<A> withNewPodTemplateListLike(PodTemplateList item){
            return new PodTemplateListNestedImpl(item);
    }

    public KubeSchemaFluent.PodTemplateListNested<A> editPodTemplateList(){
            return withNewPodTemplateListLike(getPodTemplateList());
    }

    public Policy getPolicy(){
            return this.policy!=null?this.policy.build():null;
    }

    public A withPolicy(Policy policy){
            if (policy!=null){ this.policy= new PolicyBuilder(policy); _visitables.add(this.policy);} return (A) this;
    }

    public KubeSchemaFluent.PolicyNested<A> withNewPolicy(){
            return new PolicyNestedImpl();
    }

    public KubeSchemaFluent.PolicyNested<A> withNewPolicyLike(Policy item){
            return new PolicyNestedImpl(item);
    }

    public KubeSchemaFluent.PolicyNested<A> editPolicy(){
            return withNewPolicyLike(getPolicy());
    }

    public PolicyBinding getPolicyBinding(){
            return this.policyBinding!=null?this.policyBinding.build():null;
    }

    public A withPolicyBinding(PolicyBinding policyBinding){
            if (policyBinding!=null){ this.policyBinding= new PolicyBindingBuilder(policyBinding); _visitables.add(this.policyBinding);} return (A) this;
    }

    public KubeSchemaFluent.PolicyBindingNested<A> withNewPolicyBinding(){
            return new PolicyBindingNestedImpl();
    }

    public KubeSchemaFluent.PolicyBindingNested<A> withNewPolicyBindingLike(PolicyBinding item){
            return new PolicyBindingNestedImpl(item);
    }

    public KubeSchemaFluent.PolicyBindingNested<A> editPolicyBinding(){
            return withNewPolicyBindingLike(getPolicyBinding());
    }

    public PolicyBindingList getPolicyBindingList(){
            return this.policyBindingList!=null?this.policyBindingList.build():null;
    }

    public A withPolicyBindingList(PolicyBindingList policyBindingList){
            if (policyBindingList!=null){ this.policyBindingList= new PolicyBindingListBuilder(policyBindingList); _visitables.add(this.policyBindingList);} return (A) this;
    }

    public KubeSchemaFluent.PolicyBindingListNested<A> withNewPolicyBindingList(){
            return new PolicyBindingListNestedImpl();
    }

    public KubeSchemaFluent.PolicyBindingListNested<A> withNewPolicyBindingListLike(PolicyBindingList item){
            return new PolicyBindingListNestedImpl(item);
    }

    public KubeSchemaFluent.PolicyBindingListNested<A> editPolicyBindingList(){
            return withNewPolicyBindingListLike(getPolicyBindingList());
    }

    public PolicyList getPolicyList(){
            return this.policyList!=null?this.policyList.build():null;
    }

    public A withPolicyList(PolicyList policyList){
            if (policyList!=null){ this.policyList= new PolicyListBuilder(policyList); _visitables.add(this.policyList);} return (A) this;
    }

    public KubeSchemaFluent.PolicyListNested<A> withNewPolicyList(){
            return new PolicyListNestedImpl();
    }

    public KubeSchemaFluent.PolicyListNested<A> withNewPolicyListLike(PolicyList item){
            return new PolicyListNestedImpl(item);
    }

    public KubeSchemaFluent.PolicyListNested<A> editPolicyList(){
            return withNewPolicyListLike(getPolicyList());
    }

    public Project getProject(){
            return this.project!=null?this.project.build():null;
    }

    public A withProject(Project project){
            if (project!=null){ this.project= new ProjectBuilder(project); _visitables.add(this.project);} return (A) this;
    }

    public KubeSchemaFluent.ProjectNested<A> withNewProject(){
            return new ProjectNestedImpl();
    }

    public KubeSchemaFluent.ProjectNested<A> withNewProjectLike(Project item){
            return new ProjectNestedImpl(item);
    }

    public KubeSchemaFluent.ProjectNested<A> editProject(){
            return withNewProjectLike(getProject());
    }

    public ProjectList getProjectList(){
            return this.projectList!=null?this.projectList.build():null;
    }

    public A withProjectList(ProjectList projectList){
            if (projectList!=null){ this.projectList= new ProjectListBuilder(projectList); _visitables.add(this.projectList);} return (A) this;
    }

    public KubeSchemaFluent.ProjectListNested<A> withNewProjectList(){
            return new ProjectListNestedImpl();
    }

    public KubeSchemaFluent.ProjectListNested<A> withNewProjectListLike(ProjectList item){
            return new ProjectListNestedImpl(item);
    }

    public KubeSchemaFluent.ProjectListNested<A> editProjectList(){
            return withNewProjectListLike(getProjectList());
    }

    public ProjectRequest getProjectRequest(){
            return this.projectRequest!=null?this.projectRequest.build():null;
    }

    public A withProjectRequest(ProjectRequest projectRequest){
            if (projectRequest!=null){ this.projectRequest= new ProjectRequestBuilder(projectRequest); _visitables.add(this.projectRequest);} return (A) this;
    }

    public KubeSchemaFluent.ProjectRequestNested<A> withNewProjectRequest(){
            return new ProjectRequestNestedImpl();
    }

    public KubeSchemaFluent.ProjectRequestNested<A> withNewProjectRequestLike(ProjectRequest item){
            return new ProjectRequestNestedImpl(item);
    }

    public KubeSchemaFluent.ProjectRequestNested<A> editProjectRequest(){
            return withNewProjectRequestLike(getProjectRequest());
    }

    public Quantity getQuantity(){
            return this.quantity!=null?this.quantity.build():null;
    }

    public A withQuantity(Quantity quantity){
            if (quantity!=null){ this.quantity= new QuantityBuilder(quantity); _visitables.add(this.quantity);} return (A) this;
    }

    public KubeSchemaFluent.QuantityNested<A> withNewQuantity(){
            return new QuantityNestedImpl();
    }

    public KubeSchemaFluent.QuantityNested<A> withNewQuantityLike(Quantity item){
            return new QuantityNestedImpl(item);
    }

    public KubeSchemaFluent.QuantityNested<A> editQuantity(){
            return withNewQuantityLike(getQuantity());
    }

    public A withNewQuantity(String amount){
            return (A)withQuantity(new Quantity(amount));
    }

    public A withNewQuantity(String amount,String format){
            return (A)withQuantity(new Quantity(amount, format));
    }

    public ReplicaSet getReplicaSet(){
            return this.replicaSet!=null?this.replicaSet.build():null;
    }

    public A withReplicaSet(ReplicaSet replicaSet){
            if (replicaSet!=null){ this.replicaSet= new ReplicaSetBuilder(replicaSet); _visitables.add(this.replicaSet);} return (A) this;
    }

    public KubeSchemaFluent.ReplicaSetNested<A> withNewReplicaSet(){
            return new ReplicaSetNestedImpl();
    }

    public KubeSchemaFluent.ReplicaSetNested<A> withNewReplicaSetLike(ReplicaSet item){
            return new ReplicaSetNestedImpl(item);
    }

    public KubeSchemaFluent.ReplicaSetNested<A> editReplicaSet(){
            return withNewReplicaSetLike(getReplicaSet());
    }

    public ReplicaSetList getReplicaSetList(){
            return this.replicaSetList!=null?this.replicaSetList.build():null;
    }

    public A withReplicaSetList(ReplicaSetList replicaSetList){
            if (replicaSetList!=null){ this.replicaSetList= new ReplicaSetListBuilder(replicaSetList); _visitables.add(this.replicaSetList);} return (A) this;
    }

    public KubeSchemaFluent.ReplicaSetListNested<A> withNewReplicaSetList(){
            return new ReplicaSetListNestedImpl();
    }

    public KubeSchemaFluent.ReplicaSetListNested<A> withNewReplicaSetListLike(ReplicaSetList item){
            return new ReplicaSetListNestedImpl(item);
    }

    public KubeSchemaFluent.ReplicaSetListNested<A> editReplicaSetList(){
            return withNewReplicaSetListLike(getReplicaSetList());
    }

    public ReplicationControllerList getReplicationControllerList(){
            return this.replicationControllerList!=null?this.replicationControllerList.build():null;
    }

    public A withReplicationControllerList(ReplicationControllerList replicationControllerList){
            if (replicationControllerList!=null){ this.replicationControllerList= new ReplicationControllerListBuilder(replicationControllerList); _visitables.add(this.replicationControllerList);} return (A) this;
    }

    public KubeSchemaFluent.ReplicationControllerListNested<A> withNewReplicationControllerList(){
            return new ReplicationControllerListNestedImpl();
    }

    public KubeSchemaFluent.ReplicationControllerListNested<A> withNewReplicationControllerListLike(ReplicationControllerList item){
            return new ReplicationControllerListNestedImpl(item);
    }

    public KubeSchemaFluent.ReplicationControllerListNested<A> editReplicationControllerList(){
            return withNewReplicationControllerListLike(getReplicationControllerList());
    }

    public ResourceQuota getResourceQuota(){
            return this.resourceQuota!=null?this.resourceQuota.build():null;
    }

    public A withResourceQuota(ResourceQuota resourceQuota){
            if (resourceQuota!=null){ this.resourceQuota= new ResourceQuotaBuilder(resourceQuota); _visitables.add(this.resourceQuota);} return (A) this;
    }

    public KubeSchemaFluent.ResourceQuotaNested<A> withNewResourceQuota(){
            return new ResourceQuotaNestedImpl();
    }

    public KubeSchemaFluent.ResourceQuotaNested<A> withNewResourceQuotaLike(ResourceQuota item){
            return new ResourceQuotaNestedImpl(item);
    }

    public KubeSchemaFluent.ResourceQuotaNested<A> editResourceQuota(){
            return withNewResourceQuotaLike(getResourceQuota());
    }

    public ResourceQuotaList getResourceQuotaList(){
            return this.resourceQuotaList!=null?this.resourceQuotaList.build():null;
    }

    public A withResourceQuotaList(ResourceQuotaList resourceQuotaList){
            if (resourceQuotaList!=null){ this.resourceQuotaList= new ResourceQuotaListBuilder(resourceQuotaList); _visitables.add(this.resourceQuotaList);} return (A) this;
    }

    public KubeSchemaFluent.ResourceQuotaListNested<A> withNewResourceQuotaList(){
            return new ResourceQuotaListNestedImpl();
    }

    public KubeSchemaFluent.ResourceQuotaListNested<A> withNewResourceQuotaListLike(ResourceQuotaList item){
            return new ResourceQuotaListNestedImpl(item);
    }

    public KubeSchemaFluent.ResourceQuotaListNested<A> editResourceQuotaList(){
            return withNewResourceQuotaListLike(getResourceQuotaList());
    }

    public Role getRole(){
            return this.role!=null?this.role.build():null;
    }

    public A withRole(Role role){
            if (role!=null){ this.role= new RoleBuilder(role); _visitables.add(this.role);} return (A) this;
    }

    public KubeSchemaFluent.RoleNested<A> withNewRole(){
            return new RoleNestedImpl();
    }

    public KubeSchemaFluent.RoleNested<A> withNewRoleLike(Role item){
            return new RoleNestedImpl(item);
    }

    public KubeSchemaFluent.RoleNested<A> editRole(){
            return withNewRoleLike(getRole());
    }

    public RoleBinding getRoleBinding(){
            return this.roleBinding!=null?this.roleBinding.build():null;
    }

    public A withRoleBinding(RoleBinding roleBinding){
            if (roleBinding!=null){ this.roleBinding= new RoleBindingBuilder(roleBinding); _visitables.add(this.roleBinding);} return (A) this;
    }

    public KubeSchemaFluent.RoleBindingNested<A> withNewRoleBinding(){
            return new RoleBindingNestedImpl();
    }

    public KubeSchemaFluent.RoleBindingNested<A> withNewRoleBindingLike(RoleBinding item){
            return new RoleBindingNestedImpl(item);
    }

    public KubeSchemaFluent.RoleBindingNested<A> editRoleBinding(){
            return withNewRoleBindingLike(getRoleBinding());
    }

    public RoleBindingList getRoleBindingList(){
            return this.roleBindingList!=null?this.roleBindingList.build():null;
    }

    public A withRoleBindingList(RoleBindingList roleBindingList){
            if (roleBindingList!=null){ this.roleBindingList= new RoleBindingListBuilder(roleBindingList); _visitables.add(this.roleBindingList);} return (A) this;
    }

    public KubeSchemaFluent.RoleBindingListNested<A> withNewRoleBindingList(){
            return new RoleBindingListNestedImpl();
    }

    public KubeSchemaFluent.RoleBindingListNested<A> withNewRoleBindingListLike(RoleBindingList item){
            return new RoleBindingListNestedImpl(item);
    }

    public KubeSchemaFluent.RoleBindingListNested<A> editRoleBindingList(){
            return withNewRoleBindingListLike(getRoleBindingList());
    }

    public RoleList getRoleList(){
            return this.roleList!=null?this.roleList.build():null;
    }

    public A withRoleList(RoleList roleList){
            if (roleList!=null){ this.roleList= new RoleListBuilder(roleList); _visitables.add(this.roleList);} return (A) this;
    }

    public KubeSchemaFluent.RoleListNested<A> withNewRoleList(){
            return new RoleListNestedImpl();
    }

    public KubeSchemaFluent.RoleListNested<A> withNewRoleListLike(RoleList item){
            return new RoleListNestedImpl(item);
    }

    public KubeSchemaFluent.RoleListNested<A> editRoleList(){
            return withNewRoleListLike(getRoleList());
    }

    public RootPaths getRootPaths(){
            return this.rootPaths!=null?this.rootPaths.build():null;
    }

    public A withRootPaths(RootPaths rootPaths){
            if (rootPaths!=null){ this.rootPaths= new RootPathsBuilder(rootPaths); _visitables.add(this.rootPaths);} return (A) this;
    }

    public KubeSchemaFluent.RootPathsNested<A> withNewRootPaths(){
            return new RootPathsNestedImpl();
    }

    public KubeSchemaFluent.RootPathsNested<A> withNewRootPathsLike(RootPaths item){
            return new RootPathsNestedImpl(item);
    }

    public KubeSchemaFluent.RootPathsNested<A> editRootPaths(){
            return withNewRootPathsLike(getRootPaths());
    }

    public RouteList getRouteList(){
            return this.routeList!=null?this.routeList.build():null;
    }

    public A withRouteList(RouteList routeList){
            if (routeList!=null){ this.routeList= new RouteListBuilder(routeList); _visitables.add(this.routeList);} return (A) this;
    }

    public KubeSchemaFluent.RouteListNested<A> withNewRouteList(){
            return new RouteListNestedImpl();
    }

    public KubeSchemaFluent.RouteListNested<A> withNewRouteListLike(RouteList item){
            return new RouteListNestedImpl(item);
    }

    public KubeSchemaFluent.RouteListNested<A> editRouteList(){
            return withNewRouteListLike(getRouteList());
    }

    public Scale getScale(){
            return this.scale!=null?this.scale.build():null;
    }

    public A withScale(Scale scale){
            if (scale!=null){ this.scale= new ScaleBuilder(scale); _visitables.add(this.scale);} return (A) this;
    }

    public KubeSchemaFluent.ScaleNested<A> withNewScale(){
            return new ScaleNestedImpl();
    }

    public KubeSchemaFluent.ScaleNested<A> withNewScaleLike(Scale item){
            return new ScaleNestedImpl(item);
    }

    public KubeSchemaFluent.ScaleNested<A> editScale(){
            return withNewScaleLike(getScale());
    }

    public Secret getSecret(){
            return this.secret!=null?this.secret.build():null;
    }

    public A withSecret(Secret secret){
            if (secret!=null){ this.secret= new SecretBuilder(secret); _visitables.add(this.secret);} return (A) this;
    }

    public KubeSchemaFluent.SecretNested<A> withNewSecret(){
            return new SecretNestedImpl();
    }

    public KubeSchemaFluent.SecretNested<A> withNewSecretLike(Secret item){
            return new SecretNestedImpl(item);
    }

    public KubeSchemaFluent.SecretNested<A> editSecret(){
            return withNewSecretLike(getSecret());
    }

    public SecretList getSecretList(){
            return this.secretList!=null?this.secretList.build():null;
    }

    public A withSecretList(SecretList secretList){
            if (secretList!=null){ this.secretList= new SecretListBuilder(secretList); _visitables.add(this.secretList);} return (A) this;
    }

    public KubeSchemaFluent.SecretListNested<A> withNewSecretList(){
            return new SecretListNestedImpl();
    }

    public KubeSchemaFluent.SecretListNested<A> withNewSecretListLike(SecretList item){
            return new SecretListNestedImpl(item);
    }

    public KubeSchemaFluent.SecretListNested<A> editSecretList(){
            return withNewSecretListLike(getSecretList());
    }

    public SecurityContextConstraints getSecurityContextConstraints(){
            return this.securityContextConstraints!=null?this.securityContextConstraints.build():null;
    }

    public A withSecurityContextConstraints(SecurityContextConstraints securityContextConstraints){
            if (securityContextConstraints!=null){ this.securityContextConstraints= new SecurityContextConstraintsBuilder(securityContextConstraints); _visitables.add(this.securityContextConstraints);} return (A) this;
    }

    public KubeSchemaFluent.SecurityContextConstraintsNested<A> withNewSecurityContextConstraints(){
            return new SecurityContextConstraintsNestedImpl();
    }

    public KubeSchemaFluent.SecurityContextConstraintsNested<A> withNewSecurityContextConstraintsLike(SecurityContextConstraints item){
            return new SecurityContextConstraintsNestedImpl(item);
    }

    public KubeSchemaFluent.SecurityContextConstraintsNested<A> editSecurityContextConstraints(){
            return withNewSecurityContextConstraintsLike(getSecurityContextConstraints());
    }

    public SecurityContextConstraintsList getSecurityContextConstraintsList(){
            return this.securityContextConstraintsList!=null?this.securityContextConstraintsList.build():null;
    }

    public A withSecurityContextConstraintsList(SecurityContextConstraintsList securityContextConstraintsList){
            if (securityContextConstraintsList!=null){ this.securityContextConstraintsList= new SecurityContextConstraintsListBuilder(securityContextConstraintsList); _visitables.add(this.securityContextConstraintsList);} return (A) this;
    }

    public KubeSchemaFluent.SecurityContextConstraintsListNested<A> withNewSecurityContextConstraintsList(){
            return new SecurityContextConstraintsListNestedImpl();
    }

    public KubeSchemaFluent.SecurityContextConstraintsListNested<A> withNewSecurityContextConstraintsListLike(SecurityContextConstraintsList item){
            return new SecurityContextConstraintsListNestedImpl(item);
    }

    public KubeSchemaFluent.SecurityContextConstraintsListNested<A> editSecurityContextConstraintsList(){
            return withNewSecurityContextConstraintsListLike(getSecurityContextConstraintsList());
    }

    public ServiceAccount getServiceAccount(){
            return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(ServiceAccount serviceAccount){
            if (serviceAccount!=null){ this.serviceAccount= new ServiceAccountBuilder(serviceAccount); _visitables.add(this.serviceAccount);} return (A) this;
    }

    public KubeSchemaFluent.ServiceAccountNested<A> withNewServiceAccount(){
            return new ServiceAccountNestedImpl();
    }

    public KubeSchemaFluent.ServiceAccountNested<A> withNewServiceAccountLike(ServiceAccount item){
            return new ServiceAccountNestedImpl(item);
    }

    public KubeSchemaFluent.ServiceAccountNested<A> editServiceAccount(){
            return withNewServiceAccountLike(getServiceAccount());
    }

    public ServiceAccountList getServiceAccountList(){
            return this.serviceAccountList!=null?this.serviceAccountList.build():null;
    }

    public A withServiceAccountList(ServiceAccountList serviceAccountList){
            if (serviceAccountList!=null){ this.serviceAccountList= new ServiceAccountListBuilder(serviceAccountList); _visitables.add(this.serviceAccountList);} return (A) this;
    }

    public KubeSchemaFluent.ServiceAccountListNested<A> withNewServiceAccountList(){
            return new ServiceAccountListNestedImpl();
    }

    public KubeSchemaFluent.ServiceAccountListNested<A> withNewServiceAccountListLike(ServiceAccountList item){
            return new ServiceAccountListNestedImpl(item);
    }

    public KubeSchemaFluent.ServiceAccountListNested<A> editServiceAccountList(){
            return withNewServiceAccountListLike(getServiceAccountList());
    }

    public ServiceList getServiceList(){
            return this.serviceList!=null?this.serviceList.build():null;
    }

    public A withServiceList(ServiceList serviceList){
            if (serviceList!=null){ this.serviceList= new ServiceListBuilder(serviceList); _visitables.add(this.serviceList);} return (A) this;
    }

    public KubeSchemaFluent.ServiceListNested<A> withNewServiceList(){
            return new ServiceListNestedImpl();
    }

    public KubeSchemaFluent.ServiceListNested<A> withNewServiceListLike(ServiceList item){
            return new ServiceListNestedImpl(item);
    }

    public KubeSchemaFluent.ServiceListNested<A> editServiceList(){
            return withNewServiceListLike(getServiceList());
    }

    public Status getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(Status status){
            if (status!=null){ this.status= new StatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public KubeSchemaFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public KubeSchemaFluent.StatusNested<A> withNewStatusLike(Status item){
            return new StatusNestedImpl(item);
    }

    public KubeSchemaFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public SubjectAccessReview getSubjectAccessReview(){
            return this.subjectAccessReview!=null?this.subjectAccessReview.build():null;
    }

    public A withSubjectAccessReview(SubjectAccessReview subjectAccessReview){
            if (subjectAccessReview!=null){ this.subjectAccessReview= new SubjectAccessReviewBuilder(subjectAccessReview); _visitables.add(this.subjectAccessReview);} return (A) this;
    }

    public KubeSchemaFluent.SubjectAccessReviewNested<A> withNewSubjectAccessReview(){
            return new SubjectAccessReviewNestedImpl();
    }

    public KubeSchemaFluent.SubjectAccessReviewNested<A> withNewSubjectAccessReviewLike(SubjectAccessReview item){
            return new SubjectAccessReviewNestedImpl(item);
    }

    public KubeSchemaFluent.SubjectAccessReviewNested<A> editSubjectAccessReview(){
            return withNewSubjectAccessReviewLike(getSubjectAccessReview());
    }

    public SubjectAccessReviewResponse getSubjectAccessReviewResponse(){
            return this.subjectAccessReviewResponse!=null?this.subjectAccessReviewResponse.build():null;
    }

    public A withSubjectAccessReviewResponse(SubjectAccessReviewResponse subjectAccessReviewResponse){
            if (subjectAccessReviewResponse!=null){ this.subjectAccessReviewResponse= new SubjectAccessReviewResponseBuilder(subjectAccessReviewResponse); _visitables.add(this.subjectAccessReviewResponse);} return (A) this;
    }

    public KubeSchemaFluent.SubjectAccessReviewResponseNested<A> withNewSubjectAccessReviewResponse(){
            return new SubjectAccessReviewResponseNestedImpl();
    }

    public KubeSchemaFluent.SubjectAccessReviewResponseNested<A> withNewSubjectAccessReviewResponseLike(SubjectAccessReviewResponse item){
            return new SubjectAccessReviewResponseNestedImpl(item);
    }

    public KubeSchemaFluent.SubjectAccessReviewResponseNested<A> editSubjectAccessReviewResponse(){
            return withNewSubjectAccessReviewResponseLike(getSubjectAccessReviewResponse());
    }

    public TagEvent getTagEvent(){
            return this.tagEvent!=null?this.tagEvent.build():null;
    }

    public A withTagEvent(TagEvent tagEvent){
            if (tagEvent!=null){ this.tagEvent= new TagEventBuilder(tagEvent); _visitables.add(this.tagEvent);} return (A) this;
    }

    public KubeSchemaFluent.TagEventNested<A> withNewTagEvent(){
            return new TagEventNestedImpl();
    }

    public KubeSchemaFluent.TagEventNested<A> withNewTagEventLike(TagEvent item){
            return new TagEventNestedImpl(item);
    }

    public KubeSchemaFluent.TagEventNested<A> editTagEvent(){
            return withNewTagEventLike(getTagEvent());
    }

    public A withNewTagEvent(String created,String dockerImageReference,Long generation,String image){
            return (A)withTagEvent(new TagEvent(created, dockerImageReference, generation, image));
    }

    public Template getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(Template template){
            if (template!=null){ this.template= new TemplateBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public KubeSchemaFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public KubeSchemaFluent.TemplateNested<A> withNewTemplateLike(Template item){
            return new TemplateNestedImpl(item);
    }

    public KubeSchemaFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public TemplateList getTemplateList(){
            return this.templateList!=null?this.templateList.build():null;
    }

    public A withTemplateList(TemplateList templateList){
            if (templateList!=null){ this.templateList= new TemplateListBuilder(templateList); _visitables.add(this.templateList);} return (A) this;
    }

    public KubeSchemaFluent.TemplateListNested<A> withNewTemplateList(){
            return new TemplateListNestedImpl();
    }

    public KubeSchemaFluent.TemplateListNested<A> withNewTemplateListLike(TemplateList item){
            return new TemplateListNestedImpl(item);
    }

    public KubeSchemaFluent.TemplateListNested<A> editTemplateList(){
            return withNewTemplateListLike(getTemplateList());
    }

    public ThirdPartyResource getThirdPartyResource(){
            return this.thirdPartyResource!=null?this.thirdPartyResource.build():null;
    }

    public A withThirdPartyResource(ThirdPartyResource thirdPartyResource){
            if (thirdPartyResource!=null){ this.thirdPartyResource= new ThirdPartyResourceBuilder(thirdPartyResource); _visitables.add(this.thirdPartyResource);} return (A) this;
    }

    public KubeSchemaFluent.ThirdPartyResourceNested<A> withNewThirdPartyResource(){
            return new ThirdPartyResourceNestedImpl();
    }

    public KubeSchemaFluent.ThirdPartyResourceNested<A> withNewThirdPartyResourceLike(ThirdPartyResource item){
            return new ThirdPartyResourceNestedImpl(item);
    }

    public KubeSchemaFluent.ThirdPartyResourceNested<A> editThirdPartyResource(){
            return withNewThirdPartyResourceLike(getThirdPartyResource());
    }

    public ThirdPartyResourceList getThirdPartyResourceList(){
            return this.thirdPartyResourceList!=null?this.thirdPartyResourceList.build():null;
    }

    public A withThirdPartyResourceList(ThirdPartyResourceList thirdPartyResourceList){
            if (thirdPartyResourceList!=null){ this.thirdPartyResourceList= new ThirdPartyResourceListBuilder(thirdPartyResourceList); _visitables.add(this.thirdPartyResourceList);} return (A) this;
    }

    public KubeSchemaFluent.ThirdPartyResourceListNested<A> withNewThirdPartyResourceList(){
            return new ThirdPartyResourceListNestedImpl();
    }

    public KubeSchemaFluent.ThirdPartyResourceListNested<A> withNewThirdPartyResourceListLike(ThirdPartyResourceList item){
            return new ThirdPartyResourceListNestedImpl(item);
    }

    public KubeSchemaFluent.ThirdPartyResourceListNested<A> editThirdPartyResourceList(){
            return withNewThirdPartyResourceListLike(getThirdPartyResourceList());
    }

    public User getUser(){
            return this.user!=null?this.user.build():null;
    }

    public A withUser(User user){
            if (user!=null){ this.user= new UserBuilder(user); _visitables.add(this.user);} return (A) this;
    }

    public KubeSchemaFluent.UserNested<A> withNewUser(){
            return new UserNestedImpl();
    }

    public KubeSchemaFluent.UserNested<A> withNewUserLike(User item){
            return new UserNestedImpl(item);
    }

    public KubeSchemaFluent.UserNested<A> editUser(){
            return withNewUserLike(getUser());
    }

    public UserList getUserList(){
            return this.userList!=null?this.userList.build():null;
    }

    public A withUserList(UserList userList){
            if (userList!=null){ this.userList= new UserListBuilder(userList); _visitables.add(this.userList);} return (A) this;
    }

    public KubeSchemaFluent.UserListNested<A> withNewUserList(){
            return new UserListNestedImpl();
    }

    public KubeSchemaFluent.UserListNested<A> withNewUserListLike(UserList item){
            return new UserListNestedImpl(item);
    }

    public KubeSchemaFluent.UserListNested<A> editUserList(){
            return withNewUserListLike(getUserList());
    }

    public WatchEvent getWatchEvent(){
            return this.watchEvent!=null?this.watchEvent.build():null;
    }

    public A withWatchEvent(WatchEvent watchEvent){
            if (watchEvent!=null){ this.watchEvent= new WatchEventBuilder(watchEvent); _visitables.add(this.watchEvent);} return (A) this;
    }

    public KubeSchemaFluent.WatchEventNested<A> withNewWatchEvent(){
            return new WatchEventNestedImpl();
    }

    public KubeSchemaFluent.WatchEventNested<A> withNewWatchEventLike(WatchEvent item){
            return new WatchEventNestedImpl(item);
    }

    public KubeSchemaFluent.WatchEventNested<A> editWatchEvent(){
            return withNewWatchEventLike(getWatchEvent());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubeSchemaFluentImpl that = (KubeSchemaFluentImpl) o;
            if (baseKubernetesList != null ? !baseKubernetesList.equals(that.baseKubernetesList) :that.baseKubernetesList != null) return false;
            if (binding != null ? !binding.equals(that.binding) :that.binding != null) return false;
            if (buildConfigList != null ? !buildConfigList.equals(that.buildConfigList) :that.buildConfigList != null) return false;
            if (buildList != null ? !buildList.equals(that.buildList) :that.buildList != null) return false;
            if (buildRequest != null ? !buildRequest.equals(that.buildRequest) :that.buildRequest != null) return false;
            if (clusterPolicy != null ? !clusterPolicy.equals(that.clusterPolicy) :that.clusterPolicy != null) return false;
            if (clusterPolicyBinding != null ? !clusterPolicyBinding.equals(that.clusterPolicyBinding) :that.clusterPolicyBinding != null) return false;
            if (clusterPolicyBindingList != null ? !clusterPolicyBindingList.equals(that.clusterPolicyBindingList) :that.clusterPolicyBindingList != null) return false;
            if (clusterPolicyList != null ? !clusterPolicyList.equals(that.clusterPolicyList) :that.clusterPolicyList != null) return false;
            if (clusterRoleBinding != null ? !clusterRoleBinding.equals(that.clusterRoleBinding) :that.clusterRoleBinding != null) return false;
            if (clusterRoleBindingList != null ? !clusterRoleBindingList.equals(that.clusterRoleBindingList) :that.clusterRoleBindingList != null) return false;
            if (componentStatusList != null ? !componentStatusList.equals(that.componentStatusList) :that.componentStatusList != null) return false;
            if (config != null ? !config.equals(that.config) :that.config != null) return false;
            if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
            if (configMapList != null ? !configMapList.equals(that.configMapList) :that.configMapList != null) return false;
            if (containerStatus != null ? !containerStatus.equals(that.containerStatus) :that.containerStatus != null) return false;
            if (daemonSet != null ? !daemonSet.equals(that.daemonSet) :that.daemonSet != null) return false;
            if (daemonSetList != null ? !daemonSetList.equals(that.daemonSetList) :that.daemonSetList != null) return false;
            if (deleteOptions != null ? !deleteOptions.equals(that.deleteOptions) :that.deleteOptions != null) return false;
            if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
            if (deploymentConfigList != null ? !deploymentConfigList.equals(that.deploymentConfigList) :that.deploymentConfigList != null) return false;
            if (deploymentList != null ? !deploymentList.equals(that.deploymentList) :that.deploymentList != null) return false;
            if (deploymentRollback != null ? !deploymentRollback.equals(that.deploymentRollback) :that.deploymentRollback != null) return false;
            if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
            if (endpointsList != null ? !endpointsList.equals(that.endpointsList) :that.endpointsList != null) return false;
            if (envVar != null ? !envVar.equals(that.envVar) :that.envVar != null) return false;
            if (eventList != null ? !eventList.equals(that.eventList) :that.eventList != null) return false;
            if (group != null ? !group.equals(that.group) :that.group != null) return false;
            if (groupList != null ? !groupList.equals(that.groupList) :that.groupList != null) return false;
            if (horizontalPodAutoscaler != null ? !horizontalPodAutoscaler.equals(that.horizontalPodAutoscaler) :that.horizontalPodAutoscaler != null) return false;
            if (horizontalPodAutoscalerList != null ? !horizontalPodAutoscalerList.equals(that.horizontalPodAutoscalerList) :that.horizontalPodAutoscalerList != null) return false;
            if (identity != null ? !identity.equals(that.identity) :that.identity != null) return false;
            if (identityList != null ? !identityList.equals(that.identityList) :that.identityList != null) return false;
            if (imageList != null ? !imageList.equals(that.imageList) :that.imageList != null) return false;
            if (imageStreamList != null ? !imageStreamList.equals(that.imageStreamList) :that.imageStreamList != null) return false;
            if (imageStreamTagList != null ? !imageStreamTagList.equals(that.imageStreamTagList) :that.imageStreamTagList != null) return false;
            if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
            if (ingressList != null ? !ingressList.equals(that.ingressList) :that.ingressList != null) return false;
            if (job != null ? !job.equals(that.job) :that.job != null) return false;
            if (jobList != null ? !jobList.equals(that.jobList) :that.jobList != null) return false;
            if (limitRangeList != null ? !limitRangeList.equals(that.limitRangeList) :that.limitRangeList != null) return false;
            if (listMeta != null ? !listMeta.equals(that.listMeta) :that.listMeta != null) return false;
            if (localSubjectAccessReview != null ? !localSubjectAccessReview.equals(that.localSubjectAccessReview) :that.localSubjectAccessReview != null) return false;
            if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
            if (namespaceList != null ? !namespaceList.equals(that.namespaceList) :that.namespaceList != null) return false;
            if (node != null ? !node.equals(that.node) :that.node != null) return false;
            if (nodeList != null ? !nodeList.equals(that.nodeList) :that.nodeList != null) return false;
            if (oAuthAccessToken != null ? !oAuthAccessToken.equals(that.oAuthAccessToken) :that.oAuthAccessToken != null) return false;
            if (oAuthAccessTokenList != null ? !oAuthAccessTokenList.equals(that.oAuthAccessTokenList) :that.oAuthAccessTokenList != null) return false;
            if (oAuthAuthorizeToken != null ? !oAuthAuthorizeToken.equals(that.oAuthAuthorizeToken) :that.oAuthAuthorizeToken != null) return false;
            if (oAuthAuthorizeTokenList != null ? !oAuthAuthorizeTokenList.equals(that.oAuthAuthorizeTokenList) :that.oAuthAuthorizeTokenList != null) return false;
            if (oAuthClient != null ? !oAuthClient.equals(that.oAuthClient) :that.oAuthClient != null) return false;
            if (oAuthClientAuthorization != null ? !oAuthClientAuthorization.equals(that.oAuthClientAuthorization) :that.oAuthClientAuthorization != null) return false;
            if (oAuthClientAuthorizationList != null ? !oAuthClientAuthorizationList.equals(that.oAuthClientAuthorizationList) :that.oAuthClientAuthorizationList != null) return false;
            if (oAuthClientList != null ? !oAuthClientList.equals(that.oAuthClientList) :that.oAuthClientList != null) return false;
            if (objectMeta != null ? !objectMeta.equals(that.objectMeta) :that.objectMeta != null) return false;
            if (patch != null ? !patch.equals(that.patch) :that.patch != null) return false;
            if (persistentVolume != null ? !persistentVolume.equals(that.persistentVolume) :that.persistentVolume != null) return false;
            if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
            if (persistentVolumeClaimList != null ? !persistentVolumeClaimList.equals(that.persistentVolumeClaimList) :that.persistentVolumeClaimList != null) return false;
            if (persistentVolumeList != null ? !persistentVolumeList.equals(that.persistentVolumeList) :that.persistentVolumeList != null) return false;
            if (podList != null ? !podList.equals(that.podList) :that.podList != null) return false;
            if (podTemplateList != null ? !podTemplateList.equals(that.podTemplateList) :that.podTemplateList != null) return false;
            if (policy != null ? !policy.equals(that.policy) :that.policy != null) return false;
            if (policyBinding != null ? !policyBinding.equals(that.policyBinding) :that.policyBinding != null) return false;
            if (policyBindingList != null ? !policyBindingList.equals(that.policyBindingList) :that.policyBindingList != null) return false;
            if (policyList != null ? !policyList.equals(that.policyList) :that.policyList != null) return false;
            if (project != null ? !project.equals(that.project) :that.project != null) return false;
            if (projectList != null ? !projectList.equals(that.projectList) :that.projectList != null) return false;
            if (projectRequest != null ? !projectRequest.equals(that.projectRequest) :that.projectRequest != null) return false;
            if (quantity != null ? !quantity.equals(that.quantity) :that.quantity != null) return false;
            if (replicaSet != null ? !replicaSet.equals(that.replicaSet) :that.replicaSet != null) return false;
            if (replicaSetList != null ? !replicaSetList.equals(that.replicaSetList) :that.replicaSetList != null) return false;
            if (replicationControllerList != null ? !replicationControllerList.equals(that.replicationControllerList) :that.replicationControllerList != null) return false;
            if (resourceQuota != null ? !resourceQuota.equals(that.resourceQuota) :that.resourceQuota != null) return false;
            if (resourceQuotaList != null ? !resourceQuotaList.equals(that.resourceQuotaList) :that.resourceQuotaList != null) return false;
            if (role != null ? !role.equals(that.role) :that.role != null) return false;
            if (roleBinding != null ? !roleBinding.equals(that.roleBinding) :that.roleBinding != null) return false;
            if (roleBindingList != null ? !roleBindingList.equals(that.roleBindingList) :that.roleBindingList != null) return false;
            if (roleList != null ? !roleList.equals(that.roleList) :that.roleList != null) return false;
            if (rootPaths != null ? !rootPaths.equals(that.rootPaths) :that.rootPaths != null) return false;
            if (routeList != null ? !routeList.equals(that.routeList) :that.routeList != null) return false;
            if (scale != null ? !scale.equals(that.scale) :that.scale != null) return false;
            if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
            if (secretList != null ? !secretList.equals(that.secretList) :that.secretList != null) return false;
            if (securityContextConstraints != null ? !securityContextConstraints.equals(that.securityContextConstraints) :that.securityContextConstraints != null) return false;
            if (securityContextConstraintsList != null ? !securityContextConstraintsList.equals(that.securityContextConstraintsList) :that.securityContextConstraintsList != null) return false;
            if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
            if (serviceAccountList != null ? !serviceAccountList.equals(that.serviceAccountList) :that.serviceAccountList != null) return false;
            if (serviceList != null ? !serviceList.equals(that.serviceList) :that.serviceList != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (subjectAccessReview != null ? !subjectAccessReview.equals(that.subjectAccessReview) :that.subjectAccessReview != null) return false;
            if (subjectAccessReviewResponse != null ? !subjectAccessReviewResponse.equals(that.subjectAccessReviewResponse) :that.subjectAccessReviewResponse != null) return false;
            if (tagEvent != null ? !tagEvent.equals(that.tagEvent) :that.tagEvent != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (templateList != null ? !templateList.equals(that.templateList) :that.templateList != null) return false;
            if (thirdPartyResource != null ? !thirdPartyResource.equals(that.thirdPartyResource) :that.thirdPartyResource != null) return false;
            if (thirdPartyResourceList != null ? !thirdPartyResourceList.equals(that.thirdPartyResourceList) :that.thirdPartyResourceList != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            if (userList != null ? !userList.equals(that.userList) :that.userList != null) return false;
            if (watchEvent != null ? !watchEvent.equals(that.watchEvent) :that.watchEvent != null) return false;
            return true;
    }


    public class BaseKubernetesListNestedImpl<N> extends BaseKubernetesListFluentImpl<KubeSchemaFluent.BaseKubernetesListNested<N>> implements KubeSchemaFluent.BaseKubernetesListNested<N>,Nested<N>{

            private final BaseKubernetesListBuilder builder;
    
            BaseKubernetesListNestedImpl(){
                    this.builder = new BaseKubernetesListBuilder(this);
            }
            BaseKubernetesListNestedImpl(BaseKubernetesList item){
                    this.builder = new BaseKubernetesListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withBaseKubernetesList(builder.build());
    }
    public N endBaseKubernetesList(){
            return and();
    }

}
    public class BindingNestedImpl<N> extends BindingFluentImpl<KubeSchemaFluent.BindingNested<N>> implements KubeSchemaFluent.BindingNested<N>,Nested<N>{

            private final BindingBuilder builder;
    
            BindingNestedImpl(){
                    this.builder = new BindingBuilder(this);
            }
            BindingNestedImpl(Binding item){
                    this.builder = new BindingBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withBinding(builder.build());
    }
    public N endBinding(){
            return and();
    }

}
    public class BuildConfigListNestedImpl<N> extends BuildConfigListFluentImpl<KubeSchemaFluent.BuildConfigListNested<N>> implements KubeSchemaFluent.BuildConfigListNested<N>,Nested<N>{

            private final BuildConfigListBuilder builder;
    
            BuildConfigListNestedImpl(){
                    this.builder = new BuildConfigListBuilder(this);
            }
            BuildConfigListNestedImpl(BuildConfigList item){
                    this.builder = new BuildConfigListBuilder(this, item);
            }
    
    public N endBuildConfigList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withBuildConfigList(builder.build());
    }

}
    public class BuildListNestedImpl<N> extends BuildListFluentImpl<KubeSchemaFluent.BuildListNested<N>> implements KubeSchemaFluent.BuildListNested<N>,Nested<N>{

            private final BuildListBuilder builder;
    
            BuildListNestedImpl(){
                    this.builder = new BuildListBuilder(this);
            }
            BuildListNestedImpl(BuildList item){
                    this.builder = new BuildListBuilder(this, item);
            }
    
    public N endBuildList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withBuildList(builder.build());
    }

}
    public class BuildRequestNestedImpl<N> extends BuildRequestFluentImpl<KubeSchemaFluent.BuildRequestNested<N>> implements KubeSchemaFluent.BuildRequestNested<N>,Nested<N>{

            private final BuildRequestBuilder builder;
    
            BuildRequestNestedImpl(){
                    this.builder = new BuildRequestBuilder(this);
            }
            BuildRequestNestedImpl(BuildRequest item){
                    this.builder = new BuildRequestBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withBuildRequest(builder.build());
    }
    public N endBuildRequest(){
            return and();
    }

}
    public class ClusterPolicyNestedImpl<N> extends ClusterPolicyFluentImpl<KubeSchemaFluent.ClusterPolicyNested<N>> implements KubeSchemaFluent.ClusterPolicyNested<N>,Nested<N>{

            private final ClusterPolicyBuilder builder;
    
            ClusterPolicyNestedImpl(){
                    this.builder = new ClusterPolicyBuilder(this);
            }
            ClusterPolicyNestedImpl(ClusterPolicy item){
                    this.builder = new ClusterPolicyBuilder(this, item);
            }
    
    public N endClusterPolicy(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withClusterPolicy(builder.build());
    }

}
    public class ClusterPolicyBindingNestedImpl<N> extends ClusterPolicyBindingFluentImpl<KubeSchemaFluent.ClusterPolicyBindingNested<N>> implements KubeSchemaFluent.ClusterPolicyBindingNested<N>,Nested<N>{

            private final ClusterPolicyBindingBuilder builder;
    
            ClusterPolicyBindingNestedImpl(){
                    this.builder = new ClusterPolicyBindingBuilder(this);
            }
            ClusterPolicyBindingNestedImpl(ClusterPolicyBinding item){
                    this.builder = new ClusterPolicyBindingBuilder(this, item);
            }
    
    public N endClusterPolicyBinding(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withClusterPolicyBinding(builder.build());
    }

}
    public class ClusterPolicyBindingListNestedImpl<N> extends ClusterPolicyBindingListFluentImpl<KubeSchemaFluent.ClusterPolicyBindingListNested<N>> implements KubeSchemaFluent.ClusterPolicyBindingListNested<N>,Nested<N>{

            private final ClusterPolicyBindingListBuilder builder;
    
            ClusterPolicyBindingListNestedImpl(){
                    this.builder = new ClusterPolicyBindingListBuilder(this);
            }
            ClusterPolicyBindingListNestedImpl(ClusterPolicyBindingList item){
                    this.builder = new ClusterPolicyBindingListBuilder(this, item);
            }
    
    public N endClusterPolicyBindingList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withClusterPolicyBindingList(builder.build());
    }

}
    public class ClusterPolicyListNestedImpl<N> extends ClusterPolicyListFluentImpl<KubeSchemaFluent.ClusterPolicyListNested<N>> implements KubeSchemaFluent.ClusterPolicyListNested<N>,Nested<N>{

            private final ClusterPolicyListBuilder builder;
    
            ClusterPolicyListNestedImpl(){
                    this.builder = new ClusterPolicyListBuilder(this);
            }
            ClusterPolicyListNestedImpl(ClusterPolicyList item){
                    this.builder = new ClusterPolicyListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withClusterPolicyList(builder.build());
    }
    public N endClusterPolicyList(){
            return and();
    }

}
    public class ClusterRoleBindingNestedImpl<N> extends ClusterRoleBindingFluentImpl<KubeSchemaFluent.ClusterRoleBindingNested<N>> implements KubeSchemaFluent.ClusterRoleBindingNested<N>,Nested<N>{

            private final ClusterRoleBindingBuilder builder;
    
            ClusterRoleBindingNestedImpl(){
                    this.builder = new ClusterRoleBindingBuilder(this);
            }
            ClusterRoleBindingNestedImpl(ClusterRoleBinding item){
                    this.builder = new ClusterRoleBindingBuilder(this, item);
            }
    
    public N endClusterRoleBinding(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withClusterRoleBinding(builder.build());
    }

}
    public class ClusterRoleBindingListNestedImpl<N> extends ClusterRoleBindingListFluentImpl<KubeSchemaFluent.ClusterRoleBindingListNested<N>> implements KubeSchemaFluent.ClusterRoleBindingListNested<N>,Nested<N>{

            private final ClusterRoleBindingListBuilder builder;
    
            ClusterRoleBindingListNestedImpl(){
                    this.builder = new ClusterRoleBindingListBuilder(this);
            }
            ClusterRoleBindingListNestedImpl(ClusterRoleBindingList item){
                    this.builder = new ClusterRoleBindingListBuilder(this, item);
            }
    
    public N endClusterRoleBindingList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withClusterRoleBindingList(builder.build());
    }

}
    public class ComponentStatusListNestedImpl<N> extends ComponentStatusListFluentImpl<KubeSchemaFluent.ComponentStatusListNested<N>> implements KubeSchemaFluent.ComponentStatusListNested<N>,Nested<N>{

            private final ComponentStatusListBuilder builder;
    
            ComponentStatusListNestedImpl(){
                    this.builder = new ComponentStatusListBuilder(this);
            }
            ComponentStatusListNestedImpl(ComponentStatusList item){
                    this.builder = new ComponentStatusListBuilder(this, item);
            }
    
    public N endComponentStatusList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withComponentStatusList(builder.build());
    }

}
    public class ConfigNestedImpl<N> extends ConfigFluentImpl<KubeSchemaFluent.ConfigNested<N>> implements KubeSchemaFluent.ConfigNested<N>,Nested<N>{

            private final ConfigBuilder builder;
    
            ConfigNestedImpl(){
                    this.builder = new ConfigBuilder(this);
            }
            ConfigNestedImpl(Config item){
                    this.builder = new ConfigBuilder(this, item);
            }
    
    public N endConfig(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withConfig(builder.build());
    }

}
    public class ConfigMapNestedImpl<N> extends ConfigMapFluentImpl<KubeSchemaFluent.ConfigMapNested<N>> implements KubeSchemaFluent.ConfigMapNested<N>,Nested<N>{

            private final ConfigMapBuilder builder;
    
            ConfigMapNestedImpl(){
                    this.builder = new ConfigMapBuilder(this);
            }
            ConfigMapNestedImpl(ConfigMap item){
                    this.builder = new ConfigMapBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withConfigMap(builder.build());
    }
    public N endConfigMap(){
            return and();
    }

}
    public class ConfigMapListNestedImpl<N> extends ConfigMapListFluentImpl<KubeSchemaFluent.ConfigMapListNested<N>> implements KubeSchemaFluent.ConfigMapListNested<N>,Nested<N>{

            private final ConfigMapListBuilder builder;
    
            ConfigMapListNestedImpl(){
                    this.builder = new ConfigMapListBuilder(this);
            }
            ConfigMapListNestedImpl(ConfigMapList item){
                    this.builder = new ConfigMapListBuilder(this, item);
            }
    
    public N endConfigMapList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withConfigMapList(builder.build());
    }

}
    public class ContainerStatusNestedImpl<N> extends ContainerStatusFluentImpl<KubeSchemaFluent.ContainerStatusNested<N>> implements KubeSchemaFluent.ContainerStatusNested<N>,Nested<N>{

            private final ContainerStatusBuilder builder;
    
            ContainerStatusNestedImpl(ContainerStatus item){
                    this.builder = new ContainerStatusBuilder(this, item);
            }
            ContainerStatusNestedImpl(){
                    this.builder = new ContainerStatusBuilder(this);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withContainerStatus(builder.build());
    }
    public N endContainerStatus(){
            return and();
    }

}
    public class DaemonSetNestedImpl<N> extends DaemonSetFluentImpl<KubeSchemaFluent.DaemonSetNested<N>> implements KubeSchemaFluent.DaemonSetNested<N>,Nested<N>{

            private final DaemonSetBuilder builder;
    
            DaemonSetNestedImpl(){
                    this.builder = new DaemonSetBuilder(this);
            }
            DaemonSetNestedImpl(DaemonSet item){
                    this.builder = new DaemonSetBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withDaemonSet(builder.build());
    }
    public N endDaemonSet(){
            return and();
    }

}
    public class DaemonSetListNestedImpl<N> extends DaemonSetListFluentImpl<KubeSchemaFluent.DaemonSetListNested<N>> implements KubeSchemaFluent.DaemonSetListNested<N>,Nested<N>{

            private final DaemonSetListBuilder builder;
    
            DaemonSetListNestedImpl(){
                    this.builder = new DaemonSetListBuilder(this);
            }
            DaemonSetListNestedImpl(DaemonSetList item){
                    this.builder = new DaemonSetListBuilder(this, item);
            }
    
    public N endDaemonSetList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withDaemonSetList(builder.build());
    }

}
    public class DeleteOptionsNestedImpl<N> extends DeleteOptionsFluentImpl<KubeSchemaFluent.DeleteOptionsNested<N>> implements KubeSchemaFluent.DeleteOptionsNested<N>,Nested<N>{

            private final DeleteOptionsBuilder builder;
    
            DeleteOptionsNestedImpl(){
                    this.builder = new DeleteOptionsBuilder(this);
            }
            DeleteOptionsNestedImpl(DeleteOptions item){
                    this.builder = new DeleteOptionsBuilder(this, item);
            }
    
    public N endDeleteOptions(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withDeleteOptions(builder.build());
    }

}
    public class DeploymentNestedImpl<N> extends DeploymentFluentImpl<KubeSchemaFluent.DeploymentNested<N>> implements KubeSchemaFluent.DeploymentNested<N>,Nested<N>{

            private final DeploymentBuilder builder;
    
            DeploymentNestedImpl(){
                    this.builder = new DeploymentBuilder(this);
            }
            DeploymentNestedImpl(Deployment item){
                    this.builder = new DeploymentBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withDeployment(builder.build());
    }
    public N endDeployment(){
            return and();
    }

}
    public class DeploymentConfigListNestedImpl<N> extends DeploymentConfigListFluentImpl<KubeSchemaFluent.DeploymentConfigListNested<N>> implements KubeSchemaFluent.DeploymentConfigListNested<N>,Nested<N>{

            private final DeploymentConfigListBuilder builder;
    
            DeploymentConfigListNestedImpl(){
                    this.builder = new DeploymentConfigListBuilder(this);
            }
            DeploymentConfigListNestedImpl(DeploymentConfigList item){
                    this.builder = new DeploymentConfigListBuilder(this, item);
            }
    
    public N endDeploymentConfigList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withDeploymentConfigList(builder.build());
    }

}
    public class DeploymentListNestedImpl<N> extends DeploymentListFluentImpl<KubeSchemaFluent.DeploymentListNested<N>> implements KubeSchemaFluent.DeploymentListNested<N>,Nested<N>{

            private final DeploymentListBuilder builder;
    
            DeploymentListNestedImpl(){
                    this.builder = new DeploymentListBuilder(this);
            }
            DeploymentListNestedImpl(DeploymentList item){
                    this.builder = new DeploymentListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withDeploymentList(builder.build());
    }
    public N endDeploymentList(){
            return and();
    }

}
    public class DeploymentRollbackNestedImpl<N> extends DeploymentRollbackFluentImpl<KubeSchemaFluent.DeploymentRollbackNested<N>> implements KubeSchemaFluent.DeploymentRollbackNested<N>,Nested<N>{

            private final DeploymentRollbackBuilder builder;
    
            DeploymentRollbackNestedImpl(){
                    this.builder = new DeploymentRollbackBuilder(this);
            }
            DeploymentRollbackNestedImpl(DeploymentRollback item){
                    this.builder = new DeploymentRollbackBuilder(this, item);
            }
    
    public N endDeploymentRollback(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withDeploymentRollback(builder.build());
    }

}
    public class EndpointsNestedImpl<N> extends EndpointsFluentImpl<KubeSchemaFluent.EndpointsNested<N>> implements KubeSchemaFluent.EndpointsNested<N>,Nested<N>{

            private final EndpointsBuilder builder;
    
            EndpointsNestedImpl(){
                    this.builder = new EndpointsBuilder(this);
            }
            EndpointsNestedImpl(Endpoints item){
                    this.builder = new EndpointsBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withEndpoints(builder.build());
    }
    public N endEndpoints(){
            return and();
    }

}
    public class EndpointsListNestedImpl<N> extends EndpointsListFluentImpl<KubeSchemaFluent.EndpointsListNested<N>> implements KubeSchemaFluent.EndpointsListNested<N>,Nested<N>{

            private final EndpointsListBuilder builder;
    
            EndpointsListNestedImpl(){
                    this.builder = new EndpointsListBuilder(this);
            }
            EndpointsListNestedImpl(EndpointsList item){
                    this.builder = new EndpointsListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withEndpointsList(builder.build());
    }
    public N endEndpointsList(){
            return and();
    }

}
    public class EnvVarNestedImpl<N> extends EnvVarFluentImpl<KubeSchemaFluent.EnvVarNested<N>> implements KubeSchemaFluent.EnvVarNested<N>,Nested<N>{

            private final EnvVarBuilder builder;
    
            EnvVarNestedImpl(EnvVar item){
                    this.builder = new EnvVarBuilder(this, item);
            }
            EnvVarNestedImpl(){
                    this.builder = new EnvVarBuilder(this);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withEnvVar(builder.build());
    }
    public N endEnvVar(){
            return and();
    }

}
    public class EventListNestedImpl<N> extends EventListFluentImpl<KubeSchemaFluent.EventListNested<N>> implements KubeSchemaFluent.EventListNested<N>,Nested<N>{

            private final EventListBuilder builder;
    
            EventListNestedImpl(){
                    this.builder = new EventListBuilder(this);
            }
            EventListNestedImpl(EventList item){
                    this.builder = new EventListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withEventList(builder.build());
    }
    public N endEventList(){
            return and();
    }

}
    public class GroupNestedImpl<N> extends GroupFluentImpl<KubeSchemaFluent.GroupNested<N>> implements KubeSchemaFluent.GroupNested<N>,Nested<N>{

            private final GroupBuilder builder;
    
            GroupNestedImpl(){
                    this.builder = new GroupBuilder(this);
            }
            GroupNestedImpl(Group item){
                    this.builder = new GroupBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withGroup(builder.build());
    }
    public N endGroup(){
            return and();
    }

}
    public class GroupListNestedImpl<N> extends GroupListFluentImpl<KubeSchemaFluent.GroupListNested<N>> implements KubeSchemaFluent.GroupListNested<N>,Nested<N>{

            private final GroupListBuilder builder;
    
            GroupListNestedImpl(){
                    this.builder = new GroupListBuilder(this);
            }
            GroupListNestedImpl(GroupList item){
                    this.builder = new GroupListBuilder(this, item);
            }
    
    public N endGroupList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withGroupList(builder.build());
    }

}
    public class HorizontalPodAutoscalerNestedImpl<N> extends HorizontalPodAutoscalerFluentImpl<KubeSchemaFluent.HorizontalPodAutoscalerNested<N>> implements KubeSchemaFluent.HorizontalPodAutoscalerNested<N>,Nested<N>{

            private final HorizontalPodAutoscalerBuilder builder;
    
            HorizontalPodAutoscalerNestedImpl(){
                    this.builder = new HorizontalPodAutoscalerBuilder(this);
            }
            HorizontalPodAutoscalerNestedImpl(HorizontalPodAutoscaler item){
                    this.builder = new HorizontalPodAutoscalerBuilder(this, item);
            }
    
    public N endHorizontalPodAutoscaler(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withHorizontalPodAutoscaler(builder.build());
    }

}
    public class HorizontalPodAutoscalerListNestedImpl<N> extends HorizontalPodAutoscalerListFluentImpl<KubeSchemaFluent.HorizontalPodAutoscalerListNested<N>> implements KubeSchemaFluent.HorizontalPodAutoscalerListNested<N>,Nested<N>{

            private final HorizontalPodAutoscalerListBuilder builder;
    
            HorizontalPodAutoscalerListNestedImpl(){
                    this.builder = new HorizontalPodAutoscalerListBuilder(this);
            }
            HorizontalPodAutoscalerListNestedImpl(HorizontalPodAutoscalerList item){
                    this.builder = new HorizontalPodAutoscalerListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withHorizontalPodAutoscalerList(builder.build());
    }
    public N endHorizontalPodAutoscalerList(){
            return and();
    }

}
    public class IdentityNestedImpl<N> extends IdentityFluentImpl<KubeSchemaFluent.IdentityNested<N>> implements KubeSchemaFluent.IdentityNested<N>,Nested<N>{

            private final IdentityBuilder builder;
    
            IdentityNestedImpl(){
                    this.builder = new IdentityBuilder(this);
            }
            IdentityNestedImpl(Identity item){
                    this.builder = new IdentityBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withIdentity(builder.build());
    }
    public N endIdentity(){
            return and();
    }

}
    public class IdentityListNestedImpl<N> extends IdentityListFluentImpl<KubeSchemaFluent.IdentityListNested<N>> implements KubeSchemaFluent.IdentityListNested<N>,Nested<N>{

            private final IdentityListBuilder builder;
    
            IdentityListNestedImpl(){
                    this.builder = new IdentityListBuilder(this);
            }
            IdentityListNestedImpl(IdentityList item){
                    this.builder = new IdentityListBuilder(this, item);
            }
    
    public N endIdentityList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withIdentityList(builder.build());
    }

}
    public class ImageListNestedImpl<N> extends ImageListFluentImpl<KubeSchemaFluent.ImageListNested<N>> implements KubeSchemaFluent.ImageListNested<N>,Nested<N>{

            private final ImageListBuilder builder;
    
            ImageListNestedImpl(){
                    this.builder = new ImageListBuilder(this);
            }
            ImageListNestedImpl(ImageList item){
                    this.builder = new ImageListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withImageList(builder.build());
    }
    public N endImageList(){
            return and();
    }

}
    public class ImageStreamListNestedImpl<N> extends ImageStreamListFluentImpl<KubeSchemaFluent.ImageStreamListNested<N>> implements KubeSchemaFluent.ImageStreamListNested<N>,Nested<N>{

            private final ImageStreamListBuilder builder;
    
            ImageStreamListNestedImpl(){
                    this.builder = new ImageStreamListBuilder(this);
            }
            ImageStreamListNestedImpl(ImageStreamList item){
                    this.builder = new ImageStreamListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withImageStreamList(builder.build());
    }
    public N endImageStreamList(){
            return and();
    }

}
    public class ImageStreamTagListNestedImpl<N> extends ImageStreamTagListFluentImpl<KubeSchemaFluent.ImageStreamTagListNested<N>> implements KubeSchemaFluent.ImageStreamTagListNested<N>,Nested<N>{

            private final ImageStreamTagListBuilder builder;
    
            ImageStreamTagListNestedImpl(){
                    this.builder = new ImageStreamTagListBuilder(this);
            }
            ImageStreamTagListNestedImpl(ImageStreamTagList item){
                    this.builder = new ImageStreamTagListBuilder(this, item);
            }
    
    public N endImageStreamTagList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withImageStreamTagList(builder.build());
    }

}
    public class IngressNestedImpl<N> extends IngressFluentImpl<KubeSchemaFluent.IngressNested<N>> implements KubeSchemaFluent.IngressNested<N>,Nested<N>{

            private final IngressBuilder builder;
    
            IngressNestedImpl(){
                    this.builder = new IngressBuilder(this);
            }
            IngressNestedImpl(Ingress item){
                    this.builder = new IngressBuilder(this, item);
            }
    
    public N endIngress(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withIngress(builder.build());
    }

}
    public class IngressListNestedImpl<N> extends IngressListFluentImpl<KubeSchemaFluent.IngressListNested<N>> implements KubeSchemaFluent.IngressListNested<N>,Nested<N>{

            private final IngressListBuilder builder;
    
            IngressListNestedImpl(){
                    this.builder = new IngressListBuilder(this);
            }
            IngressListNestedImpl(IngressList item){
                    this.builder = new IngressListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withIngressList(builder.build());
    }
    public N endIngressList(){
            return and();
    }

}
    public class JobNestedImpl<N> extends JobFluentImpl<KubeSchemaFluent.JobNested<N>> implements KubeSchemaFluent.JobNested<N>,Nested<N>{

            private final JobBuilder builder;
    
            JobNestedImpl(){
                    this.builder = new JobBuilder(this);
            }
            JobNestedImpl(Job item){
                    this.builder = new JobBuilder(this, item);
            }
    
    public N endJob(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withJob(builder.build());
    }

}
    public class JobListNestedImpl<N> extends JobListFluentImpl<KubeSchemaFluent.JobListNested<N>> implements KubeSchemaFluent.JobListNested<N>,Nested<N>{

            private final JobListBuilder builder;
    
            JobListNestedImpl(){
                    this.builder = new JobListBuilder(this);
            }
            JobListNestedImpl(JobList item){
                    this.builder = new JobListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withJobList(builder.build());
    }
    public N endJobList(){
            return and();
    }

}
    public class LimitRangeListNestedImpl<N> extends LimitRangeListFluentImpl<KubeSchemaFluent.LimitRangeListNested<N>> implements KubeSchemaFluent.LimitRangeListNested<N>,Nested<N>{

            private final LimitRangeListBuilder builder;
    
            LimitRangeListNestedImpl(){
                    this.builder = new LimitRangeListBuilder(this);
            }
            LimitRangeListNestedImpl(LimitRangeList item){
                    this.builder = new LimitRangeListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withLimitRangeList(builder.build());
    }
    public N endLimitRangeList(){
            return and();
    }

}
    public class ListMetaNestedImpl<N> extends ListMetaFluentImpl<KubeSchemaFluent.ListMetaNested<N>> implements KubeSchemaFluent.ListMetaNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            ListMetaNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            ListMetaNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N endListMeta(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withListMeta(builder.build());
    }

}
    public class LocalSubjectAccessReviewNestedImpl<N> extends LocalSubjectAccessReviewFluentImpl<KubeSchemaFluent.LocalSubjectAccessReviewNested<N>> implements KubeSchemaFluent.LocalSubjectAccessReviewNested<N>,Nested<N>{

            private final LocalSubjectAccessReviewBuilder builder;
    
            LocalSubjectAccessReviewNestedImpl(LocalSubjectAccessReview item){
                    this.builder = new LocalSubjectAccessReviewBuilder(this, item);
            }
            LocalSubjectAccessReviewNestedImpl(){
                    this.builder = new LocalSubjectAccessReviewBuilder(this);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withLocalSubjectAccessReview(builder.build());
    }
    public N endLocalSubjectAccessReview(){
            return and();
    }

}
    public class NamespaceNestedImpl<N> extends NamespaceFluentImpl<KubeSchemaFluent.NamespaceNested<N>> implements KubeSchemaFluent.NamespaceNested<N>,Nested<N>{

            private final NamespaceBuilder builder;
    
            NamespaceNestedImpl(){
                    this.builder = new NamespaceBuilder(this);
            }
            NamespaceNestedImpl(Namespace item){
                    this.builder = new NamespaceBuilder(this, item);
            }
    
    public N endNamespace(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withNamespace(builder.build());
    }

}
    public class NamespaceListNestedImpl<N> extends NamespaceListFluentImpl<KubeSchemaFluent.NamespaceListNested<N>> implements KubeSchemaFluent.NamespaceListNested<N>,Nested<N>{

            private final NamespaceListBuilder builder;
    
            NamespaceListNestedImpl(){
                    this.builder = new NamespaceListBuilder(this);
            }
            NamespaceListNestedImpl(NamespaceList item){
                    this.builder = new NamespaceListBuilder(this, item);
            }
    
    public N endNamespaceList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withNamespaceList(builder.build());
    }

}
    public class NodeNestedImpl<N> extends NodeFluentImpl<KubeSchemaFluent.NodeNested<N>> implements KubeSchemaFluent.NodeNested<N>,Nested<N>{

            private final NodeBuilder builder;
    
            NodeNestedImpl(){
                    this.builder = new NodeBuilder(this);
            }
            NodeNestedImpl(Node item){
                    this.builder = new NodeBuilder(this, item);
            }
    
    public N endNode(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withNode(builder.build());
    }

}
    public class NodeListNestedImpl<N> extends NodeListFluentImpl<KubeSchemaFluent.NodeListNested<N>> implements KubeSchemaFluent.NodeListNested<N>,Nested<N>{

            private final NodeListBuilder builder;
    
            NodeListNestedImpl(){
                    this.builder = new NodeListBuilder(this);
            }
            NodeListNestedImpl(NodeList item){
                    this.builder = new NodeListBuilder(this, item);
            }
    
    public N endNodeList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withNodeList(builder.build());
    }

}
    public class OAuthAccessTokenNestedImpl<N> extends OAuthAccessTokenFluentImpl<KubeSchemaFluent.OAuthAccessTokenNested<N>> implements KubeSchemaFluent.OAuthAccessTokenNested<N>,Nested<N>{

            private final OAuthAccessTokenBuilder builder;
    
            OAuthAccessTokenNestedImpl(){
                    this.builder = new OAuthAccessTokenBuilder(this);
            }
            OAuthAccessTokenNestedImpl(OAuthAccessToken item){
                    this.builder = new OAuthAccessTokenBuilder(this, item);
            }
    
    public N endOAuthAccessToken(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withOAuthAccessToken(builder.build());
    }

}
    public class OAuthAccessTokenListNestedImpl<N> extends OAuthAccessTokenListFluentImpl<KubeSchemaFluent.OAuthAccessTokenListNested<N>> implements KubeSchemaFluent.OAuthAccessTokenListNested<N>,Nested<N>{

            private final OAuthAccessTokenListBuilder builder;
    
            OAuthAccessTokenListNestedImpl(){
                    this.builder = new OAuthAccessTokenListBuilder(this);
            }
            OAuthAccessTokenListNestedImpl(OAuthAccessTokenList item){
                    this.builder = new OAuthAccessTokenListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withOAuthAccessTokenList(builder.build());
    }
    public N endOAuthAccessTokenList(){
            return and();
    }

}
    public class OAuthAuthorizeTokenNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<KubeSchemaFluent.OAuthAuthorizeTokenNested<N>> implements KubeSchemaFluent.OAuthAuthorizeTokenNested<N>,Nested<N>{

            private final OAuthAuthorizeTokenBuilder builder;
    
            OAuthAuthorizeTokenNestedImpl(){
                    this.builder = new OAuthAuthorizeTokenBuilder(this);
            }
            OAuthAuthorizeTokenNestedImpl(OAuthAuthorizeToken item){
                    this.builder = new OAuthAuthorizeTokenBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withOAuthAuthorizeToken(builder.build());
    }
    public N endOAuthAuthorizeToken(){
            return and();
    }

}
    public class OAuthAuthorizeTokenListNestedImpl<N> extends OAuthAuthorizeTokenListFluentImpl<KubeSchemaFluent.OAuthAuthorizeTokenListNested<N>> implements KubeSchemaFluent.OAuthAuthorizeTokenListNested<N>,Nested<N>{

            private final OAuthAuthorizeTokenListBuilder builder;
    
            OAuthAuthorizeTokenListNestedImpl(){
                    this.builder = new OAuthAuthorizeTokenListBuilder(this);
            }
            OAuthAuthorizeTokenListNestedImpl(OAuthAuthorizeTokenList item){
                    this.builder = new OAuthAuthorizeTokenListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withOAuthAuthorizeTokenList(builder.build());
    }
    public N endOAuthAuthorizeTokenList(){
            return and();
    }

}
    public class OAuthClientNestedImpl<N> extends OAuthClientFluentImpl<KubeSchemaFluent.OAuthClientNested<N>> implements KubeSchemaFluent.OAuthClientNested<N>,Nested<N>{

            private final OAuthClientBuilder builder;
    
            OAuthClientNestedImpl(){
                    this.builder = new OAuthClientBuilder(this);
            }
            OAuthClientNestedImpl(OAuthClient item){
                    this.builder = new OAuthClientBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withOAuthClient(builder.build());
    }
    public N endOAuthClient(){
            return and();
    }

}
    public class OAuthClientAuthorizationNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<KubeSchemaFluent.OAuthClientAuthorizationNested<N>> implements KubeSchemaFluent.OAuthClientAuthorizationNested<N>,Nested<N>{

            private final OAuthClientAuthorizationBuilder builder;
    
            OAuthClientAuthorizationNestedImpl(){
                    this.builder = new OAuthClientAuthorizationBuilder(this);
            }
            OAuthClientAuthorizationNestedImpl(OAuthClientAuthorization item){
                    this.builder = new OAuthClientAuthorizationBuilder(this, item);
            }
    
    public N endOAuthClientAuthorization(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withOAuthClientAuthorization(builder.build());
    }

}
    public class OAuthClientAuthorizationListNestedImpl<N> extends OAuthClientAuthorizationListFluentImpl<KubeSchemaFluent.OAuthClientAuthorizationListNested<N>> implements KubeSchemaFluent.OAuthClientAuthorizationListNested<N>,Nested<N>{

            private final OAuthClientAuthorizationListBuilder builder;
    
            OAuthClientAuthorizationListNestedImpl(){
                    this.builder = new OAuthClientAuthorizationListBuilder(this);
            }
            OAuthClientAuthorizationListNestedImpl(OAuthClientAuthorizationList item){
                    this.builder = new OAuthClientAuthorizationListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withOAuthClientAuthorizationList(builder.build());
    }
    public N endOAuthClientAuthorizationList(){
            return and();
    }

}
    public class OAuthClientListNestedImpl<N> extends OAuthClientListFluentImpl<KubeSchemaFluent.OAuthClientListNested<N>> implements KubeSchemaFluent.OAuthClientListNested<N>,Nested<N>{

            private final OAuthClientListBuilder builder;
    
            OAuthClientListNestedImpl(){
                    this.builder = new OAuthClientListBuilder(this);
            }
            OAuthClientListNestedImpl(OAuthClientList item){
                    this.builder = new OAuthClientListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withOAuthClientList(builder.build());
    }
    public N endOAuthClientList(){
            return and();
    }

}
    public class ObjectMetaNestedImpl<N> extends ObjectMetaFluentImpl<KubeSchemaFluent.ObjectMetaNested<N>> implements KubeSchemaFluent.ObjectMetaNested<N>,Nested<N>{

            private final ObjectMetaBuilder builder;
    
            ObjectMetaNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            ObjectMetaNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N endObjectMeta(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withObjectMeta(builder.build());
    }

}
    public class PatchNestedImpl<N> extends PatchFluentImpl<KubeSchemaFluent.PatchNested<N>> implements KubeSchemaFluent.PatchNested<N>,Nested<N>{

            private final PatchBuilder builder;
    
            PatchNestedImpl(Patch item){
                    this.builder = new PatchBuilder(this, item);
            }
            PatchNestedImpl(){
                    this.builder = new PatchBuilder(this);
            }
    
    public N endPatch(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPatch(builder.build());
    }

}
    public class PersistentVolumeNestedImpl<N> extends PersistentVolumeFluentImpl<KubeSchemaFluent.PersistentVolumeNested<N>> implements KubeSchemaFluent.PersistentVolumeNested<N>,Nested<N>{

            private final PersistentVolumeBuilder builder;
    
            PersistentVolumeNestedImpl(){
                    this.builder = new PersistentVolumeBuilder(this);
            }
            PersistentVolumeNestedImpl(PersistentVolume item){
                    this.builder = new PersistentVolumeBuilder(this, item);
            }
    
    public N endPersistentVolume(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPersistentVolume(builder.build());
    }

}
    public class PersistentVolumeClaimNestedImpl<N> extends PersistentVolumeClaimFluentImpl<KubeSchemaFluent.PersistentVolumeClaimNested<N>> implements KubeSchemaFluent.PersistentVolumeClaimNested<N>,Nested<N>{

            private final PersistentVolumeClaimBuilder builder;
    
            PersistentVolumeClaimNestedImpl(){
                    this.builder = new PersistentVolumeClaimBuilder(this);
            }
            PersistentVolumeClaimNestedImpl(PersistentVolumeClaim item){
                    this.builder = new PersistentVolumeClaimBuilder(this, item);
            }
    
    public N endPersistentVolumeClaim(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPersistentVolumeClaim(builder.build());
    }

}
    public class PersistentVolumeClaimListNestedImpl<N> extends PersistentVolumeClaimListFluentImpl<KubeSchemaFluent.PersistentVolumeClaimListNested<N>> implements KubeSchemaFluent.PersistentVolumeClaimListNested<N>,Nested<N>{

            private final PersistentVolumeClaimListBuilder builder;
    
            PersistentVolumeClaimListNestedImpl(){
                    this.builder = new PersistentVolumeClaimListBuilder(this);
            }
            PersistentVolumeClaimListNestedImpl(PersistentVolumeClaimList item){
                    this.builder = new PersistentVolumeClaimListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPersistentVolumeClaimList(builder.build());
    }
    public N endPersistentVolumeClaimList(){
            return and();
    }

}
    public class PersistentVolumeListNestedImpl<N> extends PersistentVolumeListFluentImpl<KubeSchemaFluent.PersistentVolumeListNested<N>> implements KubeSchemaFluent.PersistentVolumeListNested<N>,Nested<N>{

            private final PersistentVolumeListBuilder builder;
    
            PersistentVolumeListNestedImpl(){
                    this.builder = new PersistentVolumeListBuilder(this);
            }
            PersistentVolumeListNestedImpl(PersistentVolumeList item){
                    this.builder = new PersistentVolumeListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPersistentVolumeList(builder.build());
    }
    public N endPersistentVolumeList(){
            return and();
    }

}
    public class PodListNestedImpl<N> extends PodListFluentImpl<KubeSchemaFluent.PodListNested<N>> implements KubeSchemaFluent.PodListNested<N>,Nested<N>{

            private final PodListBuilder builder;
    
            PodListNestedImpl(PodList item){
                    this.builder = new PodListBuilder(this, item);
            }
            PodListNestedImpl(){
                    this.builder = new PodListBuilder(this);
            }
    
    public N endPodList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPodList(builder.build());
    }

}
    public class PodTemplateListNestedImpl<N> extends PodTemplateListFluentImpl<KubeSchemaFluent.PodTemplateListNested<N>> implements KubeSchemaFluent.PodTemplateListNested<N>,Nested<N>{

            private final PodTemplateListBuilder builder;
    
            PodTemplateListNestedImpl(){
                    this.builder = new PodTemplateListBuilder(this);
            }
            PodTemplateListNestedImpl(PodTemplateList item){
                    this.builder = new PodTemplateListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPodTemplateList(builder.build());
    }
    public N endPodTemplateList(){
            return and();
    }

}
    public class PolicyNestedImpl<N> extends PolicyFluentImpl<KubeSchemaFluent.PolicyNested<N>> implements KubeSchemaFluent.PolicyNested<N>,Nested<N>{

            private final PolicyBuilder builder;
    
            PolicyNestedImpl(){
                    this.builder = new PolicyBuilder(this);
            }
            PolicyNestedImpl(Policy item){
                    this.builder = new PolicyBuilder(this, item);
            }
    
    public N endPolicy(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPolicy(builder.build());
    }

}
    public class PolicyBindingNestedImpl<N> extends PolicyBindingFluentImpl<KubeSchemaFluent.PolicyBindingNested<N>> implements KubeSchemaFluent.PolicyBindingNested<N>,Nested<N>{

            private final PolicyBindingBuilder builder;
    
            PolicyBindingNestedImpl(){
                    this.builder = new PolicyBindingBuilder(this);
            }
            PolicyBindingNestedImpl(PolicyBinding item){
                    this.builder = new PolicyBindingBuilder(this, item);
            }
    
    public N endPolicyBinding(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPolicyBinding(builder.build());
    }

}
    public class PolicyBindingListNestedImpl<N> extends PolicyBindingListFluentImpl<KubeSchemaFluent.PolicyBindingListNested<N>> implements KubeSchemaFluent.PolicyBindingListNested<N>,Nested<N>{

            private final PolicyBindingListBuilder builder;
    
            PolicyBindingListNestedImpl(){
                    this.builder = new PolicyBindingListBuilder(this);
            }
            PolicyBindingListNestedImpl(PolicyBindingList item){
                    this.builder = new PolicyBindingListBuilder(this, item);
            }
    
    public N endPolicyBindingList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPolicyBindingList(builder.build());
    }

}
    public class PolicyListNestedImpl<N> extends PolicyListFluentImpl<KubeSchemaFluent.PolicyListNested<N>> implements KubeSchemaFluent.PolicyListNested<N>,Nested<N>{

            private final PolicyListBuilder builder;
    
            PolicyListNestedImpl(){
                    this.builder = new PolicyListBuilder(this);
            }
            PolicyListNestedImpl(PolicyList item){
                    this.builder = new PolicyListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withPolicyList(builder.build());
    }
    public N endPolicyList(){
            return and();
    }

}
    public class ProjectNestedImpl<N> extends ProjectFluentImpl<KubeSchemaFluent.ProjectNested<N>> implements KubeSchemaFluent.ProjectNested<N>,Nested<N>{

            private final ProjectBuilder builder;
    
            ProjectNestedImpl(){
                    this.builder = new ProjectBuilder(this);
            }
            ProjectNestedImpl(Project item){
                    this.builder = new ProjectBuilder(this, item);
            }
    
    public N endProject(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withProject(builder.build());
    }

}
    public class ProjectListNestedImpl<N> extends ProjectListFluentImpl<KubeSchemaFluent.ProjectListNested<N>> implements KubeSchemaFluent.ProjectListNested<N>,Nested<N>{

            private final ProjectListBuilder builder;
    
            ProjectListNestedImpl(){
                    this.builder = new ProjectListBuilder(this);
            }
            ProjectListNestedImpl(ProjectList item){
                    this.builder = new ProjectListBuilder(this, item);
            }
    
    public N endProjectList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withProjectList(builder.build());
    }

}
    public class ProjectRequestNestedImpl<N> extends ProjectRequestFluentImpl<KubeSchemaFluent.ProjectRequestNested<N>> implements KubeSchemaFluent.ProjectRequestNested<N>,Nested<N>{

            private final ProjectRequestBuilder builder;
    
            ProjectRequestNestedImpl(){
                    this.builder = new ProjectRequestBuilder(this);
            }
            ProjectRequestNestedImpl(ProjectRequest item){
                    this.builder = new ProjectRequestBuilder(this, item);
            }
    
    public N endProjectRequest(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withProjectRequest(builder.build());
    }

}
    public class QuantityNestedImpl<N> extends QuantityFluentImpl<KubeSchemaFluent.QuantityNested<N>> implements KubeSchemaFluent.QuantityNested<N>,Nested<N>{

            private final QuantityBuilder builder;
    
            QuantityNestedImpl(){
                    this.builder = new QuantityBuilder(this);
            }
            QuantityNestedImpl(Quantity item){
                    this.builder = new QuantityBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withQuantity(builder.build());
    }
    public N endQuantity(){
            return and();
    }

}
    public class ReplicaSetNestedImpl<N> extends ReplicaSetFluentImpl<KubeSchemaFluent.ReplicaSetNested<N>> implements KubeSchemaFluent.ReplicaSetNested<N>,Nested<N>{

            private final ReplicaSetBuilder builder;
    
            ReplicaSetNestedImpl(){
                    this.builder = new ReplicaSetBuilder(this);
            }
            ReplicaSetNestedImpl(ReplicaSet item){
                    this.builder = new ReplicaSetBuilder(this, item);
            }
    
    public N endReplicaSet(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withReplicaSet(builder.build());
    }

}
    public class ReplicaSetListNestedImpl<N> extends ReplicaSetListFluentImpl<KubeSchemaFluent.ReplicaSetListNested<N>> implements KubeSchemaFluent.ReplicaSetListNested<N>,Nested<N>{

            private final ReplicaSetListBuilder builder;
    
            ReplicaSetListNestedImpl(){
                    this.builder = new ReplicaSetListBuilder(this);
            }
            ReplicaSetListNestedImpl(ReplicaSetList item){
                    this.builder = new ReplicaSetListBuilder(this, item);
            }
    
    public N endReplicaSetList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withReplicaSetList(builder.build());
    }

}
    public class ReplicationControllerListNestedImpl<N> extends ReplicationControllerListFluentImpl<KubeSchemaFluent.ReplicationControllerListNested<N>> implements KubeSchemaFluent.ReplicationControllerListNested<N>,Nested<N>{

            private final ReplicationControllerListBuilder builder;
    
            ReplicationControllerListNestedImpl(){
                    this.builder = new ReplicationControllerListBuilder(this);
            }
            ReplicationControllerListNestedImpl(ReplicationControllerList item){
                    this.builder = new ReplicationControllerListBuilder(this, item);
            }
    
    public N endReplicationControllerList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withReplicationControllerList(builder.build());
    }

}
    public class ResourceQuotaNestedImpl<N> extends ResourceQuotaFluentImpl<KubeSchemaFluent.ResourceQuotaNested<N>> implements KubeSchemaFluent.ResourceQuotaNested<N>,Nested<N>{

            private final ResourceQuotaBuilder builder;
    
            ResourceQuotaNestedImpl(){
                    this.builder = new ResourceQuotaBuilder(this);
            }
            ResourceQuotaNestedImpl(ResourceQuota item){
                    this.builder = new ResourceQuotaBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withResourceQuota(builder.build());
    }
    public N endResourceQuota(){
            return and();
    }

}
    public class ResourceQuotaListNestedImpl<N> extends ResourceQuotaListFluentImpl<KubeSchemaFluent.ResourceQuotaListNested<N>> implements KubeSchemaFluent.ResourceQuotaListNested<N>,Nested<N>{

            private final ResourceQuotaListBuilder builder;
    
            ResourceQuotaListNestedImpl(){
                    this.builder = new ResourceQuotaListBuilder(this);
            }
            ResourceQuotaListNestedImpl(ResourceQuotaList item){
                    this.builder = new ResourceQuotaListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withResourceQuotaList(builder.build());
    }
    public N endResourceQuotaList(){
            return and();
    }

}
    public class RoleNestedImpl<N> extends RoleFluentImpl<KubeSchemaFluent.RoleNested<N>> implements KubeSchemaFluent.RoleNested<N>,Nested<N>{

            private final RoleBuilder builder;
    
            RoleNestedImpl(){
                    this.builder = new RoleBuilder(this);
            }
            RoleNestedImpl(Role item){
                    this.builder = new RoleBuilder(this, item);
            }
    
    public N endRole(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withRole(builder.build());
    }

}
    public class RoleBindingNestedImpl<N> extends RoleBindingFluentImpl<KubeSchemaFluent.RoleBindingNested<N>> implements KubeSchemaFluent.RoleBindingNested<N>,Nested<N>{

            private final RoleBindingBuilder builder;
    
            RoleBindingNestedImpl(){
                    this.builder = new RoleBindingBuilder(this);
            }
            RoleBindingNestedImpl(RoleBinding item){
                    this.builder = new RoleBindingBuilder(this, item);
            }
    
    public N endRoleBinding(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withRoleBinding(builder.build());
    }

}
    public class RoleBindingListNestedImpl<N> extends RoleBindingListFluentImpl<KubeSchemaFluent.RoleBindingListNested<N>> implements KubeSchemaFluent.RoleBindingListNested<N>,Nested<N>{

            private final RoleBindingListBuilder builder;
    
            RoleBindingListNestedImpl(){
                    this.builder = new RoleBindingListBuilder(this);
            }
            RoleBindingListNestedImpl(RoleBindingList item){
                    this.builder = new RoleBindingListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withRoleBindingList(builder.build());
    }
    public N endRoleBindingList(){
            return and();
    }

}
    public class RoleListNestedImpl<N> extends RoleListFluentImpl<KubeSchemaFluent.RoleListNested<N>> implements KubeSchemaFluent.RoleListNested<N>,Nested<N>{

            private final RoleListBuilder builder;
    
            RoleListNestedImpl(){
                    this.builder = new RoleListBuilder(this);
            }
            RoleListNestedImpl(RoleList item){
                    this.builder = new RoleListBuilder(this, item);
            }
    
    public N endRoleList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withRoleList(builder.build());
    }

}
    public class RootPathsNestedImpl<N> extends RootPathsFluentImpl<KubeSchemaFluent.RootPathsNested<N>> implements KubeSchemaFluent.RootPathsNested<N>,Nested<N>{

            private final RootPathsBuilder builder;
    
            RootPathsNestedImpl(){
                    this.builder = new RootPathsBuilder(this);
            }
            RootPathsNestedImpl(RootPaths item){
                    this.builder = new RootPathsBuilder(this, item);
            }
    
    public N endRootPaths(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withRootPaths(builder.build());
    }

}
    public class RouteListNestedImpl<N> extends RouteListFluentImpl<KubeSchemaFluent.RouteListNested<N>> implements KubeSchemaFluent.RouteListNested<N>,Nested<N>{

            private final RouteListBuilder builder;
    
            RouteListNestedImpl(RouteList item){
                    this.builder = new RouteListBuilder(this, item);
            }
            RouteListNestedImpl(){
                    this.builder = new RouteListBuilder(this);
            }
    
    public N endRouteList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withRouteList(builder.build());
    }

}
    public class ScaleNestedImpl<N> extends ScaleFluentImpl<KubeSchemaFluent.ScaleNested<N>> implements KubeSchemaFluent.ScaleNested<N>,Nested<N>{

            private final ScaleBuilder builder;
    
            ScaleNestedImpl(){
                    this.builder = new ScaleBuilder(this);
            }
            ScaleNestedImpl(Scale item){
                    this.builder = new ScaleBuilder(this, item);
            }
    
    public N endScale(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withScale(builder.build());
    }

}
    public class SecretNestedImpl<N> extends SecretFluentImpl<KubeSchemaFluent.SecretNested<N>> implements KubeSchemaFluent.SecretNested<N>,Nested<N>{

            private final SecretBuilder builder;
    
            SecretNestedImpl(){
                    this.builder = new SecretBuilder(this);
            }
            SecretNestedImpl(Secret item){
                    this.builder = new SecretBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret(){
            return and();
    }

}
    public class SecretListNestedImpl<N> extends SecretListFluentImpl<KubeSchemaFluent.SecretListNested<N>> implements KubeSchemaFluent.SecretListNested<N>,Nested<N>{

            private final SecretListBuilder builder;
    
            SecretListNestedImpl(){
                    this.builder = new SecretListBuilder(this);
            }
            SecretListNestedImpl(SecretList item){
                    this.builder = new SecretListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withSecretList(builder.build());
    }
    public N endSecretList(){
            return and();
    }

}
    public class SecurityContextConstraintsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<KubeSchemaFluent.SecurityContextConstraintsNested<N>> implements KubeSchemaFluent.SecurityContextConstraintsNested<N>,Nested<N>{

            private final SecurityContextConstraintsBuilder builder;
    
            SecurityContextConstraintsNestedImpl(){
                    this.builder = new SecurityContextConstraintsBuilder(this);
            }
            SecurityContextConstraintsNestedImpl(SecurityContextConstraints item){
                    this.builder = new SecurityContextConstraintsBuilder(this, item);
            }
    
    public N endSecurityContextConstraints(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withSecurityContextConstraints(builder.build());
    }

}
    public class SecurityContextConstraintsListNestedImpl<N> extends SecurityContextConstraintsListFluentImpl<KubeSchemaFluent.SecurityContextConstraintsListNested<N>> implements KubeSchemaFluent.SecurityContextConstraintsListNested<N>,Nested<N>{

            private final SecurityContextConstraintsListBuilder builder;
    
            SecurityContextConstraintsListNestedImpl(SecurityContextConstraintsList item){
                    this.builder = new SecurityContextConstraintsListBuilder(this, item);
            }
            SecurityContextConstraintsListNestedImpl(){
                    this.builder = new SecurityContextConstraintsListBuilder(this);
            }
    
    public N endSecurityContextConstraintsList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withSecurityContextConstraintsList(builder.build());
    }

}
    public class ServiceAccountNestedImpl<N> extends ServiceAccountFluentImpl<KubeSchemaFluent.ServiceAccountNested<N>> implements KubeSchemaFluent.ServiceAccountNested<N>,Nested<N>{

            private final ServiceAccountBuilder builder;
    
            ServiceAccountNestedImpl(){
                    this.builder = new ServiceAccountBuilder(this);
            }
            ServiceAccountNestedImpl(ServiceAccount item){
                    this.builder = new ServiceAccountBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withServiceAccount(builder.build());
    }
    public N endServiceAccount(){
            return and();
    }

}
    public class ServiceAccountListNestedImpl<N> extends ServiceAccountListFluentImpl<KubeSchemaFluent.ServiceAccountListNested<N>> implements KubeSchemaFluent.ServiceAccountListNested<N>,Nested<N>{

            private final ServiceAccountListBuilder builder;
    
            ServiceAccountListNestedImpl(){
                    this.builder = new ServiceAccountListBuilder(this);
            }
            ServiceAccountListNestedImpl(ServiceAccountList item){
                    this.builder = new ServiceAccountListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withServiceAccountList(builder.build());
    }
    public N endServiceAccountList(){
            return and();
    }

}
    public class ServiceListNestedImpl<N> extends ServiceListFluentImpl<KubeSchemaFluent.ServiceListNested<N>> implements KubeSchemaFluent.ServiceListNested<N>,Nested<N>{

            private final ServiceListBuilder builder;
    
            ServiceListNestedImpl(){
                    this.builder = new ServiceListBuilder(this);
            }
            ServiceListNestedImpl(ServiceList item){
                    this.builder = new ServiceListBuilder(this, item);
            }
    
    public N endServiceList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withServiceList(builder.build());
    }

}
    public class StatusNestedImpl<N> extends StatusFluentImpl<KubeSchemaFluent.StatusNested<N>> implements KubeSchemaFluent.StatusNested<N>,Nested<N>{

            private final StatusBuilder builder;
    
            StatusNestedImpl(){
                    this.builder = new StatusBuilder(this);
            }
            StatusNestedImpl(Status item){
                    this.builder = new StatusBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}
    public class SubjectAccessReviewNestedImpl<N> extends SubjectAccessReviewFluentImpl<KubeSchemaFluent.SubjectAccessReviewNested<N>> implements KubeSchemaFluent.SubjectAccessReviewNested<N>,Nested<N>{

            private final SubjectAccessReviewBuilder builder;
    
            SubjectAccessReviewNestedImpl(){
                    this.builder = new SubjectAccessReviewBuilder(this);
            }
            SubjectAccessReviewNestedImpl(SubjectAccessReview item){
                    this.builder = new SubjectAccessReviewBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withSubjectAccessReview(builder.build());
    }
    public N endSubjectAccessReview(){
            return and();
    }

}
    public class SubjectAccessReviewResponseNestedImpl<N> extends SubjectAccessReviewResponseFluentImpl<KubeSchemaFluent.SubjectAccessReviewResponseNested<N>> implements KubeSchemaFluent.SubjectAccessReviewResponseNested<N>,Nested<N>{

            private final SubjectAccessReviewResponseBuilder builder;
    
            SubjectAccessReviewResponseNestedImpl(){
                    this.builder = new SubjectAccessReviewResponseBuilder(this);
            }
            SubjectAccessReviewResponseNestedImpl(SubjectAccessReviewResponse item){
                    this.builder = new SubjectAccessReviewResponseBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withSubjectAccessReviewResponse(builder.build());
    }
    public N endSubjectAccessReviewResponse(){
            return and();
    }

}
    public class TagEventNestedImpl<N> extends TagEventFluentImpl<KubeSchemaFluent.TagEventNested<N>> implements KubeSchemaFluent.TagEventNested<N>,Nested<N>{

            private final TagEventBuilder builder;
    
            TagEventNestedImpl(){
                    this.builder = new TagEventBuilder(this);
            }
            TagEventNestedImpl(TagEvent item){
                    this.builder = new TagEventBuilder(this, item);
            }
    
    public N endTagEvent(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withTagEvent(builder.build());
    }

}
    public class TemplateNestedImpl<N> extends TemplateFluentImpl<KubeSchemaFluent.TemplateNested<N>> implements KubeSchemaFluent.TemplateNested<N>,Nested<N>{

            private final TemplateBuilder builder;
    
            TemplateNestedImpl(){
                    this.builder = new TemplateBuilder(this);
            }
            TemplateNestedImpl(Template item){
                    this.builder = new TemplateBuilder(this, item);
            }
    
    public N endTemplate(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withTemplate(builder.build());
    }

}
    public class TemplateListNestedImpl<N> extends TemplateListFluentImpl<KubeSchemaFluent.TemplateListNested<N>> implements KubeSchemaFluent.TemplateListNested<N>,Nested<N>{

            private final TemplateListBuilder builder;
    
            TemplateListNestedImpl(TemplateList item){
                    this.builder = new TemplateListBuilder(this, item);
            }
            TemplateListNestedImpl(){
                    this.builder = new TemplateListBuilder(this);
            }
    
    public N endTemplateList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withTemplateList(builder.build());
    }

}
    public class ThirdPartyResourceNestedImpl<N> extends ThirdPartyResourceFluentImpl<KubeSchemaFluent.ThirdPartyResourceNested<N>> implements KubeSchemaFluent.ThirdPartyResourceNested<N>,Nested<N>{

            private final ThirdPartyResourceBuilder builder;
    
            ThirdPartyResourceNestedImpl(){
                    this.builder = new ThirdPartyResourceBuilder(this);
            }
            ThirdPartyResourceNestedImpl(ThirdPartyResource item){
                    this.builder = new ThirdPartyResourceBuilder(this, item);
            }
    
    public N endThirdPartyResource(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withThirdPartyResource(builder.build());
    }

}
    public class ThirdPartyResourceListNestedImpl<N> extends ThirdPartyResourceListFluentImpl<KubeSchemaFluent.ThirdPartyResourceListNested<N>> implements KubeSchemaFluent.ThirdPartyResourceListNested<N>,Nested<N>{

            private final ThirdPartyResourceListBuilder builder;
    
            ThirdPartyResourceListNestedImpl(){
                    this.builder = new ThirdPartyResourceListBuilder(this);
            }
            ThirdPartyResourceListNestedImpl(ThirdPartyResourceList item){
                    this.builder = new ThirdPartyResourceListBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withThirdPartyResourceList(builder.build());
    }
    public N endThirdPartyResourceList(){
            return and();
    }

}
    public class UserNestedImpl<N> extends UserFluentImpl<KubeSchemaFluent.UserNested<N>> implements KubeSchemaFluent.UserNested<N>,Nested<N>{

            private final UserBuilder builder;
    
            UserNestedImpl(){
                    this.builder = new UserBuilder(this);
            }
            UserNestedImpl(User item){
                    this.builder = new UserBuilder(this, item);
            }
    
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withUser(builder.build());
    }
    public N endUser(){
            return and();
    }

}
    public class UserListNestedImpl<N> extends UserListFluentImpl<KubeSchemaFluent.UserListNested<N>> implements KubeSchemaFluent.UserListNested<N>,Nested<N>{

            private final UserListBuilder builder;
    
            UserListNestedImpl(){
                    this.builder = new UserListBuilder(this);
            }
            UserListNestedImpl(UserList item){
                    this.builder = new UserListBuilder(this, item);
            }
    
    public N endUserList(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withUserList(builder.build());
    }

}
    public class WatchEventNestedImpl<N> extends WatchEventFluentImpl<KubeSchemaFluent.WatchEventNested<N>> implements KubeSchemaFluent.WatchEventNested<N>,Nested<N>{

            private final WatchEventBuilder builder;
    
            WatchEventNestedImpl(){
                    this.builder = new WatchEventBuilder(this);
            }
            WatchEventNestedImpl(WatchEvent item){
                    this.builder = new WatchEventBuilder(this, item);
            }
    
    public N endWatchEvent(){
            return and();
    }
    public N and(){
            return (N) KubeSchemaFluentImpl.this.withWatchEvent(builder.build());
    }

}


}
