package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class PersistentVolumeClaimVolumeSourceBuilder extends PersistentVolumeClaimVolumeSourceFluentImpl<PersistentVolumeClaimVolumeSourceBuilder> implements VisitableBuilder<PersistentVolumeClaimVolumeSource,PersistentVolumeClaimVolumeSourceBuilder>{

    PersistentVolumeClaimVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public PersistentVolumeClaimVolumeSourceBuilder(){
            this(true);
    }
    public PersistentVolumeClaimVolumeSourceBuilder(Boolean validationEnabled){
            this(new PersistentVolumeClaimVolumeSource(), validationEnabled);
    }
    public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PersistentVolumeClaimVolumeSource(), validationEnabled);
    }
    public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSourceFluent<?> fluent,PersistentVolumeClaimVolumeSource instance){
            this(fluent, instance, true);
    }
    public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSourceFluent<?> fluent,PersistentVolumeClaimVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClaimName(instance.getClaimName()); 
            fluent.withReadOnly(instance.getReadOnly()); 
            this.validationEnabled = validationEnabled; 
    }
    public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSource instance){
            this(instance,true);
    }
    public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClaimName(instance.getClaimName()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.validationEnabled = validationEnabled; 
    }

    public PersistentVolumeClaimVolumeSource build(){
            PersistentVolumeClaimVolumeSource buildable = new PersistentVolumeClaimVolumeSource(fluent.getClaimName(),fluent.isReadOnly());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PersistentVolumeClaimVolumeSourceBuilder that = (PersistentVolumeClaimVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
