package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PodListFluent<A extends PodListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Pod... items);
    public A removeFromItems(Pod... items);
    public List<Pod> getItems();
    public A withItems(List<Pod> items);
    public A withItems(Pod... items);
    public PodListFluent.ItemsNested<A> addNewItem();
    public PodListFluent.ItemsNested<A> addNewItemLike(Pod item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public PodListFluent.MetadataNested<A> withNewMetadata();
    public PodListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PodListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,PodFluent<PodListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<PodListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
