package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.List;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PodSecurityContextFluent<A extends PodSecurityContextFluent<A>> extends Fluent<A>{


    public Long getFsGroup();
    public A withFsGroup(Long fsGroup);
    public Boolean isRunAsNonRoot();
    public A withRunAsNonRoot(Boolean runAsNonRoot);
    public Long getRunAsUser();
    public A withRunAsUser(Long runAsUser);
    public SELinuxOptions getSeLinuxOptions();
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions);
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions();
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item);
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions();
    public A withNewSeLinuxOptions(String level,String role,String type,String user);
    public A addToSupplementalGroups(Long... items);
    public A removeFromSupplementalGroups(Long... items);
    public List<Long> getSupplementalGroups();
    public A withSupplementalGroups(List<Long> supplementalGroups);
    public A withSupplementalGroups(Long... supplementalGroups);

    public interface SeLinuxOptionsNested<N> extends Nested<N>,SELinuxOptionsFluent<PodSecurityContextFluent.SeLinuxOptionsNested<N>>{

        
    public N endSeLinuxOptions();    public N and();
}


}
