package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Long;
import java.lang.Object;

public class RunAsUserStrategyOptionsFluentImpl<A extends RunAsUserStrategyOptionsFluent<A>> extends BaseFluent<A> implements RunAsUserStrategyOptionsFluent<A>{

    private String type;
    private Long uid;
    private Long uidRangeMax;
    private Long uidRangeMin;

    public RunAsUserStrategyOptionsFluentImpl(){
    }
    public RunAsUserStrategyOptionsFluentImpl(RunAsUserStrategyOptions instance){
            this.withType(instance.getType()); 
            this.withUid(instance.getUid()); 
            this.withUidRangeMax(instance.getUidRangeMax()); 
            this.withUidRangeMin(instance.getUidRangeMin()); 
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Long getUid(){
            return this.uid;
    }

    public A withUid(Long uid){
            this.uid=uid; return (A) this;
    }

    public Long getUidRangeMax(){
            return this.uidRangeMax;
    }

    public A withUidRangeMax(Long uidRangeMax){
            this.uidRangeMax=uidRangeMax; return (A) this;
    }

    public Long getUidRangeMin(){
            return this.uidRangeMin;
    }

    public A withUidRangeMin(Long uidRangeMin){
            this.uidRangeMin=uidRangeMin; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RunAsUserStrategyOptionsFluentImpl that = (RunAsUserStrategyOptionsFluentImpl) o;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
            if (uidRangeMax != null ? !uidRangeMax.equals(that.uidRangeMax) :that.uidRangeMax != null) return false;
            if (uidRangeMin != null ? !uidRangeMin.equals(that.uidRangeMin) :that.uidRangeMin != null) return false;
            return true;
    }




}
