package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SecurityContextConstraintsListFluent<A extends SecurityContextConstraintsListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(SecurityContextConstraints... items);
    public A removeFromItems(SecurityContextConstraints... items);
    public List<SecurityContextConstraints> getItems();
    public A withItems(List<SecurityContextConstraints> items);
    public A withItems(SecurityContextConstraints... items);
    public SecurityContextConstraintsListFluent.ItemsNested<A> addNewItem();
    public SecurityContextConstraintsListFluent.ItemsNested<A> addNewItemLike(SecurityContextConstraints item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public SecurityContextConstraintsListFluent.MetadataNested<A> withNewMetadata();
    public SecurityContextConstraintsListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public SecurityContextConstraintsListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,SecurityContextConstraintsFluent<SecurityContextConstraintsListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<SecurityContextConstraintsListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
