package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public class ServicePortFluentImpl<A extends ServicePortFluent<A>> extends BaseFluent<A> implements ServicePortFluent<A>{

    private String name;
    private Integer nodePort;
    private Integer port;
    private String protocol;
    private VisitableBuilder<? extends IntOrString,?> targetPort;

    public ServicePortFluentImpl(){
    }
    public ServicePortFluentImpl(ServicePort instance){
            this.withName(instance.getName()); 
            this.withNodePort(instance.getNodePort()); 
            this.withPort(instance.getPort()); 
            this.withProtocol(instance.getProtocol()); 
            this.withTargetPort(instance.getTargetPort()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Integer getNodePort(){
            return this.nodePort;
    }

    public A withNodePort(Integer nodePort){
            this.nodePort=nodePort; return (A) this;
    }

    public Integer getPort(){
            return this.port;
    }

    public A withPort(Integer port){
            this.port=port; return (A) this;
    }

    public String getProtocol(){
            return this.protocol;
    }

    public A withProtocol(String protocol){
            this.protocol=protocol; return (A) this;
    }

    public IntOrString getTargetPort(){
            return this.targetPort!=null?this.targetPort.build():null;
    }

    public A withTargetPort(IntOrString targetPort){
            if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.add(this.targetPort);} return (A) this;
    }

    public ServicePortFluent.TargetPortNested<A> withNewTargetPort(){
            return new TargetPortNestedImpl();
    }

    public ServicePortFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item){
            return new TargetPortNestedImpl(item);
    }

    public ServicePortFluent.TargetPortNested<A> editTargetPort(){
            return withNewTargetPortLike(getTargetPort());
    }

    public A withNewTargetPort(String strVal){
            return (A)withTargetPort(new IntOrString(strVal));
    }

    public A withNewTargetPort(Integer intVal){
            return (A)withTargetPort(new IntOrString(intVal));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServicePortFluentImpl that = (ServicePortFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (nodePort != null ? !nodePort.equals(that.nodePort) :that.nodePort != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (protocol != null ? !protocol.equals(that.protocol) :that.protocol != null) return false;
            if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
            return true;
    }


    public class TargetPortNestedImpl<N> extends IntOrStringFluentImpl<ServicePortFluent.TargetPortNested<N>> implements ServicePortFluent.TargetPortNested<N>,Nested<N>{

            private final IntOrStringBuilder builder;
    
            TargetPortNestedImpl(){
                    this.builder = new IntOrStringBuilder(this);
            }
            TargetPortNestedImpl(IntOrString item){
                    this.builder = new IntOrStringBuilder(this, item);
            }
    
    public N endTargetPort(){
            return and();
    }
    public N and(){
            return (N) ServicePortFluentImpl.this.withTargetPort(builder.build());
    }

}


}
