package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.Map;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Long;
import io.fabric8.kubernetes.api.builder.Nested;

public interface DeploymentRollbackFluent<A extends DeploymentRollbackFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public String getName();
    public A withName(String name);
    public RollbackConfig getRollbackTo();
    public A withRollbackTo(RollbackConfig rollbackTo);
    public DeploymentRollbackFluent.RollbackToNested<A> withNewRollbackTo();
    public DeploymentRollbackFluent.RollbackToNested<A> withNewRollbackToLike(RollbackConfig item);
    public DeploymentRollbackFluent.RollbackToNested<A> editRollbackTo();
    public A withNewRollbackTo(Long revision);
    public A addToUpdatedAnnotations(String key,String value);
    public A addToUpdatedAnnotations(Map<String,String> map);
    public A removeFromUpdatedAnnotations(String key);
    public A removeFromUpdatedAnnotations(Map<String,String> map);
    public Map<String,String> getUpdatedAnnotations();
    public A withUpdatedAnnotations(Map<String,String> updatedAnnotations);

    public interface RollbackToNested<N> extends Nested<N>,RollbackConfigFluent<DeploymentRollbackFluent.RollbackToNested<N>>{

        
    public N endRollbackTo();    public N and();
}


}
