package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Integer;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface HorizontalPodAutoscalerSpecFluent<A extends HorizontalPodAutoscalerSpecFluent<A>> extends Fluent<A>{


    public CPUTargetUtilization getCpuUtilization();
    public A withCpuUtilization(CPUTargetUtilization cpuUtilization);
    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> withNewCpuUtilization();
    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> withNewCpuUtilizationLike(CPUTargetUtilization item);
    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> editCpuUtilization();
    public A withNewCpuUtilization(Integer targetPercentage);
    public Integer getMaxReplicas();
    public A withMaxReplicas(Integer maxReplicas);
    public Integer getMinReplicas();
    public A withMinReplicas(Integer minReplicas);
    public SubresourceReference getScaleRef();
    public A withScaleRef(SubresourceReference scaleRef);
    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> withNewScaleRef();
    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> withNewScaleRefLike(SubresourceReference item);
    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> editScaleRef();
    public A withNewScaleRef(String apiVersion,String kind,String name,String subresource);

    public interface CpuUtilizationNested<N> extends Nested<N>,CPUTargetUtilizationFluent<HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<N>>{

        
    public N and();    public N endCpuUtilization();
}
    public interface ScaleRefNested<N> extends Nested<N>,SubresourceReferenceFluent<HorizontalPodAutoscalerSpecFluent.ScaleRefNested<N>>{

        
    public N endScaleRef();    public N and();
}


}
