package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import java.lang.Long;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface ReplicaSetFluent<A extends ReplicaSetFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ReplicaSetFluent.MetadataNested<A> withNewMetadata();
    public ReplicaSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ReplicaSetFluent.MetadataNested<A> editMetadata();
    public ReplicaSetSpec getSpec();
    public A withSpec(ReplicaSetSpec spec);
    public ReplicaSetFluent.SpecNested<A> withNewSpec();
    public ReplicaSetFluent.SpecNested<A> withNewSpecLike(ReplicaSetSpec item);
    public ReplicaSetFluent.SpecNested<A> editSpec();
    public ReplicaSetStatus getStatus();
    public A withStatus(ReplicaSetStatus status);
    public ReplicaSetFluent.StatusNested<A> withNewStatus();
    public ReplicaSetFluent.StatusNested<A> withNewStatusLike(ReplicaSetStatus item);
    public ReplicaSetFluent.StatusNested<A> editStatus();
    public A withNewStatus(Integer fullyLabeledReplicas,Long observedGeneration,Integer replicas);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ReplicaSetFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ReplicaSetSpecFluent<ReplicaSetFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,ReplicaSetStatusFluent<ReplicaSetFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
