package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface DeploymentConfigListFluent<A extends DeploymentConfigListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(DeploymentConfig... items);
    public A removeFromItems(DeploymentConfig... items);
    public List<DeploymentConfig> getItems();
    public A withItems(List<DeploymentConfig> items);
    public A withItems(DeploymentConfig... items);
    public DeploymentConfigListFluent.ItemsNested<A> addNewItem();
    public DeploymentConfigListFluent.ItemsNested<A> addNewItemLike(DeploymentConfig item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public DeploymentConfigListFluent.MetadataNested<A> withNewMetadata();
    public DeploymentConfigListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public DeploymentConfigListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,DeploymentConfigFluent<DeploymentConfigListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<DeploymentConfigListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
