package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class DeploymentTriggerPolicyFluentImpl<A extends DeploymentTriggerPolicyFluent<A>> extends BaseFluent<A> implements DeploymentTriggerPolicyFluent<A>{

    private VisitableBuilder<? extends DeploymentTriggerImageChangeParams,?> imageChangeParams;
    private String type;

    public DeploymentTriggerPolicyFluentImpl(){
    }
    public DeploymentTriggerPolicyFluentImpl(DeploymentTriggerPolicy instance){
            this.withImageChangeParams(instance.getImageChangeParams()); 
            this.withType(instance.getType()); 
    }

    public DeploymentTriggerImageChangeParams getImageChangeParams(){
            return this.imageChangeParams!=null?this.imageChangeParams.build():null;
    }

    public A withImageChangeParams(DeploymentTriggerImageChangeParams imageChangeParams){
            if (imageChangeParams!=null){ this.imageChangeParams= new DeploymentTriggerImageChangeParamsBuilder(imageChangeParams); _visitables.add(this.imageChangeParams);} return (A) this;
    }

    public DeploymentTriggerPolicyFluent.ImageChangeParamsNested<A> withNewImageChangeParams(){
            return new ImageChangeParamsNestedImpl();
    }

    public DeploymentTriggerPolicyFluent.ImageChangeParamsNested<A> withNewImageChangeParamsLike(DeploymentTriggerImageChangeParams item){
            return new ImageChangeParamsNestedImpl(item);
    }

    public DeploymentTriggerPolicyFluent.ImageChangeParamsNested<A> editImageChangeParams(){
            return withNewImageChangeParamsLike(getImageChangeParams());
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentTriggerPolicyFluentImpl that = (DeploymentTriggerPolicyFluentImpl) o;
            if (imageChangeParams != null ? !imageChangeParams.equals(that.imageChangeParams) :that.imageChangeParams != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class ImageChangeParamsNestedImpl<N> extends DeploymentTriggerImageChangeParamsFluentImpl<DeploymentTriggerPolicyFluent.ImageChangeParamsNested<N>> implements DeploymentTriggerPolicyFluent.ImageChangeParamsNested<N>,Nested<N>{

            private final DeploymentTriggerImageChangeParamsBuilder builder;
    
            ImageChangeParamsNestedImpl(){
                    this.builder = new DeploymentTriggerImageChangeParamsBuilder(this);
            }
            ImageChangeParamsNestedImpl(DeploymentTriggerImageChangeParams item){
                    this.builder = new DeploymentTriggerImageChangeParamsBuilder(this, item);
            }
    
    public N and(){
            return (N) DeploymentTriggerPolicyFluentImpl.this.withImageChangeParams(builder.build());
    }
    public N endImageChangeParams(){
            return and();
    }

}


}
