package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface ImageStreamTagFluent<A extends ImageStreamTagFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToConditions(TagEventCondition... items);
    public A removeFromConditions(TagEventCondition... items);
    public List<TagEventCondition> getConditions();
    public A withConditions(List<TagEventCondition> conditions);
    public A withConditions(TagEventCondition... conditions);
    public ImageStreamTagFluent.ConditionsNested<A> addNewCondition();
    public ImageStreamTagFluent.ConditionsNested<A> addNewConditionLike(TagEventCondition item);
    public Long getGeneration();
    public A withGeneration(Long generation);
    public Image getImage();
    public A withImage(Image image);
    public ImageStreamTagFluent.ImageNested<A> withNewImage();
    public ImageStreamTagFluent.ImageNested<A> withNewImageLike(Image item);
    public ImageStreamTagFluent.ImageNested<A> editImage();
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ImageStreamTagFluent.MetadataNested<A> withNewMetadata();
    public ImageStreamTagFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ImageStreamTagFluent.MetadataNested<A> editMetadata();
    public TagReference getTag();
    public A withTag(TagReference tag);
    public ImageStreamTagFluent.TagNested<A> withNewTag();
    public ImageStreamTagFluent.TagNested<A> withNewTagLike(TagReference item);
    public ImageStreamTagFluent.TagNested<A> editTag();

    public interface ConditionsNested<N> extends Nested<N>,TagEventConditionFluent<ImageStreamTagFluent.ConditionsNested<N>>{

        
    public N endCondition();    public N and();
}
    public interface ImageNested<N> extends Nested<N>,ImageFluent<ImageStreamTagFluent.ImageNested<N>>{

        
    public N and();    public N endImage();
}
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ImageStreamTagFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface TagNested<N> extends Nested<N>,TagReferenceFluent<ImageStreamTagFluent.TagNested<N>>{

        
    public N endTag();    public N and();
}


}
