package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamedRoleBindingFluentImpl<A extends NamedRoleBindingFluent<A>> extends BaseFluent<A> implements NamedRoleBindingFluent<A>{

    private String name;
    private VisitableBuilder<? extends RoleBinding,?> roleBinding;

    public NamedRoleBindingFluentImpl(){
    }
    public NamedRoleBindingFluentImpl(NamedRoleBinding instance){
            this.withName(instance.getName()); 
            this.withRoleBinding(instance.getRoleBinding()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public RoleBinding getRoleBinding(){
            return this.roleBinding!=null?this.roleBinding.build():null;
    }

    public A withRoleBinding(RoleBinding roleBinding){
            if (roleBinding!=null){ this.roleBinding= new RoleBindingBuilder(roleBinding); _visitables.add(this.roleBinding);} return (A) this;
    }

    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBinding(){
            return new RoleBindingNestedImpl();
    }

    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBindingLike(RoleBinding item){
            return new RoleBindingNestedImpl(item);
    }

    public NamedRoleBindingFluent.RoleBindingNested<A> editRoleBinding(){
            return withNewRoleBindingLike(getRoleBinding());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedRoleBindingFluentImpl that = (NamedRoleBindingFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (roleBinding != null ? !roleBinding.equals(that.roleBinding) :that.roleBinding != null) return false;
            return true;
    }


    public class RoleBindingNestedImpl<N> extends RoleBindingFluentImpl<NamedRoleBindingFluent.RoleBindingNested<N>> implements NamedRoleBindingFluent.RoleBindingNested<N>,Nested<N>{

            private final RoleBindingBuilder builder;
    
            RoleBindingNestedImpl(){
                    this.builder = new RoleBindingBuilder(this);
            }
            RoleBindingNestedImpl(RoleBinding item){
                    this.builder = new RoleBindingBuilder(this, item);
            }
    
    public N endRoleBinding(){
            return and();
    }
    public N and(){
            return (N) NamedRoleBindingFluentImpl.this.withRoleBinding(builder.build());
    }

}


}
