package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface OAuthClientListFluent<A extends OAuthClientListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(OAuthClient... items);
    public A removeFromItems(OAuthClient... items);
    public List<OAuthClient> getItems();
    public A withItems(List<OAuthClient> items);
    public A withItems(OAuthClient... items);
    public OAuthClientListFluent.ItemsNested<A> addNewItem();
    public OAuthClientListFluent.ItemsNested<A> addNewItemLike(OAuthClient item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public OAuthClientListFluent.MetadataNested<A> withNewMetadata();
    public OAuthClientListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public OAuthClientListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,OAuthClientFluent<OAuthClientListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<OAuthClientListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
