package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class RoleListBuilder extends RoleListFluentImpl<RoleListBuilder> implements VisitableBuilder<RoleList,RoleListBuilder>{

    RoleListFluent<?> fluent;
    Boolean validationEnabled;

    public RoleListBuilder(){
            this(true);
    }
    public RoleListBuilder(Boolean validationEnabled){
            this(new RoleList(), validationEnabled);
    }
    public RoleListBuilder(RoleListFluent<?> fluent){
            this(fluent, true);
    }
    public RoleListBuilder(RoleListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RoleList(), validationEnabled);
    }
    public RoleListBuilder(RoleListFluent<?> fluent,RoleList instance){
            this(fluent, instance, true);
    }
    public RoleListBuilder(RoleListFluent<?> fluent,RoleList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public RoleListBuilder(RoleList instance){
            this(instance,true);
    }
    public RoleListBuilder(RoleList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public RoleList build(){
            RoleList buildable = new RoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RoleListBuilder that = (RoleListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
